/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.serenitybdd.core.exceptions.SerenityManagedException;
import net.serenitybdd.core.exceptions.TheErrorType;
import net.serenitybdd.core.model.FailureDetails;
import net.serenitybdd.core.time.SystemClock;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.TestAnnotations;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.images.ResizableImage;
import net.thucydides.core.issues.IssueKeyFormat;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.DataTableRow;
import net.thucydides.core.model.FeatureTagAsDefined;
import net.thucydides.core.model.HeuristicTestResult;
import net.thucydides.core.model.PackageBasedLeafRequirements;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestDuration;
import net.thucydides.core.model.TestOutcomeAnnotationReader;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultComparison;
import net.thucydides.core.model.TestResultList;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.model.TestType;
import net.thucydides.core.model.TitleBuilder;
import net.thucydides.core.model.failures.FailureAnalysis;
import net.thucydides.core.model.features.ApplicationFeature;
import net.thucydides.core.model.flags.Flag;
import net.thucydides.core.model.flags.FlagProvider;
import net.thucydides.core.model.results.MergeStepResultStrategy;
import net.thucydides.core.model.results.StepResultMergeStragegy;
import net.thucydides.core.model.screenshots.Screenshot;
import net.thucydides.core.model.stacktrace.FailureCause;
import net.thucydides.core.model.stacktrace.RootCauseAnalyzer;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.reports.json.JSONConverter;
import net.thucydides.core.reports.saucelabs.LinkGenerator;
import net.thucydides.core.screenshots.ScreenshotAndHtmlSource;
import net.thucydides.core.statistics.service.TagProvider;
import net.thucydides.core.statistics.service.TagProviderService;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepFailureException;
import net.thucydides.core.steps.TestFailureCause;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestOutcome {
    private static final String ISSUES = "issues";
    private static final String NEW_LINE = System.getProperty("line.separator");
    @NotNull
    private String name;
    private String id;
    private transient Class<?> testCase;
    private String testCaseName;
    private final List<TestStep> testSteps = new ArrayList<TestStep>();
    private Story userStory;
    private com.google.common.base.Optional<TestTag> featureTag = com.google.common.base.Optional.absent();
    private String title;
    private String description;
    private String backgroundTitle;
    private String backgroundDescription;
    private List<String> coreIssues;
    private List<String> additionalIssues;
    private List<String> coreVersions;
    private List<String> additionalVersions;
    private Set<TestTag> tags;
    private ZonedDateTime startTime;
    private long duration;
    private ZonedDateTime testRunTimestamp;
    private String project;
    private FailureCause testFailureCause;
    private TestFailureCause flakyTestFailureCause;
    private String testFailureClassname;
    private String testFailureMessage;
    private String testFailureSummary;
    private String projectKey;
    private TestResult annotatedResult = null;
    private String sessionId;
    private String driver;
    private transient Stack<TestStep> groupStack = new Stack();
    private transient IssueTracking issueTracking;
    private transient EnvironmentVariables environmentVariables;
    private transient LinkGenerator linkGenerator;
    private transient FlagProvider flagProvider;
    private transient TagProviderService tagProviderService;
    private com.google.common.base.Optional<String> qualifier;
    private String context;
    private DataTable dataTable;
    private boolean manual;
    private Set<? extends Flag> flags;
    private String testSource;
    TestResult result;
    List<String> issues;
    List<String> versions;
    private static final Logger LOGGER = LoggerFactory.getLogger(TestOutcome.class);
    private static final List<String> NO_HEADERS = new ArrayList<String>();

    private TestOutcome() {
        this.groupStack = new Stack();
        this.additionalIssues = new ArrayList<String>();
        this.additionalVersions = new ArrayList<String>();
        this.issueTracking = (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class);
        this.linkGenerator = (LinkGenerator)Injectors.getInjector().getInstance(LinkGenerator.class);
        this.flagProvider = (FlagProvider)Injectors.getInjector().getInstance(FlagProvider.class);
        this.qualifier = com.google.common.base.Optional.absent();
        this.context = null;
        this.groupStack = new Stack();
    }

    public TestOutcome(String name) {
        this(name, null);
    }

    public TestOutcome(String name, Class<?> testCase) {
        this(name, testCase, ConfiguredEnvironment.getEnvironmentVariables());
    }

    private static String identifierFrom(String testName, Class<?> testCase, Story userStory) {
        String identifer = null;
        if (testCase != null) {
            identifer = testCase.getName();
        }
        if (userStory != null) {
            identifer = userStory.getId();
        }
        return (identifer != null ? identifer + ":" : "") + testName;
    }

    public TestOutcome(String name, Class<?> testCase, EnvironmentVariables environmentVariables) {
        this.startTime = ZonedDateTime.now();
        this.name = name;
        this.id = TestOutcome.identifierFrom(name, testCase, this.userStory);
        this.testCase = testCase;
        this.testCaseName = this.nameOf(testCase);
        this.additionalIssues = new ArrayList<String>();
        this.additionalVersions = new ArrayList<String>();
        this.issueTracking = (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class);
        this.linkGenerator = (LinkGenerator)Injectors.getInjector().getInstance(LinkGenerator.class);
        this.flagProvider = (FlagProvider)Injectors.getInjector().getInstance(FlagProvider.class);
        this.qualifier = com.google.common.base.Optional.absent();
        this.environmentVariables = environmentVariables;
        this.context = this.contextFrom(environmentVariables);
        if (testCase != null) {
            this.setUserStory(this.leafRequirementDefinedIn().testCase(testCase));
        }
    }

    private String contextFrom(EnvironmentVariables environmentVariables) {
        return environmentVariables == null ? null : ThucydidesSystemProperty.CONTEXT.from(environmentVariables);
    }

    public static TestOutcomeWithEnvironmentBuilder inEnvironment(EnvironmentVariables environmentVariables) {
        return new TestOutcomeWithEnvironmentBuilder(environmentVariables);
    }

    private PackageBasedLeafRequirements leafRequirementDefinedIn() {
        return new PackageBasedLeafRequirements(this.getEnvironmentVariables());
    }

    public void calculateDynamicFieldValues() {
        this.getTitle();
        this.result = this.getResult();
        this.issues = this.getIssues();
        this.versions = this.getVersions();
        this.tags = this.getTags();
    }

    private String nameOf(Class<?> testCase) {
        if (testCase != null) {
            return testCase.getCanonicalName();
        }
        return null;
    }

    private TagProviderService getTagProviderService() {
        if (this.tagProviderService == null) {
            this.tagProviderService = (TagProviderService)Injectors.getInjector().getInstance(TagProviderService.class);
        }
        return this.tagProviderService;
    }

    public TestOutcome usingIssueTracking(IssueTracking issueTracking) {
        this.issueTracking = issueTracking;
        return this;
    }

    public TestOutcome asManualTest() {
        this.manual = true;
        this.addTag(TestTag.withName("Manual").andType("External Tests"));
        return this;
    }

    public TestOutcome withTestSource(String testSource) {
        this.testSource = testSource;
        return this;
    }

    protected TestOutcome withFlagProvider(FlagProvider flagProvider) {
        this.flagProvider = flagProvider;
        this.flags = null;
        return this;
    }

    public void setEnvironmentVariables(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.context = this.contextFrom(environmentVariables);
    }

    public EnvironmentVariables getEnvironmentVariables() {
        if (this.environmentVariables == null) {
            this.environmentVariables = (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get();
            this.context = this.contextFrom(this.environmentVariables);
        }
        return this.environmentVariables;
    }

    protected TestOutcome(String name, Class<?> testCase, Story userStory) {
        this(name, testCase, userStory, ConfiguredEnvironment.getEnvironmentVariables());
    }

    protected TestOutcome(String name, Class<?> testCase, Story userStory, EnvironmentVariables environmentVariables) {
        this.startTime = ZonedDateTime.now();
        this.name = name;
        this.id = TestOutcome.identifierFrom(name, testCase, userStory);
        this.testCase = testCase;
        this.testCaseName = this.nameOf(testCase);
        this.additionalIssues = new ArrayList<String>();
        this.additionalVersions = new ArrayList<String>();
        if (testCase != null || userStory != null) {
            this.setUserStory((Story)this.storyDefinedIn(testCase).or((Object)userStory));
        }
        this.issueTracking = (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class);
        this.linkGenerator = (LinkGenerator)Injectors.getInjector().getInstance(LinkGenerator.class);
        this.flagProvider = (FlagProvider)Injectors.getInjector().getInstance(FlagProvider.class);
        this.environmentVariables = environmentVariables;
        this.context = this.contextFrom(environmentVariables);
        this.projectKey = ThucydidesSystemProperty.THUCYDIDES_PROJECT_KEY.from(environmentVariables, "");
    }

    private com.google.common.base.Optional<Story> storyDefinedIn(Class<?> testCase) {
        if (testCase == null) {
            return com.google.common.base.Optional.absent();
        }
        return com.google.common.base.Optional.of((Object)this.leafRequirementDefinedIn().testCase(testCase));
    }

    public TestOutcome copy() {
        return new TestOutcome(this.startTime, this.duration, this.title, this.description, this.name, this.id, this.testCase, this.testSteps, this.coreIssues, this.additionalIssues, this.tags, this.userStory, this.testFailureCause, this.testFailureClassname, this.testFailureMessage, this.testFailureSummary, this.annotatedResult, this.dataTable, this.qualifier, this.driver, this.manual, this.projectKey, this.environmentVariables);
    }

    protected TestOutcome(ZonedDateTime startTime, long duration, String title, String description, String name, String id, Class<?> testCase, List<TestStep> testSteps, List<String> issues, List<String> additionalIssues, Set<TestTag> tags, Story userStory, FailureCause testFailureCause, String testFailureClassname, String testFailureMessage, String testFailureSummary, TestResult annotatedResult, DataTable dataTable, com.google.common.base.Optional<String> qualifier, String driver, boolean manualTest, String projectKey, EnvironmentVariables environmentVariables) {
        this.startTime = startTime;
        this.duration = duration;
        this.title = title;
        this.description = description;
        this.name = name;
        this.id = id;
        this.testCase = testCase;
        this.testCaseName = this.nameOf(testCase);
        this.addSteps(testSteps);
        this.coreIssues = this.removeDuplicates(issues);
        this.additionalVersions = this.removeDuplicates(this.additionalVersions);
        this.additionalIssues = additionalIssues;
        this.tags = tags;
        this.setUserStory(userStory);
        this.testFailureCause = testFailureCause;
        this.testFailureClassname = testFailureClassname;
        this.testFailureMessage = testFailureMessage;
        this.testFailureSummary = testFailureSummary;
        this.qualifier = qualifier;
        this.annotatedResult = annotatedResult;
        this.dataTable = dataTable;
        this.issueTracking = (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class);
        this.linkGenerator = (LinkGenerator)Injectors.getInjector().getInstance(LinkGenerator.class);
        this.flagProvider = (FlagProvider)Injectors.getInjector().getInstance(FlagProvider.class);
        this.driver = driver;
        this.manual = manualTest;
        this.projectKey = projectKey;
        this.environmentVariables = environmentVariables;
    }

    private List<String> removeDuplicates(List<String> issues) {
        ArrayList<String> issuesWithNoDuplicates = new ArrayList<String>();
        if (issues != null) {
            for (String issue : issues) {
                if (issuesWithNoDuplicates.contains(issue)) continue;
                issuesWithNoDuplicates.add(issue);
            }
        }
        return issuesWithNoDuplicates;
    }

    public static TestOutcome forTest(String methodName, Class<?> testCase) {
        return new TestOutcome(methodName, testCase);
    }

    public TestOutcome withQualifier(String qualifier) {
        if (qualifier != null) {
            return new TestOutcome(this.startTime, this.duration, this.title, this.description, this.name, this.id, this.testCase, this.testSteps, this.coreIssues, this.additionalIssues, this.tags, this.userStory, this.testFailureCause, this.testFailureClassname, this.testFailureMessage, this.testFailureSummary, this.annotatedResult, this.dataTable, (com.google.common.base.Optional<String>)com.google.common.base.Optional.fromNullable((Object)qualifier), this.driver, this.manual, this.projectKey, this.environmentVariables);
        }
        return this;
    }

    public TestOutcome withIssues(List<String> issues) {
        return new TestOutcome(this.startTime, this.duration, this.title, this.description, this.name, this.id, this.testCase, this.testSteps, (List<String>)(issues == null ? issues : ImmutableList.copyOf(issues)), this.additionalIssues, this.tags, this.userStory, this.testFailureCause, this.testFailureClassname, this.testFailureMessage, this.testFailureSummary, this.annotatedResult, this.dataTable, this.qualifier, this.driver, this.manual, this.projectKey, this.environmentVariables);
    }

    public TestOutcome withTags(Set<TestTag> tags) {
        return new TestOutcome(this.startTime, this.duration, this.title, this.description, this.name, this.id, this.testCase, this.testSteps, this.coreIssues, this.additionalIssues, tags, this.userStory, this.testFailureCause, this.testFailureClassname, this.testFailureMessage, this.testFailureSummary, this.annotatedResult, this.dataTable, this.qualifier, this.driver, this.manual, this.projectKey, this.environmentVariables);
    }

    public TestOutcome withMethodName(String methodName) {
        if (methodName != null) {
            return new TestOutcome(this.startTime, this.duration, this.title, this.description, methodName, TestOutcome.identifierFrom(methodName, this.testCase, this.userStory), this.testCase, this.getTestSteps(), this.coreIssues, this.additionalIssues, this.tags, this.userStory, this.testFailureCause, this.testFailureClassname, this.testFailureMessage, this.testFailureSummary, this.annotatedResult, this.dataTable, this.qualifier, this.driver, this.manual, this.projectKey, this.environmentVariables);
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public static TestOutcome forTestInStory(String testName, Story story) {
        return new TestOutcome(testName, null, story);
    }

    public static TestOutcome forTestInStory(String testName, Class<?> testCase, Story story) {
        return new TestOutcome(testName, testCase, story);
    }

    public String toString() {
        return this.getTitle() + ":" + this.testSteps.stream().map(TestStep::toString).collect(Collectors.joining(", "));
    }

    public String getTitle() {
        if (this.title == null) {
            this.title = this.obtainQualifiedTitleFromAnnotationOrMethodName();
        }
        return this.title;
    }

    public String getTitle(boolean qualified) {
        return qualified ? this.getTitle() : this.getFormatter().stripQualifications(this.getTitle());
    }

    public TitleBuilder getUnqualified() {
        return new TitleBuilder(this, this.issueTracking, this.environmentVariables, false);
    }

    public TitleBuilder getQualified() {
        return new TitleBuilder(this, this.issueTracking, this.environmentVariables, true);
    }

    public void setAllStepsTo(TestResult result) {
        for (TestStep step : this.testSteps) {
            step.setResult(result);
        }
    }

    public void addDataFrom(DataTable newDataTable) {
        if (this.dataTable == null) {
            this.dataTable = DataTable.withHeaders(newDataTable.getHeaders()).build();
        }
        this.dataTable.addRows(newDataTable.getRows());
    }

    public void clearForcedResult() {
        this.annotatedResult = null;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getDriver() {
        return this.driver;
    }

    public void resetFailingStepsCausedBy(Class<? extends Throwable> expected) {
        for (TestStep step : this.testSteps) {
            this.resetFailingStepsIn(step).causedBy(expected);
        }
        this.clearTestFailure();
    }

    private void clearTestFailure() {
        this.testFailureCause = null;
        this.testFailureClassname = null;
        this.testFailureMessage = null;
        this.annotatedResult = null;
    }

    private StepResetBuilder resetFailingStepsIn(TestStep step) {
        return new StepResetBuilder(step);
    }

    public StepReplacer replace(List<TestStep> stepsToMerge) {
        return new StepReplacer(stepsToMerge);
    }

    public void mergeMostRecentSteps(int maxStepsToMerge) {
        Preconditions.checkArgument((maxStepsToMerge > 0 ? 1 : 0) != 0);
        List<TestStep> stepsToMerge = this.getLast(maxStepsToMerge).steps();
        TestStep mergedStep = this.merge(stepsToMerge);
        this.replace(stepsToMerge).with(mergedStep);
    }

    private GetLastStepBuilder getLast(int maxCount) {
        return new GetLastStepBuilder(maxCount);
    }

    public void updateOverallResults() {
        this.updateOverallResultsFor(this.testSteps);
    }

    private void updateOverallResultsFor(List<TestStep> testSteps) {
        for (TestStep testStep : testSteps) {
            this.updateOverallResultsFor(testStep.getChildren());
            this.updateOverallResultsFor(testStep);
        }
    }

    private void updateOverallResultsFor(TestStep testStep) {
        testStep.updateOverallResult();
    }

    public com.google.common.base.Optional<TestStep> getFailingStep() {
        ArrayList stepsInReverseOrder = Lists.newArrayList(this.getFlattenedTestSteps());
        Collections.reverse(stepsInReverseOrder);
        for (TestStep step : stepsInReverseOrder) {
            if (!step.isError().booleanValue() && !step.isFailure().booleanValue()) continue;
            return com.google.common.base.Optional.of((Object)step);
        }
        return com.google.common.base.Optional.absent();
    }

    public String getId() {
        this.updateIdIfNotDefinedForLegacyPersistedFormats();
        return this.id;
    }

    public String getParentId() {
        if (this.id != null && this.id.contains(";")) {
            return (String)Splitter.on((String)";").splitToList((CharSequence)this.id).get(0);
        }
        return null;
    }

    private void updateIdIfNotDefinedForLegacyPersistedFormats() {
        if (this.id == null) {
            this.id = TestOutcome.identifierFrom(this.testCaseName, this.testCase, this.userStory);
        }
    }

    public TestOutcome withId(String id) {
        return new TestOutcome(this.startTime, this.duration, this.title, this.description, this.name, id, this.testCase, this.testSteps, this.coreIssues, this.additionalIssues, this.tags, this.userStory, this.testFailureCause, this.testFailureClassname, this.testFailureMessage, this.testFailureSummary, this.annotatedResult, this.dataTable, this.qualifier, this.driver, this.manual, this.projectKey, this.environmentVariables);
    }

    public void updateTopLevelStepResultsTo(TestResult result) {
        for (TestStep step : this.testSteps) {
            step.setResult(result);
        }
        if (this.dataTable != null) {
            this.dataTable.updateRowResultsTo(result);
        }
    }

    public String getTestFailureSummary() {
        return this.testFailureSummary;
    }

    public TestFailureCause getFlakyTestFailureCause() {
        return this.flakyTestFailureCause;
    }

    public void setFlakyTestFailureCause(TestFailureCause flakyTestFailureCause) {
        this.flakyTestFailureCause = flakyTestFailureCause;
    }

    public boolean hasTagWithName(String tagName) {
        return Optional.ofNullable(this.tags).orElse(Collections.emptySet()).stream().anyMatch(tag -> tag.getName().equalsIgnoreCase(tagName));
    }

    public boolean hasTagWithType(String tagType) {
        return Optional.ofNullable(this.tags).orElse(Collections.emptySet()).stream().anyMatch(tag -> tag.getType().equalsIgnoreCase(tagType));
    }

    public int getDataTableRowCount() {
        if (this.dataTable == null) {
            return 0;
        }
        return this.dataTable.getSize();
    }

    private TestStep merge(List<TestStep> stepsToMerge) {
        TestStep mergedStep = stepsToMerge.get(0);
        for (TestStep nextStep : stepsToMerge.subList(1, stepsToMerge.size())) {
            mergedStep = this.mergeStep(mergedStep).into(nextStep);
        }
        return mergedStep;
    }

    private StepMergeBuilder mergeStep(TestStep step) {
        return new StepMergeBuilder(step);
    }

    private boolean wasUnsuccessful(TestStep previousStep) {
        return previousStep.getResult() == TestResult.ERROR || previousStep.getResult() == TestResult.FAILURE || previousStep.getResult() == TestResult.COMPROMISED;
    }

    public boolean isTitleWithIssues() {
        return !this.getTitle().equalsIgnoreCase(this.getUnqualified().getTitleWithLinks());
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setBackgroundDescription(String description) {
        this.backgroundDescription = description.trim();
    }

    public void setBackgroundTitle(String title) {
        this.backgroundTitle = title.trim();
    }

    public String getDescription() {
        return this.description;
    }

    public String getBackgroundDescription() {
        return this.backgroundDescription;
    }

    public String getBackgroundTitle() {
        return this.backgroundTitle;
    }

    public com.google.common.base.Optional<String> getDescriptionText() {
        if (this.getDescription() != null) {
            return com.google.common.base.Optional.of((Object)this.description);
        }
        if (this.title != null) {
            return this.getDescriptionFrom(this.title);
        }
        return com.google.common.base.Optional.absent();
    }

    private com.google.common.base.Optional<String> getDescriptionFrom(String storedTitle) {
        ArrayList multilineTitle = Lists.newArrayList((Iterable)Splitter.on((Pattern)Pattern.compile("\r?\n")).split((CharSequence)storedTitle));
        if (multilineTitle.size() > 1) {
            multilineTitle.remove(0);
            return com.google.common.base.Optional.of((Object)Joiner.on((String)NEW_LINE).join((Iterable)multilineTitle));
        }
        return com.google.common.base.Optional.absent();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toJson() {
        JSONConverter jsonConverter = (JSONConverter)Injectors.getInjector().getInstance(JSONConverter.class);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            jsonConverter.toJson(this, (OutputStream)outputStream);
            String string = outputStream.toString(Charset.defaultCharset());
            return string;
        }
        catch (IOException e) {
            LOGGER.error("serialization error for testOutcome with name \"" + this.getName() + "\"", (Throwable)e);
            return "";
        }
    }

    public String getTitleWithLinks() {
        return this.getFormatter().addLinks(this.getTitle());
    }

    private Formatter getFormatter() {
        return new Formatter(this.issueTracking);
    }

    private String obtainQualifiedTitleFromAnnotationOrMethodName() {
        String title = "";
        title = this.qualifier != null && this.qualifier.isPresent() ? this.qualified(this.getBaseTitleFromAnnotationOrMethodName()) : this.getBaseTitleFromAnnotationOrMethodName();
        return title;
    }

    private String getBaseTitleFromAnnotationOrMethodName() {
        Optional<String> annotatedTitle = TestAnnotations.forClass(this.testCase).getAnnotatedTitleForMethod(this.name);
        return annotatedTitle.orElse(NameConverter.humanize(NameConverter.withNoArguments(this.name)));
    }

    private String qualified(String rootTitle) {
        return rootTitle + " [" + (String)this.qualifier.get() + "]";
    }

    public String getStoryTitle() {
        return this.userStory != null ? this.getTitleFrom(this.userStory) : "";
    }

    public String getPath() {
        if (this.userStory != null) {
            return this.userStory.getPath();
        }
        return null;
    }

    public String getPathId() {
        if (this.userStory != null) {
            return this.userStory.getId();
        }
        return this.getPath();
    }

    private String getTitleFrom(Story userStory) {
        return userStory.getName() == null ? "" : userStory.getName();
    }

    public String getReportName(ReportType type) {
        return ReportNamer.forReportType(type).getNormalizedTestNameFor(this);
    }

    public String getSimpleReportName(ReportType type) {
        ReportNamer reportNamer = ReportNamer.forReportType(type);
        return reportNamer.getSimpleTestNameFor(this);
    }

    public String getHtmlReport() {
        return this.getReportName(ReportType.HTML);
    }

    public String getReportName() {
        return this.getReportName(ReportType.ROOT);
    }

    public String getScreenshotReportName() {
        return this.getReportName(ReportType.ROOT) + "_screenshots";
    }

    public List<TestStep> getTestSteps() {
        return ImmutableList.copyOf(this.testSteps);
    }

    public boolean hasScreenshots() {
        return !this.getScreenshots().isEmpty();
    }

    public boolean hasRestQueries() {
        for (TestStep step : this.getFlattenedTestSteps()) {
            if (!step.hasRestQuery()) continue;
            return true;
        }
        return false;
    }

    public List<ScreenshotAndHtmlSource> getScreenshotAndHtmlSources() {
        List<TestStep> testStepsWithScreenshots = this.getFlattenedTestSteps();
        return testStepsWithScreenshots.stream().flatMap(testStep -> testStep.getScreenshots().stream()).collect(Collectors.toList());
    }

    public List<Screenshot> getScreenshots() {
        ArrayList<Screenshot> screenshots = new ArrayList<Screenshot>();
        List<TestStep> testStepsWithScreenshots = this.getFlattenedTestSteps();
        for (TestStep currentStep : testStepsWithScreenshots) {
            screenshots.addAll(this.screenshotsIn(currentStep));
        }
        return ImmutableList.copyOf(screenshots);
    }

    private List<Screenshot> screenshotsIn(TestStep currentStep) {
        return currentStep.getScreenshots().stream().map(screenshotAndHtmlSource -> TestOutcome.extractScreenshot(currentStep, screenshotAndHtmlSource)).collect(Collectors.toList());
    }

    public static Screenshot extractScreenshot(TestStep currentStep, ScreenshotAndHtmlSource from) {
        return new Screenshot(from.getScreenshot().getName(), currentStep.getDescription(), TestOutcome.widthOf(from.getScreenshot()), currentStep.getException());
    }

    private static int widthOf(File screenshot) {
        try {
            return new ResizableImage(screenshot).getWidth();
        }
        catch (IOException e) {
            return 960;
        }
    }

    public boolean hasNonStepFailure() {
        boolean stepsContainFailure = false;
        for (TestStep step : this.getFlattenedTestSteps()) {
            if (step.getResult() != TestResult.FAILURE && step.getResult() != TestResult.ERROR && step.getResult() != TestResult.COMPROMISED) continue;
            stepsContainFailure = true;
        }
        return !stepsContainFailure && (this.getResult() == TestResult.ERROR || this.getResult() == TestResult.FAILURE || this.getResult() == TestResult.COMPROMISED);
    }

    public List<TestStep> getFlattenedTestSteps() {
        ArrayList<TestStep> flattenedTestSteps = new ArrayList<TestStep>();
        for (TestStep step : this.getTestSteps()) {
            flattenedTestSteps.add(step);
            if (!step.isAGroup()) continue;
            flattenedTestSteps.addAll(step.getFlattenedSteps());
        }
        return flattenedTestSteps;
    }

    public List<TestStep> getLeafTestSteps() {
        ArrayList<? extends TestStep> leafTestSteps = new ArrayList<TestStep>();
        for (TestStep step : this.getTestSteps()) {
            if (step.isAGroup()) {
                leafTestSteps.addAll(step.getLeafTestSteps());
                continue;
            }
            leafTestSteps.add(step);
        }
        return ImmutableList.copyOf(leafTestSteps);
    }

    public TestResult getResult() {
        if (TestResult.IGNORED == this.annotatedResult || TestResult.SKIPPED == this.annotatedResult || TestResult.PENDING == this.annotatedResult) {
            return this.annotatedResult;
        }
        TestResult testResultFromFailureClassname = this.testResultFromFailureClassname();
        ArrayList overallResults = Lists.newArrayList(this.getCurrentTestResults());
        overallResults.add(testResultFromFailureClassname);
        TestResult testResultFromSteps = TestResultList.overallResultFrom(overallResults);
        return this.annotatedResult != null ? TestResultList.overallResultFrom((List<TestResult>)ImmutableList.of((Object)((Object)testResultFromSteps), (Object)((Object)this.annotatedResult))) : testResultFromSteps;
    }

    private TestResult testResultFromFailureClassname() {
        if (this.testFailureClassname != null) {
            try {
                return new FailureAnalysis().resultFor(Class.forName(this.testFailureClassname));
            }
            catch (ReflectiveOperationException e) {
                return HeuristicTestResult.from(this.testFailureClassname);
            }
        }
        return TestResult.UNDEFINED;
    }

    public TestOutcome recordSteps(List<TestStep> steps) {
        for (TestStep step : steps) {
            this.recordStep(step);
        }
        return this;
    }

    public TestOutcome recordStep(TestStep step) {
        Preconditions.checkNotNull((Object)step.getDescription(), (Object)"The test step description was not defined.");
        if (this.inGroup()) {
            this.getCurrentStepGroup().addChildStep(step);
            this.renumberTestSteps();
        } else {
            this.addStep(step);
        }
        return this;
    }

    private void addStep(TestStep step) {
        this.testSteps.add(step);
        this.renumberTestSteps();
    }

    private void addSteps(List<TestStep> steps) {
        this.testSteps.addAll(steps);
        this.renumberTestSteps();
    }

    private void renumberTestSteps() {
        int count = 1;
        for (TestStep step : this.testSteps) {
            count = step.renumberFrom(count);
        }
    }

    private TestStep getCurrentStepGroup() {
        return this.groupStack.peek();
    }

    private boolean inGroup() {
        return !this.groupStack.empty();
    }

    public ApplicationFeature getFeature() {
        if (this.getUserStory() != null && this.getUserStory().getFeature() != null) {
            return this.getUserStory().getFeature();
        }
        return null;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    private List<TestResult> getCurrentTestResults() {
        return this.testSteps.stream().map(TestStep::getResult).collect(Collectors.toList());
    }

    @Deprecated
    public void startGroup(String groupName) {
        this.recordStep(new TestStep(groupName));
        this.startGroup();
    }

    public com.google.common.base.Optional<String> getQualifier() {
        return this.qualifier;
    }

    public void startGroup() {
        if (!this.testSteps.isEmpty()) {
            this.groupStack.push(this.currentStep());
        }
    }

    public void endGroup() {
        if (!this.groupStack.isEmpty()) {
            this.groupStack.pop();
        }
    }

    public TestStep currentStep() {
        Preconditions.checkState((!this.testSteps.isEmpty() ? 1 : 0) != 0);
        if (!this.inGroup()) {
            return this.lastStepIn(this.testSteps);
        }
        TestStep currentStepGroup = this.groupStack.peek();
        return this.lastStepIn(currentStepGroup.getChildren());
    }

    public TestStep lastStep() {
        Preconditions.checkState((!this.testSteps.isEmpty() ? 1 : 0) != 0);
        if (!this.inGroup()) {
            return this.lastStepIn(this.testSteps);
        }
        TestStep currentStepGroup = this.groupStack.peek();
        return this.lastStepIn(currentStepGroup.getChildren());
    }

    private TestStep lastStepIn(List<TestStep> testSteps) {
        return testSteps.get(testSteps.size() - 1);
    }

    public TestStep currentGroup() {
        Preconditions.checkState((boolean)this.inGroup());
        return this.groupStack.peek();
    }

    public void setUserStory(Story story) {
        this.userStory = story;
        this.featureTag = FeatureTagAsDefined.in(story, this.getPath());
    }

    public void determineTestFailureCause(Throwable cause) {
        if (cause != null) {
            RootCauseAnalyzer rootCauseAnalyser = new RootCauseAnalyzer(SerenityManagedException.detachedCopyOf(cause));
            FailureCause rootCause = rootCauseAnalyser.getRootCause();
            this.testFailureClassname = rootCauseAnalyser.getRootCause().getErrorType();
            this.testFailureMessage = rootCauseAnalyser.getMessage();
            this.testFailureCause = rootCause;
            this.testFailureSummary = this.failureSummaryFrom(rootCause);
            this.setAnnotatedResult(new FailureAnalysis().resultFor(rootCause.exceptionClass()));
        } else {
            this.noTestFailureIsDefined();
        }
    }

    private String failureSummaryFrom(FailureCause rootCause) {
        return String.format("%s;%s;%s;%s", new Object[]{this.getResult(), rootCause.getErrorType(), rootCause.getMessage(), this.stackTraceSourceFrom(rootCause)});
    }

    private String stackTraceSourceFrom(FailureCause rootCause) {
        if (rootCause.getStackTrace().length == 0) {
            return "";
        }
        return rootCause.getStackTrace()[0].getFileName();
    }

    private void noTestFailureIsDefined() {
        this.testFailureCause = null;
        this.testFailureClassname = "";
        this.testFailureMessage = "";
        this.testFailureSummary = "";
    }

    public void appendTestFailure(TestFailureCause failureCause) {
        if (!failureCause.isDefined()) {
            this.noTestFailureIsDefined();
            return;
        }
        if (this.noStepHasFailedSoFar()) {
            this.testFailureClassname = failureCause.getRootCause().getErrorType();
            this.testFailureMessage = failureCause.getTestFailureMessage();
            this.testFailureCause = failureCause.getRootCause();
            this.testFailureSummary = this.failureSummaryFrom(failureCause.getRootCause());
            this.setAnnotatedResult(failureCause.getAnnotatedResult());
        } else if (this.isMoreSevereThanPreviousErrors(failureCause)) {
            this.testFailureClassname = AssertionError.class.getName();
            this.testFailureMessage = this.testFailureMessage + System.lineSeparator() + failureCause.getTestFailureMessage();
            this.testFailureSummary = this.failureSummaryFrom(failureCause.getRootCause());
            this.setAnnotatedResult(TestResultComparison.overallResultFor(this.getAnnotatedResult(), failureCause.getAnnotatedResult()));
        }
    }

    private boolean isMoreSevereThanPreviousErrors(TestFailureCause failureCause) {
        TestResult latestFailure = new FailureAnalysis().resultFor(this.getTestFailureCause().exceptionClass());
        return latestFailure.isMoreSevereThan(this.getResult());
    }

    public com.google.common.base.Optional<TestStep> testStepWithDescription(String expectedDescription) {
        for (TestStep step : Lists.reverse(this.getFlattenedTestSteps())) {
            if (!step.getDescription().equalsIgnoreCase(expectedDescription)) continue;
            return com.google.common.base.Optional.of((Object)step);
        }
        return com.google.common.base.Optional.absent();
    }

    private boolean noStepHasFailedSoFar() {
        return this.testFailureCause == null;
    }

    public FailureCause getTestFailureCause() {
        return this.testFailureCause;
    }

    public FailureCause getNestedTestFailureCause() {
        return this.getFlattenedTestSteps().stream().filter(step -> step.getException() != null).map(TestStep::getException).findFirst().orElse(this.getTestFailureCause());
    }

    public Optional<TestStep> firstStepWithErrorMessage() {
        return this.getFlattenedTestSteps().stream().filter(step -> StringUtils.isNotBlank((CharSequence)step.getErrorMessage())).findFirst();
    }

    public Optional<String> testFailureMessage() {
        return Optional.ofNullable(this.testFailureMessage);
    }

    public String getErrorMessage() {
        if (this.firstStepWithErrorMessage().isPresent()) {
            return this.firstStepWithErrorMessage().get().getErrorMessage();
        }
        return this.testFailureMessage().orElse("");
    }

    public String getConciseErrorMessage() {
        if (this.firstStepWithErrorMessage().isPresent()) {
            return this.firstStepWithErrorMessage().get().getConciseErrorMessage();
        }
        return this.testFailureMessage().orElse("");
    }

    public void setTestFailureMessage(String testFailureMessage) {
        this.testFailureMessage = testFailureMessage;
    }

    public String getTestFailureMessage() {
        return this.testFailureMessage;
    }

    public String getTestFailureClassname() {
        return this.testFailureClassname;
    }

    public void setAnnotatedResult(TestResult annotatedResult) {
        if (this.annotatedResult != TestResult.PENDING) {
            this.annotatedResult = this.annotatedResult == null ? annotatedResult : TestResultComparison.overallResultFor(this.annotatedResult, annotatedResult);
        }
    }

    public void setResult(TestResult annotatedResult) {
        this.annotatedResult = annotatedResult;
    }

    public TestOutcome withResult(TestResult annotatedResult) {
        this.setResult(annotatedResult);
        return this;
    }

    public TestResult getAnnotatedResult() {
        return this.annotatedResult;
    }

    public List<String> getAdditionalVersions() {
        return this.additionalVersions;
    }

    public List<String> getAdditionalIssues() {
        return this.additionalIssues;
    }

    private List<String> issues() {
        if (!this.thereAre(this.coreIssues)) {
            this.coreIssues = this.removeDuplicates(this.readIssues());
        }
        return this.coreIssues;
    }

    public List<String> getIssues() {
        ArrayList<String> allIssues = new ArrayList<String>(this.issues());
        if (this.thereAre(this.additionalIssues)) {
            allIssues.addAll(this.additionalIssues);
        }
        return ImmutableList.copyOf(allIssues);
    }

    private List<String> versions() {
        if (!this.thereAre(this.coreVersions)) {
            this.coreVersions = this.removeDuplicates(this.readVersions());
        }
        return this.coreVersions;
    }

    private List<String> readVersions() {
        return TestOutcomeAnnotationReader.readVersionsIn(this);
    }

    public List<String> getVersions() {
        ArrayList<String> allVersions = new ArrayList<String>(this.versions());
        if (this.thereAre(this.additionalVersions)) {
            allVersions.addAll(this.additionalVersions);
        }
        this.addVersionsDefinedInTagsTo(allVersions);
        return ImmutableList.copyOf(allVersions);
    }

    private void addVersionsDefinedInTagsTo(List<String> allVersions) {
        for (TestTag tag : this.getTags()) {
            if (!tag.getType().equalsIgnoreCase("version") || allVersions.contains(tag.getName())) continue;
            allVersions.add(tag.getName());
        }
    }

    public Class<?> getTestCase() {
        if (this.testCase == null) {
            this.testCase = this.findTestCaseFromName(this.testCaseName);
        }
        return this.testCase;
    }

    private Class<?> findTestCaseFromName(String testCaseName) {
        try {
            return testCaseName != null ? Class.forName(testCaseName) : null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public String getTestCaseName() {
        return this.testCaseName;
    }

    private boolean thereAre(Collection<String> anyIssues) {
        return anyIssues != null && !anyIssues.isEmpty();
    }

    public TestOutcome addVersion(String version) {
        if (!this.getVersions().contains(version)) {
            this.additionalVersions.add(version);
        }
        return this;
    }

    public TestOutcome addVersions(List<String> versions) {
        for (String version : versions) {
            this.addVersion(version);
        }
        return this;
    }

    public TestOutcome forProject(String project) {
        this.project = project;
        return this;
    }

    public String getProject() {
        return this.project;
    }

    public TestOutcome inTestRunTimestamped(ZonedDateTime testRunTimestamp) {
        this.setTestRunTimestamp(testRunTimestamp);
        return this;
    }

    public void setTestRunTimestamp(ZonedDateTime testRunTimestamp) {
        this.testRunTimestamp = testRunTimestamp;
    }

    public void addIssues(List<String> issues) {
        this.additionalIssues.addAll(issues);
    }

    private List<String> readIssues() {
        return TestOutcomeAnnotationReader.readIssuesIn(this);
    }

    public String getFormattedIssues() {
        HashSet issues = Sets.newHashSet(this.getIssues());
        if (!issues.isEmpty()) {
            List orderedIssues = issues.stream().sorted().collect(Collectors.toList());
            String formattedIssues = orderedIssues.stream().collect(Collectors.joining(", "));
            return "(" + this.getFormatter().addLinks(formattedIssues) + ")";
        }
        return "";
    }

    public void isRelatedToIssue(String issue) {
        if (!this.issues().contains(issue)) {
            this.issues().add(issue);
        }
    }

    public void addFailingExternalStep(Throwable testFailureCause) {
        this.addFailingStepAsSibling(this.testSteps, testFailureCause);
    }

    public void addFailingStepAsSibling(List<TestStep> testStepList, Throwable testFailureCause) {
        if (testStepList.isEmpty()) {
            this.addStep(this.failingStep(testFailureCause));
        } else {
            TestStep lastStep = this.lastStepIn(testStepList);
            if (lastStep.hasChildren()) {
                this.addFailingStepAsSibling(lastStep.children(), testFailureCause);
            } else {
                testStepList.add(this.failingStep(testFailureCause));
            }
        }
    }

    private TestStep failingStep(Throwable testFailureCause) {
        TestStep failingStep = new TestStep("Failure");
        failingStep.failedWith(testFailureCause);
        return failingStep;
    }

    public void lastStepFailedWith(StepFailure failure) {
        this.lastStepFailedWith(failure.getException());
    }

    public void lastStepFailedWith(Throwable testFailureCause) {
        this.determineTestFailureCause(testFailureCause);
        TestStep lastTestStep = this.testSteps.get(this.testSteps.size() - 1);
        lastTestStep.failedWith(new StepFailureException(testFailureCause.getMessage(), testFailureCause));
    }

    public Set<TestTag> getTags() {
        if (this.tags == null) {
            this.tags = this.getTagsUsingTagProviders(this.getTagProviderService().getTagProviders(this.getTestSource()));
        }
        return this.tags;
    }

    public void addUserStoryFeatureTo(Set<TestTag> augmentedTags) {
        if (this.userStory != null && this.userStory.getFeature() != null) {
            augmentedTags.add(TestTag.withName(this.userStory.getFeature().getName()).andType("feature"));
        }
    }

    private Set<TestTag> getTagsUsingTagProviders(List<TagProvider> tagProviders) {
        Set<Object> tags = Sets.newHashSet();
        for (TagProvider tagProvider : tagProviders) {
            try {
                tags.addAll(tagProvider.getTagsFor(this));
            }
            catch (Throwable theTagProviderFailedButThereIsntMuchWeCanDoAboutIt) {
                LOGGER.error("Tag provider " + tagProvider + " failure", theTagProviderFailedButThereIsntMuchWeCanDoAboutIt);
            }
        }
        tags = this.removeRedundantTagsFrom((Set<TestTag>)tags);
        return ImmutableSet.copyOf((Collection)tags);
    }

    private Set<TestTag> removeRedundantTagsFrom(Set<TestTag> tags) {
        HashSet optimizedTags = Sets.newHashSet();
        for (TestTag tag : tags) {
            if (this.aMoreSpecificTagExistsThan(tag).in(tags)) continue;
            optimizedTags.add(tag);
        }
        return optimizedTags;
    }

    private SpecificTagFinder aMoreSpecificTagExistsThan(TestTag tag) {
        return new SpecificTagFinder(tag);
    }

    public void setTags(Set<TestTag> tags) {
        this.tags = Sets.newHashSet(tags);
    }

    public void addTags(List<TestTag> tags) {
        HashSet updatedTags = Sets.newHashSet(this.getTags());
        updatedTags.addAll(tags);
        this.tags = ImmutableSet.copyOf((Collection)updatedTags);
    }

    public void addTag(TestTag tag) {
        HashSet updatedTags = Sets.newHashSet(this.getTags());
        updatedTags.add(tag);
        this.tags = ImmutableSet.copyOf((Collection)updatedTags);
    }

    public List<String> getIssueKeys() {
        return this.getIssues().stream().map(issue -> IssueKeyFormat.forEnvironment(this.environmentVariables).andKey((String)issue)).collect(Collectors.toList());
    }

    public String getQualifiedMethodName() {
        if (this.qualifier != null && this.qualifier.isPresent()) {
            String qualifierWithoutSpaces = ((String)this.qualifier.get()).replaceAll(" ", "_");
            return this.getName() + "_" + qualifierWithoutSpaces;
        }
        return this.getName();
    }

    public String getQualifiedId() {
        return Joiner.on((String)"_").skipNulls().join((Object)this.getId(), (Object)this.getQualifierText(), new Object[]{this.context});
    }

    private String getQualifierText() {
        if (this.qualifier != null && this.qualifier.isPresent()) {
            return ((String)this.qualifier.get()).replaceAll(" ", "_");
        }
        return null;
    }

    public String getContext() {
        if (this.context == null) {
            this.context = this.contextFrom(this.environmentVariables);
        }
        return this.context;
    }

    public String getCompleteName() {
        if (StringUtils.isNotEmpty((CharSequence)this.getStoryTitle())) {
            return this.getStoryTitle() + ":" + this.getName();
        }
        return this.getTestCase() + ":" + this.getName();
    }

    public void useExamplesFrom(DataTable table) {
        this.dataTable = table;
    }

    public void addNewExamplesFrom(DataTable table) {
        List<DataTableRow> updatedRows = table.getRows();
        if (table.getSize() > this.dataTable.getSize()) {
            for (int rowNumber = this.dataTable.getSize(); rowNumber < updatedRows.size(); ++rowNumber) {
                this.dataTable.appendRow(updatedRows.get(rowNumber));
            }
        }
    }

    public void moveToNextRow() {
        if (this.dataTable != null && !this.dataTable.atLastRow()) {
            this.dataTable.nextRow();
        }
    }

    public void updateCurrentRowResult(TestResult result) {
        this.dataTable.currentRow().hasResult(result);
    }

    public boolean dataIsPredefined() {
        return this.dataTable.hasPredefinedRows();
    }

    public void addRow(Map<String, ?> data) {
        this.dataTable.addRow(data);
    }

    public void addRow(DataTableRow dataTableRow) {
        this.dataTable.addRow(dataTableRow);
    }

    public int getTestCount() {
        return this.isDataDriven() ? this.getDataTable().getSize() : 1;
    }

    public int getImplementedTestCount() {
        return this.getStepCount() > 0 ? this.getTestCount() : 0;
    }

    public int countResults(TestResult expectedResult) {
        return this.countResults(expectedResult, TestType.ANY);
    }

    public int countResults(TestResult expectedResult, TestType expectedType) {
        if (this.annotatedResult != null && !this.annotatedResult.executedResultsCount()) {
            return this.annotatedResultCount(expectedResult, expectedType);
        }
        if (this.isDataDriven()) {
            return this.countDataRowsWithResult(expectedResult, expectedType);
        }
        return this.getResult() == expectedResult && this.typeCompatibleWith(expectedType) ? 1 : 0;
    }

    private int annotatedResultCount(TestResult expectedResult, TestType expectedType) {
        if (this.annotatedResult == expectedResult && this.typeCompatibleWith(expectedType)) {
            return this.isDataDriven() ? this.dataTable.getSize() : 1;
        }
        return 0;
    }

    public boolean typeCompatibleWith(TestType testType) {
        switch (testType) {
            case MANUAL: {
                return this.isManual();
            }
            case AUTOMATED: {
                return !this.isManual();
            }
        }
        return true;
    }

    private int countDataRowsWithResult(TestResult expectedResult, TestType expectedType) {
        int matchingRowCount = 0;
        if (this.typeCompatibleWith(expectedType)) {
            for (DataTableRow row : this.getDataTable().getRows()) {
                matchingRowCount += row.getResult() == expectedResult ? 1 : 0;
            }
        }
        return matchingRowCount;
    }

    public int countNestedStepsWithResult(TestResult expectedResult, TestType testType) {
        if (this.isDataDriven()) {
            return this.countDataRowStepsWithResult(expectedResult, testType);
        }
        return this.getResult() == expectedResult && this.typeCompatibleWith(testType) ? this.getNestedStepCount() : 0;
    }

    private int countDataRowStepsWithResult(TestResult expectedResult, TestType testType) {
        int rowsWithResult = this.countDataRowsWithResult(expectedResult, testType);
        int totalRows = this.getDataTable().getSize();
        int totalSteps = this.getNestedStepCount();
        return totalSteps * rowsWithResult / totalRows;
    }

    public com.google.common.base.Optional<String> getTagValue(String tagType) {
        if (tagType.equalsIgnoreCase(ISSUES) && !this.getIssueKeys().isEmpty()) {
            return com.google.common.base.Optional.of((Object)Joiner.on((String)",").join(this.getIssueKeys()));
        }
        for (TestTag tag : this.getTags()) {
            if (!tag.getType().equalsIgnoreCase(tagType)) continue;
            return com.google.common.base.Optional.of((Object)tag.getName());
        }
        return com.google.common.base.Optional.absent();
    }

    public boolean hasIssue(String issue) {
        return this.getIssues().contains(issue);
    }

    public boolean hasTag(TestTag tag) {
        return this.getTags().contains(tag);
    }

    public boolean hasAMoreGeneralFormOfTag(TestTag specificTag) {
        for (TestTag tag : this.getTags()) {
            if (!specificTag.isAsOrMoreSpecificThan(tag)) continue;
            return true;
        }
        return false;
    }

    public void setStartTime(ZonedDateTime startTime) {
        this.startTime = startTime;
    }

    @Deprecated
    public void setStartTime(DateTime startTime) {
        ZonedDateTime time;
        this.startTime = time = ZonedDateTime.of(startTime.year().get(), startTime.monthOfYear().get(), startTime.dayOfMonth().get(), startTime.hourOfDay().get(), startTime.minuteOfHour().get(), startTime.secondOfMinute().get(), startTime.millisOfSecond().get() * 1000, ZoneId.systemDefault());
    }

    public void clearStartTime() {
        this.startTime = null;
    }

    public boolean isManual() {
        return this.manual;
    }

    public Set<? extends Flag> getFlags() {
        if (this.flags == null) {
            this.flags = this.flagProvider.getFlagsFor(this);
            this.addFlagTagsFor(this.flags);
        }
        return this.flags;
    }

    private void addFlagTagsFor(Set<? extends Flag> flags) {
        for (Flag flag : flags) {
            this.addTag(TestTag.withName(flag.getMessage()).andType("flag"));
        }
    }

    public boolean isStartTimeNotDefined() {
        return this.startTime == null;
    }

    private SystemClock getSystemClock() {
        return (SystemClock)Injectors.getInjector().getInstance(SystemClock.class);
    }

    private ZonedDateTime now() {
        return this.getSystemClock().getCurrentTime();
    }

    public OptionalElements has() {
        return new OptionalElements(this);
    }

    public Integer getStepCount() {
        return this.testSteps.size();
    }

    public Integer getRunningStepCount() {
        return this.runningStepCountOf(this.testSteps);
    }

    private Integer runningStepCountOf(List<TestStep> steps) {
        if (this.tailOf(steps).isPresent() && ((TestStep)this.tailOf(steps).get()).hasChildren()) {
            return this.runningStepCountOf(((TestStep)this.tailOf(steps).get()).getChildren());
        }
        return steps.size();
    }

    private com.google.common.base.Optional<TestStep> tailOf(List<TestStep> testSteps) {
        return testSteps.isEmpty() ? com.google.common.base.Optional.absent() : com.google.common.base.Optional.of((Object)testSteps.get(testSteps.size() - 1));
    }

    public Integer getNestedStepCount() {
        return this.getFlattenedTestSteps().size();
    }

    public Long getSuccessCount() {
        return this.count(TestStep.SUCCESSFUL_TESTSTEPS).in(this.getLeafTestSteps());
    }

    public Long getFailureCount() {
        return this.count(TestStep.FAILING_TESTSTEPS).in(this.getLeafTestSteps());
    }

    public Long getErrorCount() {
        return this.count(TestStep.ERROR_TESTSTEPS).in(this.getLeafTestSteps());
    }

    public Long getCompromisedCount() {
        return this.count(TestStep.COMPROMISED_TESTSTEPS).in(this.getLeafTestSteps());
    }

    public Long getIgnoredCount() {
        return this.count(TestStep.IGNORED_TESTSTEPS).in(this.getLeafTestSteps());
    }

    public Long getSkippedOrIgnoredCount() {
        return this.getIgnoredCount() + this.getSkippedCount();
    }

    public Long getSkippedCount() {
        return this.count(TestStep.SKIPPED_TESTSTEPS).in(this.getLeafTestSteps());
    }

    public Long getPendingCount() {
        return this.getLeafTestSteps().stream().filter(TestStep::isPending).count();
    }

    public Boolean isSuccess() {
        return this.getResult() == TestResult.SUCCESS;
    }

    public Boolean isFailure() {
        return this.getResult() == TestResult.FAILURE;
    }

    public Boolean isCompromised() {
        return this.getResult() == TestResult.COMPROMISED;
    }

    public Boolean isError() {
        return this.getResult() == TestResult.ERROR;
    }

    public Boolean isPending() {
        return this.getResult() == TestResult.PENDING;
    }

    public Boolean isSkipped() {
        return this.getResult() == TestResult.SKIPPED || this.getResult() == TestResult.IGNORED;
    }

    public Story getUserStory() {
        return this.userStory;
    }

    public void recordDuration() {
        this.setDuration(ChronoUnit.MILLIS.between(this.startTime, ZonedDateTime.now()));
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public Long getDuration() {
        if (this.duration > 0L) {
            return this.duration;
        }
        return this.testSteps.stream().mapToLong(TestStep::getDuration).sum();
    }

    public double getDurationInSeconds() {
        return TestDuration.of(this.getDuration()).inSeconds();
    }

    public String getVideoLink() {
        return this.linkGenerator.linkFor(this);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    private StepCountBuilder count(Predicate<TestStep> filter) {
        return new StepCountBuilder(filter);
    }

    public Integer countTestSteps() {
        return this.countLeafStepsIn(this.testSteps);
    }

    private Integer countLeafStepsIn(List<TestStep> testSteps) {
        int leafCount = 0;
        for (TestStep step : testSteps) {
            if (step.isAGroup()) {
                leafCount += this.countLeafStepsIn(step.getChildren()).intValue();
                continue;
            }
            ++leafCount;
        }
        return leafCount;
    }

    StepFilter successfulSteps() {
        return new StepFilter(){

            @Override
            boolean apply(TestStep step) {
                return step.isSuccessful();
            }
        };
    }

    StepFilter failingSteps() {
        return new StepFilter(){

            @Override
            boolean apply(TestStep step) {
                return step.isFailure();
            }
        };
    }

    StepFilter errorSteps() {
        return new StepFilter(){

            @Override
            boolean apply(TestStep step) {
                return step.isError();
            }
        };
    }

    StepFilter compromisedSteps() {
        return new StepFilter(){

            @Override
            boolean apply(TestStep step) {
                return step.isCompromised();
            }
        };
    }

    StepFilter ignoredSteps() {
        return new StepFilter(){

            @Override
            boolean apply(TestStep step) {
                return step.isIgnored();
            }
        };
    }

    StepFilter skippedSteps() {
        return new StepFilter(){

            @Override
            boolean apply(TestStep step) {
                return step.isSkipped();
            }
        };
    }

    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public String getStartedAt() {
        return ((ZonedDateTime)com.google.common.base.Optional.fromNullable((Object)this.startTime).or((Object)this.now())).format(DateTimeFormatter.ofPattern("HH:mm:ss"));
    }

    public String getTimestamp() {
        return ((ZonedDateTime)com.google.common.base.Optional.fromNullable((Object)this.startTime).or((Object)this.now())).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public boolean isDataDriven() {
        return this.dataTable != null;
    }

    private List<TestStep> getStepChildren() {
        List<TestStep> firstLevel = this.firstNonPreconditionStepChildren();
        if (firstLevel.size() > 0 && firstLevel.get(0).getDescription().matches("^\\[\\d+\\]\\s\\{.+")) {
            firstLevel = firstLevel.get(0).getChildren();
        }
        return firstLevel;
    }

    public List<String> getExampleFields() {
        return this.isDataDriven() ? this.getDataTable().getHeaders() : NO_HEADERS;
    }

    private List<TestStep> firstNonPreconditionStepChildren() {
        for (TestStep step : this.getTestSteps()) {
            if (step.isAPrecondition() || !step.hasChildren()) continue;
            return step.getChildren();
        }
        return new ArrayList<TestStep>();
    }

    public String getDataDrivenSampleScenario() {
        if (!this.isDataDriven() || this.getTestSteps().isEmpty() || !this.atLeastOneStepHasChildren()) {
            return "";
        }
        if (this.dataTable.scenarioOutline().isPresent()) {
            return this.dataTable.scenarioOutline().get();
        }
        StringBuilder sampleScenario = new StringBuilder();
        for (TestStep step : this.getStepChildren()) {
            sampleScenario.append(this.withPlaceholderSubstitutes(step.getDescription())).append("\n");
        }
        return sampleScenario.length() > 1 ? sampleScenario.substring(0, sampleScenario.length() - 1) : "";
    }

    private String withPlaceholderSubstitutes(String stepName) {
        if (this.dataTable == null || this.dataTable.getRows().isEmpty()) {
            return stepName;
        }
        return this.dataTable.restoreVariablesIn(stepName);
    }

    private boolean atLeastOneStepHasChildren() {
        return this.getTestSteps().stream().anyMatch(TestStep::hasChildren);
    }

    public DataTable getDataTable() {
        return this.dataTable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestOutcome that = (TestOutcome)o;
        if (this.manual != that.manual) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.qualifier != null ? !this.qualifier.equals(that.qualifier) : that.qualifier != null) {
            return false;
        }
        if (this.testCaseName != null ? !this.testCaseName.equals(that.testCaseName) : that.testCaseName != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        return !(this.userStory != null ? !this.userStory.equals(that.userStory) : that.userStory != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.testCase != null ? this.testCase.hashCode() : 0);
        result = 31 * result + (this.userStory != null ? this.userStory.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.qualifier != null ? this.qualifier.hashCode() : 0);
        result = 31 * result + (this.manual ? 1 : 0);
        return result;
    }

    public com.google.common.base.Optional<TestTag> getFeatureTag() {
        if (!this.featureTag.isPresent()) {
            this.featureTag = FeatureTagAsDefined.in(this.userStory, this.getPath());
        }
        return this.featureTag;
    }

    private void removeSteps(List<TestStep> stepsToReplace) {
        ImmutableList currentTestSteps = ImmutableList.copyOf(this.testSteps);
        for (TestStep testStep : currentTestSteps) {
            if (!stepsToReplace.contains(testStep)) continue;
            this.testSteps.remove(testStep);
        }
    }

    public FailureDetails getFailureDetails() {
        return new FailureDetails(this);
    }

    public String getTestSource() {
        return this.testSource;
    }

    public void setTestSource(String testSource) {
        this.testSource = testSource;
    }

    public class StepReplacer {
        List<TestStep> stepsToReplace;

        public StepReplacer(List<TestStep> stepsToReplace) {
            this.stepsToReplace = stepsToReplace;
        }

        public void with(TestStep mergedStep) {
            TestOutcome.this.removeSteps(this.stepsToReplace);
            TestOutcome.this.addStep(mergedStep);
            TestOutcome.this.renumberTestSteps();
        }
    }

    private static class SpecificTagFinder {
        private final TestTag tag;

        public SpecificTagFinder(TestTag tag) {
            this.tag = tag;
        }

        public boolean in(Set<TestTag> tags) {
            for (TestTag otherTag : tags) {
                if (otherTag == this.tag || !otherTag.isAsOrMoreSpecificThan(this.tag)) continue;
                return true;
            }
            return false;
        }
    }

    private class StepResetBuilder {
        TestStep step;

        public StepResetBuilder(TestStep step) {
            this.step = step;
        }

        public void causedBy(Class<? extends Throwable> expected) {
            if (this.step.getException() != null && this.step.getException().getErrorType() != null && TheErrorType.causedBy(this.step.getException().getErrorType()).isAKindOf(expected)) {
                this.step.clearException();
                this.step.setResult(TestResult.SUCCESS);
            }
            for (TestStep childStep : this.step.getChildren()) {
                TestOutcome.this.resetFailingStepsIn(childStep).causedBy(expected);
            }
        }
    }

    abstract class StepFilter {
        StepFilter() {
        }

        abstract boolean apply(TestStep var1);
    }

    public static class StepCountBuilder {
        private final Predicate<TestStep> stepFilter;

        private StepCountBuilder(Predicate<TestStep> filter) {
            this.stepFilter = filter;
        }

        long in(List<TestStep> steps) {
            return steps.stream().filter(this.stepFilter).count();
        }
    }

    public static class OptionalElements {
        private final TestOutcome testOutcome;

        public OptionalElements(TestOutcome testOutcome) {
            this.testOutcome = testOutcome;
        }

        public boolean testRunTimestamp() {
            return this.testOutcome.testRunTimestamp != null;
        }
    }

    class StepMergeBuilder {
        private final TestStep previousStep;

        private StepMergeBuilder(TestStep step) {
            this.previousStep = step;
        }

        public TestStep into(TestStep nextStep) {
            TestStep mergedStep = nextStep.addChildStep(this.previousStep);
            if (nextStep.getResult() == TestResult.SKIPPED && TestOutcome.this.wasUnsuccessful(this.previousStep)) {
                nextStep.setResult(TestResult.UNDEFINED);
            }
            mergedStep.setResult(this.merge(nextStep.getResult()).with(this.previousStep.getResult()));
            return mergedStep;
        }

        private StepResultMergeStragegy merge(TestResult nextStepResult) {
            return MergeStepResultStrategy.whenNextStepResultIs(nextStepResult);
        }
    }

    private class GetLastStepBuilder {
        int maxCount;

        public GetLastStepBuilder(int maxCount) {
            this.maxCount = maxCount;
        }

        public List<TestStep> steps() {
            List testStepPartitions = Lists.partition((List)Lists.reverse(TestOutcome.this.getTestSteps()), (int)this.maxCount);
            return Lists.reverse((List)((List)testStepPartitions.get(0)));
        }
    }

    private static class TestOutcomeWithEnvironmentBuilder {
        private final EnvironmentVariables environmentVariables;

        public TestOutcomeWithEnvironmentBuilder(EnvironmentVariables environmentVariables) {
            this.environmentVariables = environmentVariables;
        }

        public Object forTest(String methodName, Class<?> testCase) {
            return new TestOutcome(methodName, testCase, this.environmentVariables);
        }

        public Object forTest(String methodName, Class<?> testCase, Story story) {
            return new TestOutcome(methodName, testCase, story, this.environmentVariables);
        }
    }
}

