/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model.failures;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import cucumber.api.PendingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.serenitybdd.core.PendingStepException;
import net.serenitybdd.core.exceptions.CausesAssertionFailure;
import net.serenitybdd.core.exceptions.CausesCompromisedTestFailure;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailureAnalysisConfiguration {
    private final EnvironmentVariables environmentVariables;
    private static final Logger LOGGER = LoggerFactory.getLogger(FailureAnalysisConfiguration.class);
    private final List<Class<?>> DEFAULT_FAILURE_TYPES = new ArrayList();
    private final List<Class<?>> DEFAULT_COMPROMISED_TYPES;
    private final List<Class<?>> DEFAULT_PENDING_TYPES;
    private final List<Class<?>> DEFAULT_ERROR_TYPES;

    public FailureAnalysisConfiguration(EnvironmentVariables environmentVariables) {
        this.DEFAULT_FAILURE_TYPES.addAll((Collection<Class<?>>)ImmutableList.of(AssertionError.class, CausesAssertionFailure.class));
        this.DEFAULT_COMPROMISED_TYPES = new ArrayList();
        this.DEFAULT_COMPROMISED_TYPES.addAll((Collection<Class<?>>)ImmutableList.of(CausesCompromisedTestFailure.class));
        this.DEFAULT_PENDING_TYPES = new ArrayList();
        this.DEFAULT_PENDING_TYPES.addAll((Collection<Class<?>>)ImmutableList.of(PendingStepException.class, PendingException.class));
        this.DEFAULT_ERROR_TYPES = new ArrayList();
        this.DEFAULT_ERROR_TYPES.addAll((Collection<Class<?>>)ImmutableList.of(Error.class));
        this.environmentVariables = environmentVariables;
    }

    public List<Class<?>> failureTypes() {
        ArrayList failureTypes = Lists.newArrayList(this.DEFAULT_FAILURE_TYPES);
        failureTypes.addAll(this.failureTypesDefinedIn(this.environmentVariables));
        failureTypes.removeAll(this.errorTypesDefinedIn(this.environmentVariables));
        failureTypes.removeAll(this.pendingTypesDefinedIn(this.environmentVariables));
        failureTypes.removeAll(this.compromisedTypesDefinedIn(this.environmentVariables));
        return failureTypes;
    }

    public List<Class<?>> compromisedTypes() {
        ArrayList compromisedTypes = Lists.newArrayList(this.DEFAULT_COMPROMISED_TYPES);
        compromisedTypes.addAll(this.compromisedTypesDefinedIn(this.environmentVariables));
        compromisedTypes.removeAll(this.errorTypesDefinedIn(this.environmentVariables));
        compromisedTypes.removeAll(this.pendingTypesDefinedIn(this.environmentVariables));
        compromisedTypes.removeAll(this.failureTypesDefinedIn(this.environmentVariables));
        return compromisedTypes;
    }

    public List<Class<?>> pendingTypes() {
        ArrayList pendingTypes = Lists.newArrayList(this.DEFAULT_PENDING_TYPES);
        pendingTypes.addAll(this.pendingTypesDefinedIn(this.environmentVariables));
        pendingTypes.removeAll(this.errorTypesDefinedIn(this.environmentVariables));
        pendingTypes.removeAll(this.compromisedTypesDefinedIn(this.environmentVariables));
        pendingTypes.removeAll(this.failureTypesDefinedIn(this.environmentVariables));
        return pendingTypes;
    }

    public List<Class<?>> errorTypes() {
        ArrayList errorTypes = Lists.newArrayList(this.DEFAULT_ERROR_TYPES);
        errorTypes.addAll(this.errorTypesDefinedIn(this.environmentVariables));
        errorTypes.removeAll(this.pendingTypesDefinedIn(this.environmentVariables));
        errorTypes.removeAll(this.compromisedTypesDefinedIn(this.environmentVariables));
        errorTypes.removeAll(this.failureTypesDefinedIn(this.environmentVariables));
        return errorTypes;
    }

    private List<Class<?>> errorTypesDefinedIn(EnvironmentVariables environmentVariables) {
        return this.typesDefinedIn(ThucydidesSystemProperty.SERENITY_ERROR_ON, environmentVariables);
    }

    private List<Class<?>> failureTypesDefinedIn(EnvironmentVariables environmentVariables) {
        return this.typesDefinedIn(ThucydidesSystemProperty.SERENITY_FAIL_ON, environmentVariables);
    }

    private List<Class<?>> pendingTypesDefinedIn(EnvironmentVariables environmentVariables) {
        return this.typesDefinedIn(ThucydidesSystemProperty.SERENITY_PENDING_ON, environmentVariables);
    }

    private List<Class<?>> compromisedTypesDefinedIn(EnvironmentVariables environmentVariables) {
        return this.typesDefinedIn(ThucydidesSystemProperty.SERENITY_COMPROMISED_ON, environmentVariables);
    }

    private List<Class<?>> typesDefinedIn(ThucydidesSystemProperty typeListProperty, EnvironmentVariables environmentVariables) {
        ArrayList definedTypes = new ArrayList();
        List classNames = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)typeListProperty.from(environmentVariables, ""));
        for (String className : classNames) {
            try {
                definedTypes.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("Could not find error class: " + className);
            }
        }
        return definedTypes;
    }
}

