/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class TagFilter {
    private final EnvironmentVariables environmentVariables;

    public TagFilter(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public List<String> filteredTagTypes(List<String> tagTypes) {
        List<String> excludedTags;
        List<Object> filteredTags = Lists.newArrayList(tagTypes);
        List<String> displayedTags = this.includedTagTypes();
        if (!displayedTags.isEmpty()) {
            filteredTags = this.onlyKeepAllowedTypes(filteredTags, displayedTags);
        }
        if (!(excludedTags = this.excludedTagTypes()).isEmpty()) {
            filteredTags = this.removeUnwantedTags(filteredTags, excludedTags);
        }
        return filteredTags;
    }

    public Set<TestTag> removeTagsOfType(Set<TestTag> tags, String ... redundantTagTypes) {
        HashSet filteredTags = Sets.newHashSet();
        ArrayList maskedTagTypes = Lists.newArrayList((Object[])redundantTagTypes);
        for (TestTag tag : tags) {
            if (maskedTagTypes.contains(tag.getType())) continue;
            filteredTags.add(tag);
        }
        return filteredTags;
    }

    public Set<TestTag> removeTagsWithName(Set<TestTag> tags, String name) {
        HashSet filteredTags = Sets.newHashSet();
        for (TestTag tag : tags) {
            if (tag.getShortName().equalsIgnoreCase(name)) continue;
            filteredTags.add(tag);
        }
        return filteredTags;
    }

    private List<String> onlyKeepAllowedTypes(List<String> tags, List<String> displayedTags) {
        ArrayList<String> allowedTags = new ArrayList<String>();
        for (String tag : tags) {
            if (!displayedTags.contains(tag.toLowerCase())) continue;
            allowedTags.add(tag);
        }
        return allowedTags;
    }

    private List<String> removeUnwantedTags(List<String> tags, List<String> unwantedTags) {
        for (String tag : unwantedTags) {
            if (tags.contains(tag.toLowerCase())) {
                tags.remove(tag.toLowerCase());
            }
            if (!tags.contains(tag.toUpperCase())) continue;
            tags.remove(tag.toUpperCase());
        }
        return tags;
    }

    private List<String> includedTagTypes() {
        return this.asLowercaseList(ThucydidesSystemProperty.DASHBOARD_TAG_LIST.from(this.environmentVariables));
    }

    private List<String> excludedTagTypes() {
        return this.asLowercaseList(ThucydidesSystemProperty.DASHBOARD_EXCLUDED_TAG_LIST.from(this.environmentVariables));
    }

    private List<String> asLowercaseList(String displayTags) {
        if (StringUtils.isNotEmpty((CharSequence)displayTags)) {
            return ImmutableList.copyOf((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)displayTags.toLowerCase()));
        }
        return new ArrayList<String>();
    }
}

