/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestType;
import net.thucydides.core.reports.TestOutcomeCounter;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.requirements.ExcludedUnrelatedRequirementTypes;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.reports.PercentageRequirementCounter;
import net.thucydides.core.requirements.reports.RequirementsPercentageFormatter;
import net.thucydides.core.requirements.reports.RequirementsProportionCounter;
import net.thucydides.core.requirements.reports.SubrequirementsCount;
import net.thucydides.core.util.EnvironmentVariables;

public class RequirementOutcome {
    private final Requirement requirement;
    private final TestOutcomes testOutcomes;
    private IssueTracking issueTracking;
    private final int requirementsWithoutTests;
    private final int estimatedUnimplementedTests;
    private final EnvironmentVariables environmentVariables;

    public RequirementOutcome(Requirement requirement, TestOutcomes testOutcomes, int requirementsWithoutTests, int estimatedUnimplementedTests, IssueTracking issueTracking) {
        this.requirement = requirement;
        this.testOutcomes = testOutcomes;
        this.requirementsWithoutTests = requirementsWithoutTests;
        this.estimatedUnimplementedTests = estimatedUnimplementedTests;
        this.issueTracking = issueTracking;
        this.environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
    }

    public RequirementOutcome(Requirement requirement, TestOutcomes testOutcomes, IssueTracking issueTracking) {
        this(requirement, testOutcomes, 0, 0, issueTracking);
    }

    public RequirementOutcome withTestOutcomes(TestOutcomes testOutcomes) {
        return new RequirementOutcome(this.requirement, testOutcomes, this.requirementsWithoutTests, this.estimatedUnimplementedTests, this.issueTracking);
    }

    public Requirement getRequirement() {
        return this.requirement;
    }

    public TestOutcomes getTestOutcomes() {
        return this.testOutcomes;
    }

    public boolean isComplete() {
        return !this.getTestOutcomes().getTests().isEmpty() && this.getTestOutcomes().getResult() == TestResult.SUCCESS && this.allChildRequirementsAreSuccessful();
    }

    public boolean isFailure() {
        return this.getTestOutcomes().getResult() == TestResult.FAILURE || this.anyChildRequirementsAreFailures();
    }

    public boolean isError() {
        return this.getTestOutcomes().getResult() == TestResult.ERROR || this.anyChildRequirementsAreErrors();
    }

    public boolean isCompromised() {
        return this.getTestOutcomes().getResult() == TestResult.COMPROMISED || this.anyChildRequirementsAreCompromised();
    }

    public boolean isPending() {
        return this.getTestOutcomes().getResult() == TestResult.PENDING || this.anyChildRequirementsArePending();
    }

    public boolean isIgnored() {
        return this.getTestOutcomes().getResult() == TestResult.IGNORED || this.anyChildRequirementsAreIgnored();
    }

    public int getFlattenedRequirementCount() {
        return this.getFlattenedRequirements().size();
    }

    public List<Requirement> getFlattenedRequirements() {
        ArrayList flattenedRequirements = Lists.newArrayList((Object[])new Requirement[]{this.requirement});
        flattenedRequirements.addAll(this.requirement.getNestedChildren());
        return ImmutableList.copyOf((Collection)flattenedRequirements);
    }

    public List<Requirement> getFlattenedRequirements(Requirement ... excludingRequirement) {
        ArrayList flattenedRequirements = Lists.newArrayList((Object[])new Requirement[]{this.requirement});
        flattenedRequirements.addAll(this.requirement.getNestedChildren());
        flattenedRequirements.removeAll(Lists.newArrayList((Object[])excludingRequirement));
        return ImmutableList.copyOf((Collection)flattenedRequirements);
    }

    public int getRequirementsWithoutTestsCount() {
        return this.requirementsWithoutTests;
    }

    private boolean allChildRequirementsAreSuccessful() {
        if (this.requirement.hasChildren()) {
            return this.allChildRequirementsAreSuccessfulFor(this.requirement.getChildren());
        }
        return true;
    }

    private boolean anyChildRequirementsAreFailures() {
        return this.anyChildRequirementsAreFailuresFor(this.requirement.getChildren());
    }

    private boolean anyChildRequirementsAreErrors() {
        return this.anyChildRequirementsAreErrorsFor(this.requirement.getChildren());
    }

    private boolean anyChildRequirementsAreCompromised() {
        return this.anyChildRequirementsAreCompromisedFor(this.requirement.getChildren());
    }

    private boolean anyChildRequirementsArePending() {
        return this.anyChildRequirementsArePendingFor(this.requirement.getChildren());
    }

    private boolean anyChildRequirementsAreIgnored() {
        return this.anyChildRequirementsAreIgnoredFor(this.requirement.getChildren());
    }

    private boolean allChildRequirementsAreSuccessfulFor(List<Requirement> requirements) {
        for (Requirement childRequirement : requirements) {
            RequirementOutcome childOutcomes = new RequirementOutcome(childRequirement, this.testOutcomes.forRequirement(this.requirement), this.issueTracking);
            if (!childOutcomes.isComplete()) {
                return false;
            }
            if (this.allChildRequirementsAreSuccessfulFor(childRequirement.getChildren())) continue;
            return false;
        }
        return true;
    }

    private boolean anyChildRequirementsAreErrorsFor(List<Requirement> requirements) {
        for (Requirement childRequirement : requirements) {
            RequirementOutcome childOutcomes = new RequirementOutcome(childRequirement, this.testOutcomes.forRequirement(this.requirement), this.issueTracking);
            if (childOutcomes.isError()) {
                return true;
            }
            if (!this.anyChildRequirementsAreErrorsFor(childRequirement.getChildren())) continue;
            return true;
        }
        return false;
    }

    private boolean anyChildRequirementsAreFailuresFor(List<Requirement> requirements) {
        for (Requirement childRequirement : requirements) {
            RequirementOutcome childOutcomes = new RequirementOutcome(childRequirement, this.testOutcomes.forRequirement(this.requirement), this.issueTracking);
            if (childOutcomes.isFailure()) {
                return true;
            }
            if (!this.anyChildRequirementsAreFailuresFor(childRequirement.getChildren())) continue;
            return true;
        }
        return false;
    }

    private boolean anyChildRequirementsAreCompromisedFor(List<Requirement> requirements) {
        for (Requirement childRequirement : requirements) {
            RequirementOutcome childOutcomes = new RequirementOutcome(childRequirement, this.testOutcomes.forRequirement(this.requirement), this.issueTracking);
            if (childOutcomes.isCompromised()) {
                return true;
            }
            if (!this.anyChildRequirementsAreErrorsFor(childRequirement.getChildren())) continue;
            return true;
        }
        return false;
    }

    private boolean anyChildRequirementsArePendingFor(List<Requirement> requirements) {
        for (Requirement childRequirement : requirements) {
            RequirementOutcome childOutcomes = new RequirementOutcome(childRequirement, this.testOutcomes.forRequirement(this.requirement), this.issueTracking);
            if (childOutcomes.isPending()) {
                return true;
            }
            if (!this.anyChildRequirementsArePendingFor(childRequirement.getChildren())) continue;
            return true;
        }
        return false;
    }

    private boolean anyChildRequirementsAreIgnoredFor(List<Requirement> requirements) {
        for (Requirement childRequirement : requirements) {
            RequirementOutcome childOutcomes = new RequirementOutcome(childRequirement, this.testOutcomes.forRequirement(this.requirement), this.issueTracking);
            if (childOutcomes.isIgnored()) {
                return true;
            }
            if (!this.anyChildRequirementsAreIgnoredFor(childRequirement.getChildren())) continue;
            return true;
        }
        return false;
    }

    public String getCardNumberWithLinks() {
        if (this.requirement.getCardNumber() != null) {
            return this.getFormatter().addLinks(this.requirement.getCardNumber());
        }
        return "";
    }

    private Formatter getFormatter() {
        return new Formatter(this.issueTracking);
    }

    public String toString() {
        return "RequirementOutcome{requirement=" + this.requirement + ", testOutcomes=" + this.testOutcomes + '}';
    }

    public int getTestCount() {
        return this.testOutcomes.getTotal();
    }

    public TestOutcomes getTests() {
        return this.testOutcomes;
    }

    public int getEstimatedUnimplementedTests() {
        return this.estimatedUnimplementedTests;
    }

    private int totalEstimatedAndImplementedTests() {
        int totalImplementedTests = this.testOutcomes.getTotal();
        return totalImplementedTests + this.estimatedUnimplementedTests;
    }

    public RequirementsPercentageFormatter getFormattedPercentage() {
        return this.getFormattedPercentage(TestType.ANY);
    }

    public RequirementsPercentageFormatter getFormattedPercentage(String testType) {
        return new RequirementsPercentageFormatter(this.percentage(testType));
    }

    public RequirementsPercentageFormatter getFormattedPercentage(TestType testType) {
        return new RequirementsPercentageFormatter(this.percentage(testType));
    }

    public boolean testsRequirement(Requirement requirement) {
        return requirement.equals(this.getRequirement()) || this.testOutcomes.containsTag(requirement.asTag());
    }

    public RequirementsProportionCounter getPercent() {
        return this.percentage(TestType.ANY);
    }

    public PercentageRequirementCounter getPercentRequirements() {
        return new PercentageRequirementCounter(this.requirement, this.testOutcomes);
    }

    public SubrequirementsCount getSubrequirements() {
        return new SubrequirementsCount(this.requirement, this.testOutcomes);
    }

    public RequirementsProportionCounter percentage(String testType) {
        return this.percentage(TestType.valueOf(testType.toUpperCase()));
    }

    public RequirementsProportionCounter percentage(TestType testType) {
        return new RequirementsProportionCounter(testType, this.testOutcomes, this.totalEstimatedAndImplementedTests());
    }

    public OutcomeCounter getTotal() {
        return new OutcomeCounter(TestType.ANY);
    }

    public OutcomeCounter count(TestType testType) {
        return new OutcomeCounter(testType);
    }

    public OutcomeCounter count(String testType) {
        return new OutcomeCounter(TestType.valueOf(testType.toUpperCase()));
    }

    public Set<String> getReleaseVersions() {
        HashSet releaseVersions = Sets.newHashSet();
        for (TestOutcome testOutcome : this.getTestOutcomes().getOutcomes()) {
            releaseVersions.addAll(testOutcome.getVersions());
        }
        return ImmutableSet.copyOf((Collection)releaseVersions);
    }

    public RequirementOutcome withoutUnrelatedRequirements() {
        if (!this.shouldPrune(this)) {
            return this;
        }
        ArrayList<Requirement> childRequirementsWithTests = new ArrayList<Requirement>();
        for (Requirement childRequirement : this.getRequirement().getChildren()) {
            if (!this.isTested(childRequirement)) continue;
            childRequirementsWithTests.add(childRequirement);
        }
        Requirement prunedRequirement = this.getRequirement().withChildren(childRequirementsWithTests);
        return new RequirementOutcome(prunedRequirement, this.testOutcomes, this.requirementsWithoutTests, this.estimatedUnimplementedTests, this.issueTracking);
    }

    public boolean shouldPrune(RequirementOutcome requirementOutcome) {
        return ExcludedUnrelatedRequirementTypes.definedIn(this.environmentVariables).excludeUntestedChildrenOfRequirementOfType(requirementOutcome.getRequirement().getType());
    }

    private boolean isTested(Requirement childRequirement) {
        return !this.testOutcomes.forRequirement(childRequirement).getOutcomes().isEmpty();
    }

    public class OutcomeCounter
    extends TestOutcomeCounter {
        public OutcomeCounter(TestType testType) {
            super(testType);
        }

        public int withResult(String expectedResult) {
            return this.withResult(TestResult.valueOf(expectedResult.toUpperCase()));
        }

        public int withResult(TestResult expectedResult) {
            return RequirementOutcome.this.testOutcomes.getOutcomes().stream().mapToInt(outcome -> outcome.countResults(expectedResult, this.testType)).sum();
        }

        public int withIndeterminateResult() {
            return RequirementOutcome.this.testOutcomes.getTotal() - this.withResult(TestResult.SUCCESS) - this.withResult(TestResult.FAILURE) - this.withResult(TestResult.ERROR);
        }

        public int withFailureOrError() {
            return this.withResult(TestResult.FAILURE) + this.withResult(TestResult.ERROR) + this.withResult(TestResult.COMPROMISED);
        }

        public int withAnyResult() {
            return RequirementOutcome.this.testOutcomes.getTotal();
        }
    }
}

