/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.capabilities;

import java.util.Optional;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.capabilities.AddCustomCapabilities;
import net.thucydides.core.webdriver.capabilities.RemoteDriverCapabilities;
import net.thucydides.core.webdriver.capabilities.RemoteTestName;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;

public class BrowserStackRemoteDriverCapabilities
implements RemoteDriverCapabilities {
    private final EnvironmentVariables environmentVariables;

    public BrowserStackRemoteDriverCapabilities(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public String getUrl() {
        return ThucydidesSystemProperty.BROWSERSTACK_URL.from(this.environmentVariables);
    }

    @Override
    public DesiredCapabilities getCapabilities(DesiredCapabilities capabilities) {
        this.configureBrowserStackCapabilities(capabilities);
        return capabilities;
    }

    private void configureBrowserStackCapabilities(DesiredCapabilities capabilities) {
        Optional<String> guessedTestName = RemoteTestName.fromCurrentTest();
        guessedTestName.ifPresent(name -> capabilities.setCapability("name", name));
        AddCustomCapabilities.startingWith("browserstack.").from(this.environmentVariables).withAndWithoutPrefixes().to(capabilities);
        String remotePlatform = this.environmentVariables.getProperty("remote.platform");
        if (StringUtils.isNotEmpty((CharSequence)remotePlatform)) {
            capabilities.setPlatform(Platform.valueOf((String)remotePlatform));
        }
    }
}

