/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.firefox;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.openqa.selenium.firefox.FirefoxProfile;

public class FirefoxProfileEnhancer {
    private static final String FIREFOX_NETWORK_PROXY_TYPE = "network.proxy.type";
    private static final String FIREFOX_NETWORK_PROXY_HTTP = "network.proxy.http";
    private static final String FIREFOX_NETWORK_PROXY_HTTP_PORT = "network.proxy.http_port";
    private final EnvironmentVariables environmentVariables;

    public FirefoxProfileEnhancer(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public void configureJavaSupport(FirefoxProfile profile) {
        boolean enableJava = this.environmentVariables.getPropertyAsBoolean(ThucydidesSystemProperty.SECURITY_ENABLE_JAVA, false);
        profile.setPreference("security.enable_java", enableJava);
    }

    public void allowWindowResizeFor(FirefoxProfile profile) {
        profile.setPreference("dom.disable_window_move_resize", false);
    }

    public void activateProxy(FirefoxProfile profile, String proxyUrl, String proxyPort) {
        profile.setPreference(FIREFOX_NETWORK_PROXY_HTTP, proxyUrl);
        profile.setPreference(FIREFOX_NETWORK_PROXY_HTTP_PORT, NumberUtils.toInt((String)proxyPort));
        profile.setPreference(FIREFOX_NETWORK_PROXY_TYPE, 1);
    }

    public void addPreferences(FirefoxProfile profile) {
        String preferences = this.environmentVariables.getProperty(ThucydidesSystemProperty.FIREFOX_PREFERENCES);
        List<PreferenceValue> preferenceValues = this.getPreferenceValuesFrom(preferences);
        for (PreferenceValue preference : preferenceValues) {
            preference.applyTo(profile);
        }
    }

    private List<PreferenceValue> getPreferenceValuesFrom(String preferences) {
        ArrayList<PreferenceValue> preferenceValues = new ArrayList<PreferenceValue>();
        String preferenceSeparator = this.environmentVariables.getProperty(ThucydidesSystemProperty.FIREFOX_PREFERENCE_SEPARATOR, ";");
        System.out.println("Separator = " + preferenceSeparator);
        if (StringUtils.isNotEmpty((CharSequence)preferences)) {
            ArrayList<String> arguments = this.split(preferences, preferenceSeparator);
            for (String argument : arguments) {
                System.out.println("arg = " + argument);
                preferenceValues.addAll(this.convertToPreferenceValue(argument).map(Collections::singleton).orElse(Collections.emptySet()));
            }
        }
        return preferenceValues;
    }

    private Optional<PreferenceValue> convertToPreferenceValue(String argument) {
        ArrayList<String> arguments = this.split(argument, "=");
        if (arguments.size() == 1) {
            String key = (String)arguments.get(0);
            return Optional.of(new PreferenceValue(key, Boolean.TRUE));
        }
        if (arguments.size() == 2) {
            String key = (String)arguments.get(0);
            String value = (String)arguments.get(1);
            return Optional.of(new PreferenceValue(key, this.argumentValueOf(value)));
        }
        return Optional.empty();
    }

    private Object argumentValueOf(String value) {
        if (NumberUtils.isDigits((String)value)) {
            return Integer.parseInt(value);
        }
        if (value.toLowerCase().equals("true") || value.toLowerCase().equals("false")) {
            return Boolean.valueOf(value);
        }
        return value;
    }

    private ArrayList<String> split(String values, String separator) {
        return Lists.newArrayList((Iterable)Splitter.on((String)separator).trimResults().split((CharSequence)values));
    }

    static class PreferenceValue {
        private final String key;
        private final Object value;

        PreferenceValue(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        void applyTo(FirefoxProfile profile) {
            if (this.value instanceof Boolean) {
                profile.setPreference(this.key, ((Boolean)this.value).booleanValue());
            } else if (this.value instanceof Integer) {
                profile.setPreference(this.key, ((Integer)this.value).intValue());
            } else {
                profile.setPreference(this.key, this.value.toString());
            }
        }
    }
}

