/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.serenitybdd.core.exceptions.SerenityManagedException;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.webdriver.stubs.WebDriverStub;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.UnreachableBrowserException;

abstract class RemoteDriverBuilder {
    private final DriverCapabilityRecord driverProperties = (DriverCapabilityRecord)Injectors.getInjector().getInstance(DriverCapabilityRecord.class);
    private static final int WITHIN_THREE_SECONDS = 3000;

    RemoteDriverBuilder() {
    }

    abstract WebDriver buildWithOptions(String var1) throws MalformedURLException;

    WebDriver newRemoteDriver(URL remoteUrl, Capabilities capabilities) {
        if (StepEventBus.getEventBus().webdriverCallsAreSuspended()) {
            return new WebDriverStub();
        }
        try {
            this.ensureHostIsAvailableAt(remoteUrl);
            RemoteWebDriver driver = new RemoteWebDriver(remoteUrl, capabilities);
            this.driverProperties.registerCapabilities(capabilities.getBrowserName(), driver.getCapabilities());
            return driver;
        }
        catch (UnreachableBrowserException unreachableBrowser) {
            String errorMessage = this.unreachableBrowserErrorMessage((Exception)((Object)unreachableBrowser));
            throw new SerenityManagedException(errorMessage, unreachableBrowser);
        }
        catch (UnknownHostException unknownHost) {
            throw new SerenityManagedException(unknownHost.getMessage(), unknownHost);
        }
    }

    private void ensureHostIsAvailableAt(URL remoteUrl) throws UnknownHostException {
        if (!this.hostIsAvailableAt(remoteUrl)) {
            this.theRemoteServerIsUnavailable(remoteUrl.getHost() + " could not be reached");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hostIsAvailableAt(URL remoteUrl) {
        try (Socket socket = new Socket();){
            int port = remoteUrl.getPort() > 0 ? remoteUrl.getPort() : remoteUrl.getDefaultPort();
            socket.connect(new InetSocketAddress(remoteUrl.getHost(), port), 3000);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean pingHost(String host, int port, int timeout) {
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(host, port), timeout);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void theRemoteServerIsUnavailable(String message) throws UnknownHostException {
        throw new UnknownHostException(message);
    }

    private String unreachableBrowserErrorMessage(Exception unreachableBrowser) {
        List errorLines = Splitter.onPattern((String)"\n").splitToList((CharSequence)unreachableBrowser.getLocalizedMessage());
        Throwable cause = unreachableBrowser.getCause();
        String errorCause = cause == null ? "" : System.lineSeparator() + cause.getClass().getSimpleName() + " - " + cause.getLocalizedMessage();
        return (String)errorLines.get(0) + errorCause;
    }
}

