/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import net.serenitybdd.core.webdriver.driverproviders.BrowserStackDriverBuilder;
import net.serenitybdd.core.webdriver.driverproviders.DefaultRemoteDriver;
import net.serenitybdd.core.webdriver.driverproviders.DriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.RemoteDriverBuilder;
import net.serenitybdd.core.webdriver.driverproviders.SaucelabsDriverBuilder;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilityEnhancer;
import net.thucydides.core.webdriver.stubs.WebDriverStub;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Augmenter;

public class RemoteDriverProvider
implements DriverProvider {
    private final EnvironmentVariables environmentVariables;
    private final DriverCapabilities remoteDriverCapabilities;
    private final Map<RemoteDriverType, RemoteDriverBuilder> DRIVER_BUILDERS = new HashMap<RemoteDriverType, RemoteDriverBuilder>();

    public RemoteDriverProvider(EnvironmentVariables environmentVariables, CapabilityEnhancer enhancer) {
        this.environmentVariables = environmentVariables;
        this.remoteDriverCapabilities = new DriverCapabilities(environmentVariables, enhancer);
        this.DRIVER_BUILDERS.put(RemoteDriverType.SAUCELABS, new SaucelabsDriverBuilder(environmentVariables, this.remoteDriverCapabilities));
        this.DRIVER_BUILDERS.put(RemoteDriverType.BROWSERSTACK, new BrowserStackDriverBuilder(environmentVariables, this.remoteDriverCapabilities));
        this.DRIVER_BUILDERS.put(RemoteDriverType.DEFAULT, new DefaultRemoteDriver(environmentVariables, this.remoteDriverCapabilities));
    }

    @Override
    public WebDriver newInstance(String options) throws MalformedURLException {
        if (StepEventBus.getEventBus().webdriverCallsAreSuspended()) {
            return new WebDriverStub();
        }
        WebDriver driver = this.DRIVER_BUILDERS.get((Object)this.remoteDriverType()).buildWithOptions(options);
        return new Augmenter().augment(driver);
    }

    private RemoteDriverType remoteDriverType() {
        if (this.saucelabsUrlIsDefined()) {
            return RemoteDriverType.SAUCELABS;
        }
        if (this.browserStackUrlIsDefined()) {
            return RemoteDriverType.BROWSERSTACK;
        }
        return RemoteDriverType.DEFAULT;
    }

    private boolean saucelabsUrlIsDefined() {
        return StringUtils.isNotEmpty((CharSequence)ThucydidesSystemProperty.SAUCELABS_URL.from(this.environmentVariables));
    }

    private boolean browserStackUrlIsDefined() {
        return StringUtils.isNotEmpty((CharSequence)ThucydidesSystemProperty.BROWSERSTACK_URL.from(this.environmentVariables));
    }

    static enum RemoteDriverType {
        SAUCELABS,
        BROWSERSTACK,
        DEFAULT;

    }
}

