/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reflection;

import com.google.common.base.Optional;
import java.lang.reflect.Field;

public class FieldFinder {
    private final Class targetClass;

    private FieldFinder(Class targetClass) {
        this.targetClass = targetClass;
    }

    public static FieldFinder inClass(Class targetClass) {
        return new FieldFinder(targetClass);
    }

    public Optional<Field> findFieldCalled(String fieldName) {
        return this.findFieldCalled(fieldName, this.targetClass);
    }

    private Optional<Field> findFieldCalled(String fieldName, Class targetClass) {
        Field[] fields;
        for (Field field : fields = targetClass.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            return Optional.of((Object)field);
        }
        if (targetClass.getSuperclass() != null) {
            return this.findFieldCalled(fieldName, targetClass.getSuperclass());
        }
        return Optional.absent();
    }

    public Optional<Field> findFieldOfType(Class type) {
        return this.findFieldOfType(type, this.targetClass);
    }

    private Optional<Field> findFieldOfType(Class type, Class targetClass) {
        Field[] fields;
        for (Field field : fields = targetClass.getDeclaredFields()) {
            if (!field.getType().equals(type)) continue;
            return Optional.of((Object)field);
        }
        if (targetClass.getSuperclass() != null) {
            return this.findFieldOfType(type, targetClass.getSuperclass());
        }
        return Optional.absent();
    }
}

