/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import com.google.common.base.Optional;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.FormatConfiguration;
import net.thucydides.core.reports.OutcomeFormat;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.ThucydidesReporter;
import net.thucydides.core.reports.adaptors.TestOutcomeAdaptor;
import net.thucydides.core.reports.html.HtmlAcceptanceTestReporter;
import net.thucydides.core.reports.json.JSONTestOutcomeReporter;
import net.thucydides.core.reports.xml.XMLTestOutcomeReporter;
import net.thucydides.core.util.EnvironmentVariables;

public class TestOutcomeAdaptorReporter
extends ThucydidesReporter {
    private List<TestOutcomeAdaptor> adaptors = new ArrayList<TestOutcomeAdaptor>();
    private final Optional<File> NO_SOURCE_FILE = Optional.absent();
    private final FormatConfiguration formatConfiguration = new FormatConfiguration((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());

    public void generateReports() throws Exception {
        this.generateReports(this.NO_SOURCE_FILE);
    }

    public void generateReportsFrom(File sourceDirectory) throws Exception {
        this.generateReports((Optional<File>)Optional.fromNullable((Object)sourceDirectory));
    }

    public void generateReports(Optional<File> sourceDirectory) throws Exception {
        this.setupOutputDirectoryIfRequired();
        for (TestOutcomeAdaptor adaptor : this.adaptors) {
            List<TestOutcome> outcomes = sourceDirectory.isPresent() ? adaptor.loadOutcomesFrom((File)sourceDirectory.get()) : adaptor.loadOutcomes();
            this.generateReportsFor(outcomes);
        }
    }

    private void setupOutputDirectoryIfRequired() {
        if (this.getOutputDirectory() != null) {
            this.getOutputDirectory().mkdirs();
        }
    }

    private void generateReportsFor(List<TestOutcome> outcomes) throws Exception {
        TestOutcomes allOutcomes = TestOutcomes.of(outcomes);
        for (TestOutcome testOutcome : allOutcomes.getOutcomes()) {
            if (this.shouldGenerate(OutcomeFormat.XML)) {
                this.getXMLReporter().generateReportFor(testOutcome);
            }
            if (this.shouldGenerate(OutcomeFormat.JSON)) {
                this.getJsonReporter().generateReportFor(testOutcome);
            }
            this.getHTMLReporter().generateReportFor(testOutcome);
        }
    }

    private boolean shouldGenerate(OutcomeFormat format) {
        return this.formatConfiguration.getFormats().contains((Object)format);
    }

    private AcceptanceTestReporter getXMLReporter() {
        XMLTestOutcomeReporter reporter = new XMLTestOutcomeReporter();
        reporter.setOutputDirectory(this.getOutputDirectory());
        return reporter;
    }

    private AcceptanceTestReporter getJsonReporter() {
        JSONTestOutcomeReporter reporter = new JSONTestOutcomeReporter();
        reporter.setOutputDirectory(this.getOutputDirectory());
        return reporter;
    }

    private AcceptanceTestReporter getHTMLReporter() {
        HtmlAcceptanceTestReporter reporter = new HtmlAcceptanceTestReporter();
        reporter.setOutputDirectory(this.getOutputDirectory());
        return reporter;
    }

    public void registerAdaptor(TestOutcomeAdaptor adaptor) {
        this.adaptors.add(adaptor);
    }
}

