/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.requirements.BaseRequirementsService;
import net.thucydides.core.requirements.FileSystemRequirementsTagProvider;
import net.thucydides.core.requirements.PackageAnnotationBasedTagProvider;
import net.thucydides.core.requirements.ReleaseProvider;
import net.thucydides.core.requirements.RequirementsMerger;
import net.thucydides.core.requirements.RequirementsProviderService;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.statistics.service.AnnotationBasedTagProvider;
import net.thucydides.core.statistics.service.FeatureStoryTagProvider;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiSourceRequirementsService
extends BaseRequirementsService
implements RequirementsService {
    private List<RequirementsTagProvider> requirementsTagProviders;
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementsTagProvider.class);
    private static final List<String> LOW_PRIORITY_PROVIDERS = ImmutableList.of((Object)FileSystemRequirementsTagProvider.class.getCanonicalName(), (Object)PackageAnnotationBasedTagProvider.class.getCanonicalName(), (Object)AnnotationBasedTagProvider.class.getCanonicalName(), (Object)FeatureStoryTagProvider.class.getCanonicalName());

    public MultiSourceRequirementsService() {
        super((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    @Override
    public List<Requirement> getRequirements() {
        RequirementsMerger merger = new RequirementsMerger();
        if (this.requirements == null || this.requirements.isEmpty()) {
            this.requirements = Lists.newArrayList();
            for (RequirementsTagProvider tagProvider : this.getRequirementsTagProviders()) {
                LOGGER.trace("Reading requirements from " + tagProvider);
                List<Requirement> newRequirements = tagProvider.getRequirements();
                this.requirements = merger.merge(this.requirements, newRequirements);
            }
            this.requirements = this.addParentsTo(this.requirements);
            this.indexRequirements();
            LOGGER.debug("Requirements found:" + this.requirements);
        }
        return this.requirements;
    }

    @Override
    public Optional<ReleaseProvider> getReleaseProvider() {
        List<RequirementsTagProvider> requirementsTagProviders = this.getRequirementsTagProviders();
        for (RequirementsTagProvider provider : requirementsTagProviders) {
            if (!(provider instanceof ReleaseProvider) || !((ReleaseProvider)((Object)provider)).isActive()) continue;
            return Optional.of((Object)((ReleaseProvider)((Object)provider)));
        }
        return Optional.absent();
    }

    public List<RequirementsTagProvider> getRequirementsTagProviders() {
        if (this.requirementsTagProviders == null) {
            RequirementsProviderService requirementsProviderService = (RequirementsProviderService)Injectors.getInjector().getInstance(RequirementsProviderService.class);
            this.requirementsTagProviders = this.reprioritizeProviders(this.active(requirementsProviderService.getRequirementsProviders()));
        }
        return this.requirementsTagProviders;
    }

    private List<RequirementsTagProvider> active(List<RequirementsTagProvider> requirementsProviders) {
        boolean useDirectoryBasedRequirements = ThucydidesSystemProperty.THUCYDIDES_USE_REQUIREMENTS_DIRECTORIES.booleanFrom(this.environmentVariables, true);
        if (useDirectoryBasedRequirements) {
            return requirementsProviders;
        }
        ArrayList activeRequirementsProviders = Lists.newArrayList();
        for (RequirementsTagProvider provider : requirementsProviders) {
            if (provider instanceof FileSystemRequirementsTagProvider) continue;
            activeRequirementsProviders.add(provider);
        }
        return activeRequirementsProviders;
    }

    private List<RequirementsTagProvider> reprioritizeProviders(List<RequirementsTagProvider> requirementsTagProviders) {
        HashMap lowPriorityProviders = Maps.newHashMap();
        ArrayList prioritizedProviders = Lists.newArrayList();
        for (RequirementsTagProvider provider : requirementsTagProviders) {
            if (LOW_PRIORITY_PROVIDERS.contains(provider.getClass().getCanonicalName())) {
                lowPriorityProviders.put(provider.getClass().getCanonicalName(), provider);
                continue;
            }
            prioritizedProviders.add(provider);
        }
        this.addLowPriorityProviders(lowPriorityProviders, prioritizedProviders);
        return prioritizedProviders;
    }

    private void addLowPriorityProviders(Map<String, RequirementsTagProvider> lowPriorityProviders, List<RequirementsTagProvider> prioritizedProviders) {
        for (String lowPriorityProvider : LOW_PRIORITY_PROVIDERS) {
            if (!lowPriorityProviders.containsKey(lowPriorityProvider)) continue;
            prioritizedProviders.add(lowPriorityProviders.get(lowPriorityProvider));
        }
    }
}

