/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations.locators;

import io.appium.java_client.pagefactory.AndroidFindBy;
import io.appium.java_client.pagefactory.AndroidFindBys;
import io.appium.java_client.pagefactory.iOSFindBy;
import io.appium.java_client.pagefactory.iOSFindBys;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import net.serenitybdd.core.pages.PageObject;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.core.pages.WebElementFacadeImpl;
import net.serenitybdd.core.pages.WidgetObject;
import net.thucydides.core.annotations.findby.FindBy;
import net.thucydides.core.annotations.locators.SmartElementHandler;
import net.thucydides.core.annotations.locators.SmartListHandler;
import net.thucydides.core.annotations.locators.SmartWidgetHandler;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.internal.Locatable;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.support.FindAll;
import org.openqa.selenium.support.FindBys;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;
import org.openqa.selenium.support.pagefactory.internal.LocatingElementHandler;
import org.openqa.selenium.support.pagefactory.internal.LocatingElementListHandler;

public class SmartFieldDecorator
implements FieldDecorator {
    protected ElementLocatorFactory factory;
    protected WebDriver driver;
    protected PageObject page;
    private static final List<Class<? extends Annotation>> LEGAL_ANNOTATIONS = Arrays.asList(net.serenitybdd.core.annotations.findby.FindBy.class, FindBy.class, org.openqa.selenium.support.FindBy.class, FindBys.class, FindAll.class, AndroidFindBy.class, AndroidFindBys.class, iOSFindBy.class, iOSFindBys.class);

    public SmartFieldDecorator(ElementLocatorFactory factory, WebDriver driver, PageObject pageObject) {
        this.driver = driver;
        this.factory = factory;
        this.page = pageObject;
    }

    public Object decorate(ClassLoader loader, Field field) {
        if (!WebElement.class.isAssignableFrom(field.getType()) && !this.isDecoratableList(field) || field.getDeclaringClass() == WebElementFacadeImpl.class) {
            return null;
        }
        ElementLocator locator = this.factory.createLocator(field);
        if (locator == null) {
            return null;
        }
        Class<?> fieldType = field.getType();
        if (WebElement.class.isAssignableFrom(fieldType)) {
            return this.proxyForLocator(loader, fieldType, locator);
        }
        if (List.class.isAssignableFrom(fieldType)) {
            Class erasureClass = this.getErasureClass(field);
            return this.proxyForListLocator(loader, erasureClass, locator);
        }
        return null;
    }

    private Class getErasureClass(Field field) {
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            return null;
        }
        return (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
    }

    private boolean isDecoratableList(Field field) {
        if (!List.class.isAssignableFrom(field.getType())) {
            return false;
        }
        Class erasureClass = this.getErasureClass(field);
        if (erasureClass == null || !WebElement.class.isAssignableFrom(erasureClass)) {
            return false;
        }
        return this.annotatedByLegalFindByAnnotation(field);
    }

    private boolean annotatedByLegalFindByAnnotation(Field field) {
        for (Annotation annotation : field.getAnnotations()) {
            if (!LEGAL_ANNOTATIONS.contains(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    protected <T> T proxyForLocator(ClassLoader loader, Class<T> interfaceType, ElementLocator locator) {
        Object proxy = null;
        if (WidgetObject.class.isAssignableFrom(interfaceType)) {
            SmartWidgetHandler handler = new SmartWidgetHandler(interfaceType, locator, this.page);
            proxy = Proxy.newProxyInstance(loader, new Class[]{interfaceType}, (InvocationHandler)handler);
        } else if (WebElementFacade.class.isAssignableFrom(interfaceType)) {
            SmartElementHandler handler = new SmartElementHandler(interfaceType, locator, this.page);
            proxy = Proxy.newProxyInstance(loader, new Class[]{interfaceType}, (InvocationHandler)handler);
        } else {
            LocatingElementHandler handler = new LocatingElementHandler(locator);
            proxy = Proxy.newProxyInstance(loader, new Class[]{WebElement.class, WrapsElement.class, Locatable.class}, (InvocationHandler)handler);
        }
        return (T)proxy;
    }

    protected <T> List<T> proxyForListLocator(ClassLoader loader, Class<T> interfaceType, ElementLocator locator) {
        Object handler = null;
        handler = WebElementFacade.class.isAssignableFrom(interfaceType) ? new SmartListHandler(loader, interfaceType, locator, this.page, this.page.implicitTimoutMilliseconds(), this.page.waitForTimeoutInMilliseconds()) : new LocatingElementListHandler(locator);
        return (List)Proxy.newProxyInstance(loader, new Class[]{List.class}, (InvocationHandler)handler);
    }
}

