/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.thucydides.core.annotations.TestAnnotations;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.html.Formatter;

class TestOutcomeAnnotationReader {
    private final TestOutcome testOutcome;

    public static TestOutcomeAnnotationReader forTestOutcome(TestOutcome testOutcome) {
        return new TestOutcomeAnnotationReader(testOutcome);
    }

    TestOutcomeAnnotationReader(TestOutcome testOutcome) {
        this.testOutcome = testOutcome;
    }

    public static List<String> readIssuesIn(TestOutcome testOutcome) {
        ArrayList<String> taggedIssues = new ArrayList<String>();
        if (testOutcome.getTestCase() != null) {
            TestOutcomeAnnotationReader.addMethodLevelIssuesTo(testOutcome, taggedIssues);
            TestOutcomeAnnotationReader.addClassLevelIssuesTo(testOutcome, taggedIssues);
        }
        TestOutcomeAnnotationReader.addTitleLevelIssuesTo(testOutcome, taggedIssues);
        return taggedIssues;
    }

    public static List<String> readVersionsIn(TestOutcome testOutcome) {
        ArrayList<String> taggedVersions = new ArrayList<String>();
        if (testOutcome.getTestCase() != null) {
            TestOutcomeAnnotationReader.addMethodLevelVersionsTo(testOutcome, taggedVersions);
            TestOutcomeAnnotationReader.addClassLevelVersionsTo(testOutcome, taggedVersions);
        }
        return taggedVersions;
    }

    private static void addClassLevelIssuesTo(TestOutcome testOutcome, List<String> issues) {
        String[] classIssues;
        String classIssue = TestAnnotations.forClass(testOutcome.getTestCase()).getAnnotatedIssueForTestCase(testOutcome.getTestCase());
        if (classIssue != null) {
            issues.add(classIssue);
        }
        if ((classIssues = TestAnnotations.forClass(testOutcome.getTestCase()).getAnnotatedIssuesForTestCase(testOutcome.getTestCase())) != null) {
            issues.addAll(Arrays.asList(classIssues));
        }
    }

    private static void addMethodLevelIssuesTo(TestOutcome testOutcome, List<String> issues) {
        Optional<String> issue = TestAnnotations.forClass(testOutcome.getTestCase()).getAnnotatedIssueForMethod(testOutcome.getName());
        issue.ifPresent(issues::add);
        String[] multipleIssues = TestAnnotations.forClass(testOutcome.getTestCase()).getAnnotatedIssuesForMethod(testOutcome.getName());
        issues.addAll(Arrays.asList(multipleIssues));
    }

    private static void addTitleLevelIssuesTo(TestOutcome testOutcome, List<String> issues) {
        List<String> titleIssues = Formatter.issuesIn(testOutcome.getTitle());
        if (!titleIssues.isEmpty()) {
            issues.addAll(titleIssues);
        }
    }

    private static void addClassLevelVersionsTo(TestOutcome testOutcome, List<String> versions) {
        String classVersion = TestAnnotations.forClass(testOutcome.getTestCase()).getAnnotatedVersionForTestCase(testOutcome.getTestCase());
        if (classVersion != null) {
            versions.add(classVersion);
        }
    }

    private static void addMethodLevelVersionsTo(TestOutcome testOutcome, List<String> versions) {
        Optional<String> version = TestAnnotations.forClass(testOutcome.getTestCase()).getAnnotatedVersionForMethod(testOutcome.getName());
        version.ifPresent(versions::add);
    }
}

