/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.base.Objects;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.serenitybdd.core.time.Stopwatch;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.ReportOptions;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.BaseReportingTask;
import net.thucydides.core.reports.html.Breadcrumbs;
import net.thucydides.core.reports.html.FreemarkerContext;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.reports.html.TestOutcomeTimestamp;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.reports.RequirementsOutcomes;
import net.thucydides.core.tags.BreadcrumbTagFilter;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequirementsOverviewReportingTask
extends BaseReportingTask
implements ReportingTask {
    private static final String DEFAULT_REQUIREMENTS_REPORT = "freemarker/requirements.ftl";
    private static final String REPORT_NAME = "capabilities.html";
    protected static final Logger LOGGER = LoggerFactory.getLogger(RequirementsOverviewReportingTask.class);
    private final ReportNameProvider reportNameProvider;
    private final RequirementsOutcomes requirementsOutcomes;
    private final RequirementsService requirementsService;
    private final TestOutcomes testOutcomes;
    private final String relativeLink;
    private final String reportName;

    public RequirementsOverviewReportingTask(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, ReportNameProvider reportNameProvider, RequirementsService requirementsService, RequirementsOutcomes requirementsOutcomes, String relativeLink, TestOutcomes testOutcomes) {
        super(freemarker, environmentVariables, outputDirectory);
        this.reportNameProvider = reportNameProvider;
        this.requirementsOutcomes = requirementsOutcomes;
        this.requirementsService = requirementsService;
        this.testOutcomes = testOutcomes;
        this.relativeLink = relativeLink;
        this.reportName = REPORT_NAME;
    }

    public RequirementsOverviewReportingTask(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, ReportNameProvider reportNameProvider, RequirementsService requirementsService, RequirementsOutcomes requirementsOutcomes, String relativeLink, TestOutcomes testOutcomes, String reportName) {
        super(freemarker, environmentVariables, outputDirectory);
        this.reportNameProvider = reportNameProvider;
        this.requirementsOutcomes = requirementsOutcomes;
        this.requirementsService = requirementsService;
        this.testOutcomes = testOutcomes;
        this.relativeLink = relativeLink;
        this.reportName = reportName;
    }

    @Override
    public void generateReports() throws IOException {
        Stopwatch stopwatch = Stopwatch.started();
        Map<String, Object> context = this.freemarker.getBuildContext(this.requirementsOutcomes.getTestOutcomes(), this.reportNameProvider, true);
        context.put("requirements", this.requirementsOutcomes.withoutUnrelatedRequirements());
        context.put("requirementTypes", this.requirementsService.getRequirementTypes());
        context.put("testOutcomes", this.requirementsOutcomes.getTestOutcomes());
        context.put("allTestOutcomes", this.testOutcomes);
        context.put("timestamp", TestOutcomeTimestamp.from(this.testOutcomes));
        context.put("reportName", new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, this.requirementsService));
        context.put("absoluteReportName", new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, this.requirementsService));
        context.put("reportOptions", new ReportOptions(ConfiguredEnvironment.getEnvironmentVariables()));
        context.put("relativeLink", this.relativeLink);
        this.addBreadcrumbs(this.requirementsOutcomes, context, this.requirementsOutcomes.getTestOutcomes().getTags());
        this.generateReportPage(context, DEFAULT_REQUIREMENTS_REPORT, this.reportName);
        LOGGER.trace("Requirements report generated: {} in {} ms", (Object)this.reportName, (Object)stopwatch.stop());
    }

    private void addBreadcrumbs(RequirementsOutcomes requirementsOutcomes, Map<String, Object> context, List<TestTag> allTags) {
        if (this.requirementsOutcomes.getParentRequirement().isPresent()) {
            context.put("breadcrumbs", Breadcrumbs.forRequirementsTag(((Requirement)this.requirementsOutcomes.getParentRequirement().get()).asTag()).fromTagsIn(allTags));
        } else {
            context.put("breadcrumbs", new BreadcrumbTagFilter().getRequirementBreadcrumbsFrom(requirementsOutcomes));
        }
    }

    public String toString() {
        return "Requirements report " + this.reportName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequirementsOverviewReportingTask that = (RequirementsOverviewReportingTask)o;
        return Objects.equal((Object)this.reportName, (Object)that.reportName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.reportName});
    }
}

