/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import net.thucydides.core.steps.service.CleanupMethodAnnotationProvider;

public class CleanupMethodLocator {
    private final List<String> cleanupMethodsAnnotations = new ArrayList<String>();

    public CleanupMethodLocator() {
        ServiceLoader<CleanupMethodAnnotationProvider> cleanupMethodAnnotationProviders = ServiceLoader.load(CleanupMethodAnnotationProvider.class);
        for (CleanupMethodAnnotationProvider cleanupMethodAnnotationProvider : cleanupMethodAnnotationProviders) {
            this.cleanupMethodsAnnotations.addAll(cleanupMethodAnnotationProvider.getCleanupMethodAnnotations());
        }
    }

    public boolean currentMethodWasCalledFromACleanupMethod() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        return Arrays.stream(stackTrace).anyMatch(this::isAnnotatedWithAFixtureMethod);
    }

    private boolean isAnnotatedWithAFixtureMethod(StackTraceElement stackTraceElement) {
        try {
            Method method = Class.forName(stackTraceElement.getClassName()).getMethod(stackTraceElement.getMethodName(), new Class[0]);
            return Arrays.stream(method.getAnnotations()).anyMatch(annotation -> this.isAnAfterAnnotation(annotation.annotationType().getSimpleName()) || this.cleanupMethodsAnnotations.contains(annotation.toString()));
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private boolean isAnAfterAnnotation(String annotationName) {
        return annotationName.startsWith("After");
    }
}

