/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.shadowdom;

import java.util.List;
import java.util.stream.Collectors;
import net.serenitybdd.core.annotations.findby.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class ByExpandedShadowDom
extends By {
    private final String shadowDomSelector;

    private ByExpandedShadowDom(String selector) {
        this.shadowDomSelector = selector;
    }

    public static ByExpandedShadowDom of(String selector) {
        return new ByExpandedShadowDom(selector);
    }

    public List<WebElement> findElements(SearchContext context) {
        List rootElements = context.findElements(By.cssSelector((String)this.shadowDomSelector));
        return rootElements.stream().map(element -> this.expandRootElement(context, (WebElement)element)).collect(Collectors.toList());
    }

    public WebElement findElement(SearchContext context) {
        WebElement rootElement = context.findElement(By.cssSelector((String)this.shadowDomSelector));
        return this.expandRootElement(context, rootElement);
    }

    public String toString() {
        return "By.shadowDomSelector: " + this.shadowDomSelector;
    }

    private WebElement expandRootElement(SearchContext context, WebElement element) {
        return (WebElement)((JavascriptExecutor)context).executeScript("return arguments[0].shadowRoot", new Object[]{element});
    }
}

