/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.environment;

import com.typesafe.config.Config;
import java.util.Optional;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.thucydides.core.util.EnvironmentVariables;
import org.openqa.selenium.MutableCapabilities;

public class CustomDriverConfig {
    public static String fetchContextFrom(MutableCapabilities capabilities, EnvironmentVariables environmentVariables, String name) {
        String browserName = capabilities.getBrowserName();
        Optional<Config> ltOptions = CustomDriverConfig.webdriverCapabilitiesConfig(environmentVariables, name);
        String os = null;
        if (ltOptions.isPresent() && ltOptions.get().hasPath("platformName")) {
            os = ltOptions.get().getString("platformName");
        }
        return os != null ? browserName + ", " + os : browserName;
    }

    public static Optional<Config> webdriverCapabilitiesConfig(EnvironmentVariables environmentVariables, String name) {
        Config webdriverCapabilities = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getConfig("webdriver.capabilities");
        if (webdriverCapabilities.hasPath(name)) {
            return Optional.of(webdriverCapabilities.getConfig(name));
        }
        return Optional.empty();
    }
}

