/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import com.google.common.base.Splitter;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.List;
import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.serenitybdd.core.di.WebDriverInjectors;
import net.serenitybdd.core.exceptions.SerenityManagedException;
import net.serenitybdd.core.webdriver.driverproviders.CapabilitiesConverter;
import net.serenitybdd.core.webdriver.driverproviders.RemoteWebdriverStub;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.appium.AppiumConfiguration;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.UnreachableBrowserException;

abstract class RemoteDriverBuilder {
    private final DriverCapabilityRecord driverProperties;
    protected final EnvironmentVariables environmentVariables;

    RemoteDriverBuilder(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.driverProperties = (DriverCapabilityRecord)WebDriverInjectors.getInjector().getInstance(DriverCapabilityRecord.class);
    }

    abstract WebDriver buildWithOptions(String var1) throws MalformedURLException;

    WebDriver newRemoteDriver(URL remoteUrl, Capabilities remoteCapabilities, String options) {
        if (StepEventBus.getParallelEventBus().webdriverCallsAreSuspended()) {
            return RemoteWebdriverStub.from(this.environmentVariables);
        }
        try {
            RemoteWebDriver driver;
            this.ensureHostIsAvailableAt(remoteUrl);
            switch (AppiumConfiguration.from(this.environmentVariables).definedTargetPlatform()) {
                case IOS: {
                    DesiredCapabilities iosCapabilities = AppiumConfiguration.from(this.environmentVariables).getCapabilities(options);
                    driver = new IOSDriver(remoteUrl, iosCapabilities.merge(remoteCapabilities));
                    break;
                }
                case ANDROID: {
                    DesiredCapabilities androidCapabilities = AppiumConfiguration.from(this.environmentVariables).getCapabilities(options);
                    driver = new AndroidDriver(remoteUrl, androidCapabilities.merge(remoteCapabilities));
                    break;
                }
                default: {
                    driver = new RemoteWebDriver(remoteUrl, remoteCapabilities);
                }
            }
            this.driverProperties.registerCapabilities(remoteCapabilities.getBrowserName(), CapabilitiesConverter.capabilitiesToProperties(driver.getCapabilities()));
            return driver;
        }
        catch (UnreachableBrowserException unreachableBrowser) {
            String errorMessage = this.unreachableBrowserErrorMessage((Exception)((Object)unreachableBrowser));
            throw new SerenityManagedException(errorMessage, (Throwable)unreachableBrowser);
        }
        catch (UnknownHostException unknownHost) {
            throw new SerenityManagedException(unknownHost.getMessage(), (Throwable)unknownHost);
        }
    }

    private void ensureHostIsAvailableAt(URL remoteUrl) throws UnknownHostException {
        try {
            this.hostShouldBeAvailableAt(remoteUrl);
        }
        catch (IOException hostUnavailable) {
            this.theRemoteServerIsUnavailable("The remote URL at " + remoteUrl.getRef() + " could not be reached." + System.lineSeparator() + "(Possible cause: " + hostUnavailable.getLocalizedMessage() + ")");
        }
    }

    private void hostShouldBeAvailableAt(URL remoteUrl) throws IOException {
        URLConnection urlConnection = remoteUrl.openConnection();
        urlConnection.connect();
    }

    private void theRemoteServerIsUnavailable(String message) throws UnknownHostException {
        throw new UnknownHostException(message);
    }

    private String unreachableBrowserErrorMessage(Exception unreachableBrowser) {
        List errorLines = Splitter.onPattern((String)"\n").splitToList((CharSequence)unreachableBrowser.getLocalizedMessage());
        Throwable cause = unreachableBrowser.getCause();
        String errorCause = cause == null ? "" : System.lineSeparator() + cause.getClass().getSimpleName() + " - " + cause.getLocalizedMessage();
        return (String)errorLines.get(0) + errorCause;
    }
}

