/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import net.serenitybdd.core.di.SerenityInfrastructure;
import net.serenitybdd.core.webdriver.driverproviders.ConfigureChromiumOptions;
import net.serenitybdd.core.webdriver.driverproviders.DownloadableDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.EnhanceCapabilitiesWithFixtures;
import net.serenitybdd.core.webdriver.driverproviders.UpdateDriverEnvironmentProperty;
import net.serenitybdd.model.buildinfo.DriverCapabilityRecord;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.TestContext;
import net.thucydides.core.webdriver.capabilities.W3CCapabilities;
import net.thucydides.core.webdriver.stubs.WebDriverStub;
import net.thucydides.model.util.EnvironmentVariables;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chromium.ChromiumOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeOptions;

public class EdgeDriverProvider
extends DownloadableDriverProvider
implements DriverProvider {
    private final DriverCapabilityRecord driverProperties;
    private final FixtureProviderService fixtureProviderService;

    public EdgeDriverProvider(FixtureProviderService fixtureProviderService) {
        this.fixtureProviderService = fixtureProviderService;
        this.driverProperties = SerenityInfrastructure.getDriverCapabilityRecord();
    }

    @Override
    public WebDriver newInstance(String options, EnvironmentVariables environmentVariables) {
        if (StepEventBus.getParallelEventBus().webdriverCallsAreSuspended()) {
            return new WebDriverStub();
        }
        UpdateDriverEnvironmentProperty.forDriverProperty("webdriver.edge.driver");
        EdgeOptions edgeOptions = W3CCapabilities.definedIn(environmentVariables).withPrefix("webdriver.capabilities").edgeOptions();
        edgeOptions.addArguments(this.argumentsIn(options));
        EdgeOptions enhancedOptions = (EdgeOptions)ConfigureChromiumOptions.from(environmentVariables).into((ChromiumOptions<?>)edgeOptions);
        EnhanceCapabilitiesWithFixtures.using(this.fixtureProviderService).into((MutableCapabilities)edgeOptions);
        TestContext.forTheCurrentTest().recordBrowserConfiguration((Capabilities)enhancedOptions);
        TestContext.forTheCurrentTest().recordCurrentPlatform();
        this.driverProperties.registerCapabilities("edge", this.capabilitiesToProperties((Capabilities)enhancedOptions));
        return new EdgeDriver(enhancedOptions);
    }
}

