/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.serenitybdd.annotations.Fields;
import net.serenitybdd.annotations.Shared;
import net.serenitybdd.annotations.Steps;
import net.serenitybdd.core.steps.UIInteractionSteps;
import net.thucydides.core.annotations.InvalidStepsFieldException;
import net.thucydides.model.reflection.FieldSetter;
import net.thucydides.model.util.Inflector;
import org.apache.commons.lang3.StringUtils;

public class StepsAnnotatedField {
    private Field field;
    private static final String NO_ANNOTATED_FIELD_ERROR = "No field annotated with @Steps was found in the test case.";

    public String getFieldName() {
        return this.field.getName();
    }

    public static List<StepsAnnotatedField> findMandatoryAnnotatedFields(Class<?> clazz) {
        List<StepsAnnotatedField> annotatedFields = StepsAnnotatedField.findOptionalAnnotatedFields(clazz);
        if (annotatedFields.isEmpty()) {
            throw new InvalidStepsFieldException(NO_ANNOTATED_FIELD_ERROR);
        }
        return annotatedFields;
    }

    public static List<StepsAnnotatedField> findOptionalAnnotatedFields(Class<?> clazz) {
        return Fields.of(clazz).allFields().stream().filter(field -> StepsAnnotatedField.fieldIsAnnotated(field) || StepsAnnotatedField.isAUIInteraction(field)).map(StepsAnnotatedField::new).collect(Collectors.toList());
    }

    private static boolean isAUIInteraction(Field field) {
        return UIInteractionSteps.class.isAssignableFrom(field.getType());
    }

    private static boolean fieldIsAnnotated(Field field) {
        return StepsAnnotatedField.fieldIsAnnotatedCorrectly(field);
    }

    private static boolean fieldIsAnnotatedCorrectly(Field field) {
        return field.getAnnotation(Steps.class) != null || field.getAnnotation(Shared.class) != null;
    }

    protected StepsAnnotatedField(Field field) {
        this.field = field;
    }

    protected FieldSetter set(Object targetObject) {
        return new FieldSetter(this.field, targetObject);
    }

    public void setValue(Object field, Object value) {
        try {
            this.set(field).to(value);
        }
        catch (IllegalAccessException e) {
            throw new InvalidStepsFieldException("Could not access or set field: " + String.valueOf(field), e);
        }
    }

    public boolean isInstantiated(Object testCase) {
        try {
            this.field.setAccessible(true);
            Object fieldValue = this.field.get(testCase);
            return fieldValue != null;
        }
        catch (IllegalAccessException e) {
            throw new InvalidStepsFieldException("Could not access or set @Steps field: " + String.valueOf(this.field), e);
        }
    }

    public Class<?> getFieldClass() {
        return this.field.getType();
    }

    public boolean isSharedInstance() {
        return this.field.getAnnotation(Shared.class) != null || this.isSharedStep();
    }

    private boolean isSharedStep() {
        return this.field.getAnnotation(Steps.class) != null && this.field.getAnnotation(Steps.class).shared();
    }

    public boolean isUniqueInstance() {
        return this.field.getAnnotation(Steps.class) != null && this.field.getAnnotation(Steps.class).uniqueInstance();
    }

    public Optional<String> actor() {
        String nameValue = this.getActorAttribute();
        if (StringUtils.isEmpty((CharSequence)nameValue)) {
            return Optional.empty();
        }
        return Optional.of(nameValue);
    }

    private String getActorAttribute() {
        if (this.field.getAnnotation(Steps.class) != null) {
            return this.field.getAnnotation(Steps.class).actor();
        }
        if (this.field.getAnnotation(Shared.class) != null) {
            return this.field.getAnnotation(Shared.class).actor();
        }
        return null;
    }

    public void assignActorNameIn(Object steps) {
        String actorName = this.actor().orElse(this.humanReadable(this.getFieldName()));
        if (StringUtils.isNotBlank((CharSequence)actorName)) {
            this.actorFieldIn(steps).ifPresent(field -> this.assignValueToField((Field)field, steps, actorName));
        }
    }

    private String humanReadable(String fieldName) {
        return Inflector.getInstance().of(fieldName).asATitle().toString();
    }

    private void assignValueToField(Field field, Object steps, String value) {
        field.setAccessible(true);
        try {
            field.set(steps, value);
        }
        catch (IllegalAccessException e) {
            throw new InvalidStepsFieldException("Could not access or set name field: " + String.valueOf(field), e);
        }
    }

    private Optional<Field> actorFieldIn(Object steps) {
        return Fields.of(steps.getClass()).allFields().stream().filter(field -> field.getName().equals("actor") && field.getType().equals(String.class)).findFirst();
    }
}

