/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps.events;

import net.serenitybdd.core.webdriver.RemoteDriver;
import net.thucydides.core.steps.events.StepEventBusEventBase;
import net.thucydides.core.steps.session.TestSession;
import net.thucydides.core.webdriver.SerenityWebdriverManager;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebDriverFacade;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.SessionId;

public class ExampleFinishedEvent
extends StepEventBusEventBase {
    private SessionId webSessionId;
    private String driverUsedInThisTest;
    private WebDriver webDriver;

    public ExampleFinishedEvent() {
        this.saveCurrentWebDriverContext();
    }

    private void saveCurrentWebDriverContext() {
        WebDriverFacade currentDriver = (WebDriverFacade)SerenityWebdriverManager.inThisTestThread().getCurrentDriver();
        if (currentDriver != null && currentDriver.isInstantiated()) {
            if (RemoteDriver.isARemoteDriver(currentDriver)) {
                SessionId sessionId = RemoteDriver.of(currentDriver).getSessionId();
                this.setWebSessionId(sessionId);
            }
            this.setWebDriver(currentDriver);
            this.setDriverUsedInThisTest(ThucydidesWebDriverSupport.getDriversUsed());
        }
    }

    @Override
    public void play() {
        if (this.getWebSessionId() != null) {
            TestSession.getTestSessionContext().setWebSessionId(this.getWebSessionId());
        }
        if (this.getWebDriver() != null) {
            TestSession.getTestSessionContext().setWebDriver(this.getWebDriver());
        }
        if (this.getDriverUsedInThisTest() != null) {
            TestSession.getTestSessionContext().setDriverUsedInThisTest(this.getDriverUsedInThisTest());
        }
        this.getStepEventBus().exampleFinished();
    }

    public String toString() {
        return "EventBusEvent EXAMPLE_FINISHED_EVENT ";
    }

    public SessionId getWebSessionId() {
        return this.webSessionId;
    }

    public void setWebSessionId(SessionId webSessionId) {
        this.webSessionId = webSessionId;
    }

    public String getDriverUsedInThisTest() {
        return this.driverUsedInThisTest;
    }

    public void setDriverUsedInThisTest(String driverUsedInThisTest) {
        this.driverUsedInThisTest = driverUsedInThisTest;
    }

    public WebDriver getWebDriver() {
        return this.webDriver;
    }

    public void setWebDriver(WebDriver webDriver) {
        this.webDriver = webDriver;
    }
}

