/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.capabilities.BrowserStackRemoteDriverCapabilities;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

public class DriverStrategySelector {
    private final EnvironmentVariables environmentVariables;
    private final BrowserStackRemoteDriverCapabilities browserStackRemoteDriverCapabilities;

    public DriverStrategySelector(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.browserStackRemoteDriverCapabilities = new BrowserStackRemoteDriverCapabilities(environmentVariables);
    }

    public static DriverStrategySelector inEnvironment(EnvironmentVariables environmentVariables) {
        return new DriverStrategySelector(environmentVariables);
    }

    public SupportedWebDriver forDriverClass(Class<? extends WebDriver> driverClass) {
        if (this.isARemoteDriver(driverClass) || this.shouldUseARemoteDriver()) {
            return SupportedWebDriver.REMOTE;
        }
        return SupportedWebDriver.forClass(driverClass);
    }

    public boolean isARemoteDriver(Class<? extends WebDriver> driverClass) {
        return RemoteWebDriver.class == driverClass;
    }

    public boolean shouldUseARemoteDriver() {
        return ThucydidesSystemProperty.WEBDRIVER_REMOTE_URL.isDefinedIn(this.environmentVariables);
    }

    public boolean sauceLabsIsUsed() {
        return StringUtils.isNotEmpty((CharSequence)ThucydidesSystemProperty.SAUCELABS_URL.from(this.environmentVariables));
    }

    public boolean browserStackUrlIsDefined() {
        return StringUtils.isNotEmpty((CharSequence)this.browserStackRemoteDriverCapabilities.getUrl());
    }
}

