/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.configuration;

import java.util.Optional;
import net.thucydides.core.webdriver.DriverConfiguration;
import net.thucydides.core.webdriver.DriverConfigurationError;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.model.configuration.SystemPropertiesConfiguration;
import net.thucydides.model.util.EnvironmentVariables;

public class WebDriverConfiguration<T extends DriverConfiguration>
extends SystemPropertiesConfiguration
implements DriverConfiguration {
    public static final String DEFAULT_WEBDRIVER_DRIVER = "chrome";

    public WebDriverConfiguration(EnvironmentVariables environmentVariables) {
        super(environmentVariables);
    }

    @Override
    public SupportedWebDriver getDriverType() {
        Optional<String> driverDefinedInEnvironment = Optional.ofNullable(WebDriverFactory.getDriverFrom(this.getEnvironmentVariables()));
        Optional<String> driverDefinedInTest = ThucydidesWebDriverSupport.getDefaultDriverType();
        String driverType = this.driverTypeOf(driverDefinedInTest.orElse(driverDefinedInEnvironment.orElse(DEFAULT_WEBDRIVER_DRIVER)));
        return this.lookupSupportedDriverTypeFor(driverType);
    }

    private String driverTypeOf(String driverName) {
        return driverName.contains(":") ? driverName.substring(0, driverName.indexOf(":")) : driverName;
    }

    private SupportedWebDriver lookupSupportedDriverTypeFor(String driverType) {
        SupportedWebDriver driver = null;
        try {
            driver = SupportedWebDriver.getDriverTypeFor(driverType);
        }
        catch (IllegalArgumentException iae) {
            this.throwUnsupportedDriverExceptionFor(driverType);
        }
        return driver;
    }

    private void throwUnsupportedDriverExceptionFor(String driverType) {
        throw new DriverConfigurationError(driverType + " is not a supported browser. Supported driver values are: " + SupportedWebDriver.listOfSupportedDrivers());
    }
}

