/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber;

import com.google.common.collect.ImmutableList;
import gherkin.formatter.model.Tag;
import java.util.List;

class TaggedScenario {
    private static final List<String> SKIPPED_TAGS = ImmutableList.of((Object)"@skip", (Object)"@wip");
    private static final List<String> IGNORED_TAGS = ImmutableList.of((Object)"@ignore", (Object)"@ignored");

    TaggedScenario() {
    }

    static boolean isPending(List<Tag> tags) {
        return TaggedScenario.hasTag("@pending", tags);
    }

    static boolean isManual(List<Tag> tags) {
        return TaggedScenario.hasTag("@manual", tags);
    }

    static boolean isSkippedOrWIP(List<Tag> tags) {
        for (Tag tag : tags) {
            if (!SKIPPED_TAGS.contains(tag.getName().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    static boolean isIgnored(List<Tag> tags) {
        for (Tag tag : tags) {
            if (!IGNORED_TAGS.contains(tag.getName().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasTag(String tagName, List<Tag> tags) {
        for (Tag tag : tags) {
            if (!tag.getName().equalsIgnoreCase(tagName)) continue;
            return true;
        }
        return false;
    }
}

