/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.adapters.junit4;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.adapters.JUnitStrategy;
import net.thucydides.core.annotations.TestAnnotations;
import net.thucydides.core.annotations.Title;
import net.thucydides.core.annotations.WithTag;
import net.thucydides.core.annotations.WithTagValuesOf;
import net.thucydides.core.annotations.WithTags;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.tags.Taggable;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.RunWith;

class JUnit4Strategy
implements JUnitStrategy {
    private final List<String> LEGAL_SERENITY_RUNNER_NAMES = NewList.of((Object[])new String[]{"SerenityRunner", "ThucydidesRunner", "SerenityParameterizedRunner", "ThucydidesParameterizedRunner"});

    JUnit4Strategy() {
    }

    public boolean isTestClass(Class<?> testClass) {
        return JUnit4Strategy.containsAnnotationCalled(testClass.getAnnotations(), "RunWith") || this.hasMethodWithTestAnnotation(testClass);
    }

    private boolean hasMethodWithTestAnnotation(Class<?> testClass) {
        return Arrays.stream(testClass.getMethods()).anyMatch(this::isTestMethod);
    }

    public boolean isTestMethod(Method method) {
        return JUnit4Strategy.containsAnnotationCalled(method.getAnnotations(), "Test");
    }

    public boolean isTestSetupMethod(Method method) {
        return JUnit4Strategy.containsAnnotationCalled(method.getAnnotations(), "Before") || JUnit4Strategy.containsAnnotationCalled(method.getAnnotations(), "BeforeClass");
    }

    public boolean isSerenityTestCase(Class<?> testClass) {
        RunWith runWithAnnotation = testClass.getAnnotation(RunWith.class);
        if (runWithAnnotation != null) {
            return this.LEGAL_SERENITY_RUNNER_NAMES.contains(runWithAnnotation.value().getSimpleName());
        }
        return false;
    }

    public boolean isAssumptionViolatedException(Throwable throwable) {
        return throwable instanceof AssumptionViolatedException;
    }

    public boolean isATaggableClass(Class<?> testClass) {
        RunWith runWith = testClass.getAnnotation(RunWith.class);
        return runWith != null && Taggable.class.isAssignableFrom(runWith.value());
    }

    public boolean isIgnored(Method method) {
        Annotation[] annotations = method.getAnnotations();
        return Arrays.stream(annotations).anyMatch(annotation -> annotation.annotationType().getSimpleName().equals("Ignore"));
    }

    public Optional<String> getTitleAnnotation(Method testMethod) {
        Title titleAnnotation = testMethod.getAnnotation(Title.class);
        if (titleAnnotation != null) {
            return Optional.of(titleAnnotation.value());
        }
        return Optional.empty();
    }

    public List<TestTag> getTagsFor(Method testMethod) {
        ArrayList<TestTag> tags = new ArrayList<TestTag>();
        TestAnnotations.addTagValues(tags, (WithTagValuesOf)testMethod.getAnnotation(WithTagValuesOf.class));
        TestAnnotations.addTags(tags, (WithTags)testMethod.getAnnotation(WithTags.class));
        TestAnnotations.addTag(tags, (WithTag)testMethod.getAnnotation(WithTag.class));
        return tags;
    }

    private static boolean containsAnnotationCalled(Annotation[] annotations, String annotationName) {
        return Arrays.stream(annotations).anyMatch(annotation -> annotation.annotationType().getSimpleName().equals(annotationName));
    }
}

