/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestType;
import net.thucydides.core.reports.TestOutcomeCounter;
import net.thucydides.core.reports.TestOutcomes;

public class OutcomeCounter
extends TestOutcomeCounter {
    private final TestOutcomes outcomes;

    public OutcomeCounter(TestType testType, TestOutcomes outcomes) {
        super(testType);
        this.outcomes = outcomes.ofType(testType);
    }

    public int withResult(String expectedResult) {
        return this.withResult(TestResult.valueOf(expectedResult.toUpperCase()));
    }

    public int percentageWithResult(String expectedResult) {
        return this.percentageWithResult(TestResult.valueOf(expectedResult.toUpperCase()));
    }

    public int withResult(TestResult expectedResult) {
        int totalResults = 0;
        for (TestOutcome testOutcome : this.outcomes.getOutcomes()) {
            totalResults += testOutcome.countResults(expectedResult);
        }
        return totalResults;
    }

    public int percentageWithResult(TestResult expectedResult) {
        int totalResults = this.withResult(expectedResult);
        int totalAllResults = this.getTotal();
        return totalAllResults == 0 ? 0 : totalResults * 100 / totalAllResults;
    }

    public int getTotal() {
        return this.outcomes.getTotal();
    }

    public int withIndeterminateResult() {
        return this.outcomes.getTotal() - this.withResult(TestResult.SUCCESS) - this.withResult(TestResult.FAILURE) - this.withResult(TestResult.ERROR) - this.withResult(TestResult.COMPROMISED);
    }

    public int withFailureOrError() {
        return this.withResult(TestResult.FAILURE) + this.withResult(TestResult.ERROR) + this.withResult(TestResult.COMPROMISED);
    }

    public int withCompromisedResults() {
        return this.withResult(TestResult.COMPROMISED);
    }

    public int withAnyResult() {
        return this.outcomes.getTotal();
    }
}

