/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import java.util.Optional;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberOfThreads {
    private static final Logger LOGGER = LoggerFactory.getLogger(NumberOfThreads.class);
    static final Double DEFAULT_BLOCKING_COEFFICIENT_FOR_IO = 0.8;
    private final EnvironmentVariables environmentVariables;
    private final double blockingCoefficientForIO;

    public static int forIOOperations() {
        return new NumberOfThreads().forIO();
    }

    protected NumberOfThreads() {
        this((EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    protected NumberOfThreads(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.blockingCoefficientForIO = Double.parseDouble(ThucydidesSystemProperty.IO_BLOCKING_COEFFICIENT.from(environmentVariables, DEFAULT_BLOCKING_COEFFICIENT_FOR_IO.toString()));
    }

    public int forIO() {
        int numberOfCores = Runtime.getRuntime().availableProcessors();
        int reportThreads = this.configuredReportThreads().orElse((int)((double)numberOfCores / (1.0 - this.blockingCoefficientForIO)));
        return reportThreads;
    }

    private Optional<Integer> configuredReportThreads() {
        int reportThreads = ThucydidesSystemProperty.REPORT_THREADS.integerFrom(this.environmentVariables);
        if (reportThreads == 0) {
            return Optional.empty();
        }
        return Optional.of(reportThreads);
    }
}

