/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.renderer;

import java.util.Optional;
import net.thucydides.core.reports.renderer.MarkupRenderer;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Attributes;
import org.asciidoctor.Options;

public class AsciidocMarkupRenderer
implements MarkupRenderer {
    Asciidoctor asciidoctor;

    private Asciidoctor getAsciidoctor() {
        if (this.asciidoctor == null) {
            this.asciidoctor = Asciidoctor.Factory.create();
        }
        return this.asciidoctor;
    }

    @Override
    public String render(String text) {
        String textToRender = Optional.ofNullable(text).orElse("");
        return Optional.ofNullable(this.getAsciidoctor().convert(this.addAsciidocLineBreaks(textToRender), this.getOptions())).orElse("");
    }

    public String addAsciidocLineBreaks(String text) {
        return text != null ? text.replaceAll("\r\n", " +\r\n").replaceAll("\n", " +\n") : "";
    }

    private Options getOptions() {
        return Options.builder().compact(true).docType("inline").attributes(Attributes.builder().experimental(true).dataUri(true).build()).build();
    }
}

