/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.classpath;

import com.google.common.io.Resources;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.thucydides.core.requirements.model.LoadedNarrative;
import net.thucydides.core.requirements.model.Narrative;
import org.apache.commons.lang3.StringUtils;

public class NarrativeTitle {
    private static final List<String> NARRATIVE_FILE_EXTENSIONS = Arrays.asList(".txt", ".md");

    public static String definedIn(String fullPath, String defaultType) {
        Optional<String> narrativePath = NarrativeTitle.narrativePathsFor(fullPath);
        try {
            Optional<Narrative> narrative;
            if (narrativePath.isPresent() && (narrative = LoadedNarrative.load().fromFile(new File(narrativePath.get()), defaultType)).isPresent()) {
                return (narrative.get().getTitle().orElse("") + System.lineSeparator() + narrative.get().getText()).trim();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return "";
    }

    static Optional<String> narrativePathsFor(String fullPath) {
        return NARRATIVE_FILE_EXTENSIONS.stream().map(extension -> NarrativeTitle.asResourcePath(NarrativeTitle.fileSystemPathOfNarrativeInPackage(fullPath)) + extension).map(NarrativeTitle::filePathFor).filter(filename -> !filename.isEmpty()).findFirst();
    }

    static String filePathFor(String narrativePath) {
        try {
            return Resources.getResource((String)narrativePath).getFile();
        }
        catch (IllegalArgumentException fileDoesNotExist) {
            return "";
        }
    }

    static String asResourcePath(String path) {
        return StringUtils.replace((String)path, (String)File.separator, (String)"/");
    }

    static String fileSystemPathOfNarrativeInPackage(String fullPath) {
        String narrativePath = fullPath + File.separator + "narrative";
        return StringUtils.replaceChars((String)narrativePath, (String)".", (String)File.separator);
    }
}

