/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.screenshots;

import java.io.File;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;

public class ScreenshotAndHtmlSource
implements Comparable<ScreenshotAndHtmlSource> {
    private final File screenshot;
    private final File htmlSource;
    private Long timeStamp;

    public ScreenshotAndHtmlSource(String screenshotName, String sourcecodeName) {
        this.screenshot = new File(screenshotName);
        this.htmlSource = sourcecodeName != null ? new File(sourcecodeName) : null;
        this.timeStamp = System.currentTimeMillis();
    }

    public ScreenshotAndHtmlSource(File screenshot, File sourcecode) {
        this.screenshot = screenshot;
        this.htmlSource = sourcecode;
        this.timeStamp = System.currentTimeMillis();
    }

    public String getScreenshotName() {
        return this.screenshot.getName();
    }

    public String getHtmlSourceName() {
        if (this.htmlSource == null) {
            return null;
        }
        return this.htmlSource.getName();
    }

    public ScreenshotAndHtmlSource(File screenshot) {
        this(screenshot, null);
    }

    public File getScreenshot() {
        return this.screenshot;
    }

    public Optional<File> getHtmlSource() {
        return Optional.ofNullable(this.htmlSource);
    }

    public boolean wasTaken() {
        return this.screenshot != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScreenshotAndHtmlSource that = (ScreenshotAndHtmlSource)o;
        return Objects.equals(this.screenshot, that.screenshot) && Objects.equals(this.htmlSource, that.htmlSource) && Objects.equals(this.timeStamp, that.timeStamp);
    }

    public int hashCode() {
        return Objects.hash(this.screenshot, this.htmlSource, this.timeStamp);
    }

    public Long getTimeStamp() {
        return this.timeStamp == null ? 0L : this.timeStamp;
    }

    public String toString() {
        return "Screenshot created at " + Instant.ofEpochMilli(this.timeStamp) + ": " + this.screenshot;
    }

    public boolean hasIdenticalScreenshotsAs(ScreenshotAndHtmlSource anotherScreenshotAndHtmlSource) {
        if (this.hasNoScreenshot() || anotherScreenshotAndHtmlSource.hasNoScreenshot()) {
            return false;
        }
        return this.getScreenshot().getName().equals(anotherScreenshotAndHtmlSource.getScreenshot().getName());
    }

    public File getScreenshotFile(File screenshotTargetDirectory) {
        return new File(screenshotTargetDirectory, this.getScreenshot().getName());
    }

    public boolean hasNoScreenshot() {
        return this.getScreenshot() == null;
    }

    @Override
    public int compareTo(ScreenshotAndHtmlSource otherScreenshot) {
        return this.getTimeStamp().compareTo(otherScreenshot.getTimeStamp());
    }
}

