/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.environment;

import com.google.common.base.Splitter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.serenitybdd.core.environment.UndefinedEnvironmentVariableException;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;

public class EnvironmentSpecificConfiguration {
    private EnvironmentVariables environmentVariables;
    private EnvironmentStrategy environmentStrategy;
    private static final String ENVIRONMENT_PREFIX = "environments\\.([^.]*)\\.";
    private final Pattern ENV_PREFIX_REGEX = Pattern.compile("environments\\.([^.]*)\\.");
    private Function<String, String> contextlessProperty = property -> this.environmentVariables.getProperty((String)property);
    private Function<String, String> defaultProperty = property -> {
        String candidateValue = this.propertyForAllEnvironments((String)property);
        if (candidateValue == null) {
            candidateValue = this.propertyForDefaultEnvironment((String)property);
        }
        if (candidateValue == null) {
            candidateValue = this.contextlessProperty.apply((String)property);
        }
        return this.substituteProperties(candidateValue);
    };
    private Function<String, String> propertyForADefinedEnvironment = property -> {
        String environmentProperty = null;
        for (String environment : this.activeEnvironments()) {
            environmentProperty = this.override(environmentProperty, this.environmentVariables.getProperty("environments." + environment + "." + property));
        }
        if (environmentProperty == null) {
            environmentProperty = this.propertyForAllEnvironments((String)property);
        }
        return environmentProperty == null ? this.defaultProperty.apply((String)property) : environmentProperty;
    };
    private final Pattern VARIABLE_EXPRESSION_PATTERN = Pattern.compile("#\\{([^}]*)\\}");
    private static final Map<EnvironmentVariables, EnvironmentSpecificConfiguration> ENVIRONMENT_SPECIFIC_CONFIGS = new HashMap<EnvironmentVariables, EnvironmentSpecificConfiguration>();

    public Properties getPropertiesWithPrefix(String prefix) {
        List<String> propertyNames = this.environmentVariables.getKeys().stream().filter(this::propertyMatchesEnvironment).filter(key -> this.propertyHasPrefix((String)key, prefix)).collect(Collectors.toList());
        Properties propertiesWithPrefix = new Properties();
        propertyNames.forEach(propertyName -> this.getOptionalProperty((String)propertyName).ifPresent(propertyValue -> propertiesWithPrefix.setProperty(this.stripEnvironmentPrefixFrom((String)propertyName), (String)propertyValue)));
        return propertiesWithPrefix;
    }

    private boolean propertyMatchesEnvironment(String key) {
        if (!this.isEnvironmentSpecific(key)) {
            return true;
        }
        return this.activeEnvironments().stream().anyMatch(environment -> key.startsWith("environments." + environment + "."));
    }

    private List<String> activeEnvironments() {
        return EnvironmentSpecificConfiguration.activeEnvironmentsIn(this.environmentVariables);
    }

    private static List<String> activeEnvironmentsIn(EnvironmentVariables environmentVariables) {
        return Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)environmentVariables.getProperty("environment", ""));
    }

    private boolean isEnvironmentSpecific(String key) {
        return this.ENV_PREFIX_REGEX.matcher(key).find();
    }

    private String stripEnvironmentPrefixFrom(String key) {
        return key.replaceFirst(ENVIRONMENT_PREFIX, "");
    }

    private boolean propertyHasPrefix(String key, String prefix) {
        String regexPrefix = prefix.replaceAll("\\.", "\\\\.");
        Pattern propertyWithPrefix = Pattern.compile(ENVIRONMENT_PREFIX + regexPrefix + "(.*)");
        return key.startsWith(prefix) || propertyWithPrefix.matcher(key).matches();
    }

    public static boolean areDefinedIn(EnvironmentVariables environmentVariables) {
        return !environmentVariables.getPropertiesWithPrefix("environments.").isEmpty();
    }

    private String override(String currentValue, String newValue) {
        if (newValue != null && !newValue.isEmpty()) {
            return newValue;
        }
        return currentValue;
    }

    private String propertyForAllEnvironments(String propertyName) {
        return this.environmentVariables.getProperty("environments.all." + propertyName);
    }

    private String propertyForDefaultEnvironment(String propertyName) {
        return this.environmentVariables.getProperty("environments.default." + propertyName);
    }

    public EnvironmentSpecificConfiguration(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.environmentStrategy = EnvironmentSpecificConfiguration.environmentStrategyDefinedIn(environmentVariables);
    }

    public String getProperty(String propertyName) {
        return this.getOptionalProperty(propertyName).orElseThrow(() -> new UndefinedEnvironmentVariableException("Environment '" + propertyName + "' property undefined for environment '" + EnvironmentSpecificConfiguration.activeEnvironmentsIn(this.environmentVariables) + "'"));
    }

    public Optional<String> getOptionalProperty(ThucydidesSystemProperty propertyName) {
        return this.getOptionalProperty(propertyName.getPropertyName(), propertyName.getLegacyPropertyName());
    }

    public String getProperty(ThucydidesSystemProperty propertyName) {
        return this.getOptionalProperty(propertyName).orElseThrow(() -> new UndefinedEnvironmentVariableException("Environment '" + (Object)((Object)propertyName) + "' property undefined for environment '" + EnvironmentSpecificConfiguration.activeEnvironmentsIn(this.environmentVariables) + "'"));
    }

    public Integer getIntegerProperty(ThucydidesSystemProperty propertyName) {
        return Integer.parseInt(this.getProperty(propertyName));
    }

    public boolean getBooleanProperty(ThucydidesSystemProperty propertyName) {
        return this.getBooleanProperty(propertyName, false);
    }

    public List<String> getListOfValues(ThucydidesSystemProperty propertyName) {
        return Arrays.stream(this.getOptionalProperty(propertyName).orElse("").split(",")).map(String::trim).collect(Collectors.toList());
    }

    public boolean getBooleanProperty(ThucydidesSystemProperty propertyName, boolean defaultValue) {
        String value = this.getOptionalProperty(propertyName).orElse(Boolean.toString(defaultValue));
        return Boolean.parseBoolean(value);
    }

    public Optional<String> getOptionalProperty(List<String> possiblePropertyNames) {
        String propertyName;
        String propertyValue = null;
        Iterator<String> iterator = possiblePropertyNames.iterator();
        while (iterator.hasNext() && (propertyValue = this.getPropertyValue(propertyName = iterator.next())) == null) {
        }
        if (propertyValue == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.substituteProperties(propertyValue));
    }

    public Optional<Integer> getOptionalInteger(List<String> possiblePropertyNames) {
        String propertyName;
        String propertyValue = null;
        Iterator<String> iterator = possiblePropertyNames.iterator();
        while (iterator.hasNext() && (propertyValue = this.getPropertyValue(propertyName = iterator.next())) == null) {
        }
        if (propertyValue == null) {
            return Optional.empty();
        }
        return Optional.of(Integer.parseInt(propertyValue));
    }

    public Optional<Integer> getOptionalInteger(String ... propertyNames) {
        return this.getOptionalInteger(Arrays.asList(propertyNames));
    }

    public Optional<String> getOptionalProperty(String ... propertyNames) {
        return this.getOptionalProperty(Arrays.asList(propertyNames));
    }

    public Optional<String> getOptionalProperty(ThucydidesSystemProperty ... properties) {
        ThucydidesSystemProperty property;
        String propertyValue = null;
        ThucydidesSystemProperty[] thucydidesSystemPropertyArray = properties;
        int n = thucydidesSystemPropertyArray.length;
        for (int i = 0; i < n && (propertyValue = this.getPropertyValue((property = thucydidesSystemPropertyArray[i]).getPropertyName())) == null; ++i) {
        }
        if (propertyValue == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.substituteProperties(propertyValue));
    }

    public boolean propertyGroupIsDefinedFor(String propertyGroupName) {
        return !this.getPropertiesWithPrefix(propertyGroupName).isEmpty();
    }

    private String substituteProperties(String propertyValue) {
        if (propertyValue == null) {
            return propertyValue;
        }
        Matcher matcher = this.VARIABLE_EXPRESSION_PATTERN.matcher(propertyValue);
        while (matcher.find()) {
            String nestedProperty = matcher.group().substring(2, matcher.group().length() - 1);
            String value = Optional.ofNullable(this.getPropertyValue(nestedProperty)).orElse(EnvironmentSpecificConfiguration.from(this.environmentVariables).getPropertyValue(nestedProperty));
            if (value == null) continue;
            propertyValue = matcher.replaceFirst(value);
            matcher.reset(propertyValue);
        }
        return propertyValue;
    }

    public String getPropertyValue(String propertyName) {
        switch (this.environmentStrategy) {
            case USE_NORMAL_PROPERTIES: 
            case ENVIRONMENT_CONFIGURED_BUT_NOT_NAMED: {
                return this.contextlessProperty.apply(propertyName);
            }
            case USE_DEFAULT_PROPERTIES: {
                return this.defaultProperty.apply(propertyName);
            }
            case ENVIRONMENT_CONFIGURED_AND_NAMED: {
                return this.propertyForADefinedEnvironment.apply(propertyName);
            }
        }
        return null;
    }

    public static EnvironmentSpecificConfiguration from(EnvironmentVariables environmentVariables) {
        if (!ENVIRONMENT_SPECIFIC_CONFIGS.containsKey(environmentVariables)) {
            ENVIRONMENT_SPECIFIC_CONFIGS.put(environmentVariables, new EnvironmentSpecificConfiguration(environmentVariables));
        }
        return ENVIRONMENT_SPECIFIC_CONFIGS.get(environmentVariables);
    }

    private static EnvironmentStrategy environmentStrategyDefinedIn(EnvironmentVariables environmentVariables) {
        boolean defaultEnvironmentsAreConfigured;
        boolean environmentsAreConfigured = !environmentVariables.getPropertiesWithPrefix("environments.").isEmpty();
        boolean environmentIsSpecified = environmentVariables.getProperty("environment") != null;
        boolean bl = defaultEnvironmentsAreConfigured = !environmentVariables.getPropertiesWithPrefix("environments.default.").isEmpty();
        if (!environmentsAreConfigured) {
            return EnvironmentStrategy.USE_NORMAL_PROPERTIES;
        }
        if (EnvironmentSpecificConfiguration.specifiedEnvironmentNotConfiguredIn(environmentVariables)) {
            return EnvironmentStrategy.USE_DEFAULT_PROPERTIES;
        }
        if (defaultEnvironmentsAreConfigured && !environmentIsSpecified) {
            return EnvironmentStrategy.USE_DEFAULT_PROPERTIES;
        }
        if (!environmentIsSpecified) {
            return EnvironmentStrategy.ENVIRONMENT_CONFIGURED_BUT_NOT_NAMED;
        }
        return EnvironmentStrategy.ENVIRONMENT_CONFIGURED_AND_NAMED;
    }

    private static boolean specifiedEnvironmentNotConfiguredIn(EnvironmentVariables environmentVariables) {
        List<String> activeEnvironments = EnvironmentSpecificConfiguration.activeEnvironmentsIn(environmentVariables);
        return activeEnvironments.stream().allMatch(environment -> environmentVariables.getPropertiesWithPrefix("environments." + environment + ".").isEmpty());
    }

    static enum EnvironmentStrategy {
        USE_NORMAL_PROPERTIES,
        USE_DEFAULT_PROPERTIES,
        ENVIRONMENT_CONFIGURED_AND_NAMED,
        ENVIRONMENT_CONFIGURED_BUT_NOT_NAMED,
        USE_DEFAULT_CONFIGURATION,
        NO_ENVIRONMENT_DEFINED;

    }
}

