/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.matchers;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.thucydides.core.matchers.BeanCollectionMatcher;
import net.thucydides.core.matchers.dates.BeanFields;

class BeanUniquenessMatcher
implements BeanCollectionMatcher {
    private final String fieldName;

    public BeanUniquenessMatcher(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public boolean matches(Object target) {
        return this.matches((Collection)target);
    }

    @Override
    public <T> boolean matches(Collection<T> elements) {
        List allFieldValues = elements.stream().map(element -> BeanFields.fieldValueIn(element).forField(this.fieldName)).collect(Collectors.toList());
        HashSet uniquefieldValues = new HashSet();
        uniquefieldValues.addAll(allFieldValues);
        return uniquefieldValues.size() == elements.size();
    }

    public String toString() {
        return "each " + this.fieldName + " is different";
    }
}

