/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.templates;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.Version;
import java.util.Locale;
import net.thucydides.core.reports.templates.FreemarkerReportTemplate;
import net.thucydides.core.reports.templates.ReportTemplate;

public class FreeMarkerTemplateManager {
    public static final Version FREEMARKER_VERSION = new Version(2, 3, 23);
    private Configuration configuration = new Configuration(FREEMARKER_VERSION);

    FreeMarkerTemplateManager() {
        this.configuration.setNumberFormat("0.######");
        this.configuration.setLocale(Locale.UK);
        this.configuration.setClassForTemplateLoading(this.getClass(), "/");
        this.configuration.setTemplateUpdateDelayMilliseconds(3600000L);
        this.configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapperBuilder(FREEMARKER_VERSION).build());
    }

    public ReportTemplate getTemplateFrom(String template) throws Exception {
        return new FreemarkerReportTemplate(this.configuration, template);
    }
}

