/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.files;

import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TheDirectoryStructure {
    private final Path rootDirectory;
    private static final Logger LOGGER = LoggerFactory.getLogger(TheDirectoryStructure.class);
    private static final Pattern FILE_PATH_SEPARATORS = Pattern.compile("\\/");

    public TheDirectoryStructure(File rootDirectory) {
        this.rootDirectory = Paths.get(rootDirectory.getPath().replace("\\", "/"), new String[0]);
    }

    public static TheDirectoryStructure startingAt(File rootDirectory) {
        return new TheDirectoryStructure(rootDirectory);
    }

    public boolean containsFiles(FileFilter ... fileFilters) {
        for (File file : this.nestedFilesIn(this.rootDirectory.toFile())) {
            for (FileFilter fileFilter : fileFilters) {
                if (!fileFilter.accept(file)) continue;
                return true;
            }
        }
        return false;
    }

    private List<File> nestedFilesIn(File directory) {
        if (!directory.isDirectory()) {
            return new ArrayList<File>();
        }
        ArrayList<File> nestedFiles = new ArrayList<File>();
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                nestedFiles.addAll(this.nestedFilesIn(file));
                continue;
            }
            nestedFiles.add(file);
        }
        return nestedFiles;
    }

    public int maxDepth() {
        LOGGER.trace("Calculating maximum directory depth for requirements hierarchy at: {} ({})", (Object)this.rootDirectory, (Object)this.rootDirectory.toFile().getAbsolutePath());
        if (!this.rootDirectory.toFile().isDirectory()) {
            return 0;
        }
        Collection directoryContents = FileUtils.listFilesAndDirs((File)this.rootDirectory.toFile(), (IOFileFilter)new NotFileFilter(TrueFileFilter.INSTANCE), (IOFileFilter)this.normalDirectoriesOnly());
        int maxDepth = directoryContents.stream().map(fileInDirectory -> this.rootDirectory.relativize(fileInDirectory.toPath())).mapToInt(this::numberOfElementsIn).max().orElse(0);
        LOGGER.trace("Max depth = {}", (Object)maxDepth);
        return maxDepth;
    }

    private int numberOfElementsIn(Path relativePath) {
        return relativePath.toString().split(Pattern.quote(File.separator)).length;
    }

    private IOFileFilter normalDirectoriesOnly() {
        return new IOFileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() && !file.getName().startsWith(".");
            }

            public boolean accept(File dir, String name) {
                return new File(dir, name).isDirectory() && !name.startsWith(".");
            }
        };
    }
}

