/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DescriptionSplitter {
    private final List<String> lines;
    private static final Pattern DATA_TABLE_LINE = Pattern.compile("\\|.*\\|");

    private DescriptionSplitter(String text) {
        this.lines = Arrays.asList(text.split("\\r?\\n"));
    }

    public static List<String> splitIntoSteps(String statement) {
        return new DescriptionSplitter(statement).split();
    }

    private List<String> split() {
        ArrayList<String> blocks = new ArrayList<String>();
        TableBuffer currentTable = new TableBuffer();
        for (String line : this.lines) {
            if (!this.isDataTableLine(line)) {
                currentTable.appendToPreviousLine(blocks);
                blocks.add(line);
                continue;
            }
            currentTable.add(line);
        }
        currentTable.appendToPreviousLine(blocks);
        return blocks;
    }

    private boolean isDataTableLine(String line) {
        return DATA_TABLE_LINE.matcher(line).matches();
    }

    private static class TableBuffer {
        private List<String> tableContents = new ArrayList<String>();

        private TableBuffer() {
        }

        public void add(String line) {
            this.tableContents.add(line);
        }

        public String asString() {
            return this.tableContents.stream().collect(Collectors.joining(System.lineSeparator()));
        }

        public void appendToPreviousLine(List<String> lines) {
            if (!this.tableContents.isEmpty()) {
                lines.set(lines.size() - 1, lines.get(lines.size() - 1) + System.lineSeparator() + this.asString());
            }
            this.tableContents.clear();
        }
    }
}

