/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.configuration;

import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import net.serenitybdd.model.environment.EnvironmentSpecificConfiguration;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.configuration.FilePathParser;
import net.thucydides.model.configuration.MavenOrGradleBuildPath;
import net.thucydides.model.domain.TakeScreenshots;
import net.thucydides.model.util.EnvironmentVariables;
import net.thucydides.model.webdriver.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class SystemPropertiesConfiguration
implements Configuration {
    public static final String PROJECT_BUILD_DIRECTORY = "project.build.directory";
    protected File outputDirectory;
    protected File sourceDirectory;
    private File historyDirectory;
    protected String defaultBaseUrl;
    protected EnvironmentVariables environmentVariables;
    private final FilePathParser filePathParser;
    private Path projectDirectory;

    public SystemPropertiesConfiguration(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.filePathParser = new FilePathParser(environmentVariables);
    }

    public SystemPropertiesConfiguration withEnvironmentVariables(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    @Override
    public EnvironmentVariables getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public File loadOutputDirectoryFromSystemProperties() {
        String systemDefinedDirectory = MavenOrGradleBuildPath.specifiedIn(this.environmentVariables).getBuildDirectory();
        systemDefinedDirectory = this.filePathParser.getInstanciatedPath(systemDefinedDirectory);
        File newOutputDirectory = new File(systemDefinedDirectory);
        newOutputDirectory.mkdirs();
        return newOutputDirectory;
    }

    public File loadHistoryDirectoryFromSystemProperties() {
        String systemDefinedDirectory = MavenOrGradleBuildPath.specifiedIn(this.environmentVariables).getHistoryDirectory();
        systemDefinedDirectory = this.filePathParser.getInstanciatedPath(systemDefinedDirectory);
        File newOutputDirectory = new File(systemDefinedDirectory);
        newOutputDirectory.mkdirs();
        return newOutputDirectory;
    }

    public void reloadOutputDirectory() {
        this.setOutputDirectory(this.loadOutputDirectoryFromSystemProperties());
    }

    @Override
    public int getStepDelay() {
        int stepDelay = 0;
        String stepDelayValue = this.propertyNamed(ThucydidesSystemProperty.SERENITY_STEP_DELAY);
        if (stepDelayValue != null && !stepDelayValue.isEmpty()) {
            stepDelay = Integer.parseInt(stepDelayValue);
        }
        return stepDelay;
    }

    @Override
    public int getElementTimeoutInSeconds() {
        Optional<Long> implicitTimeoutInMilliseconds = this.webdriverCapabilitiesImplicitTimeoutFrom(this.environmentVariables);
        return implicitTimeoutInMilliseconds.map(integer -> integer / 1000L).orElse(2L).intValue();
    }

    private Optional<Long> webdriverCapabilitiesImplicitTimeoutFrom(EnvironmentVariables environmentVariables) {
        return EnvironmentSpecificConfiguration.from(environmentVariables).getOptionalProperty("webdriver.capabilities.timeouts.implicit", "webdriver.timeouts.implicitlywait").map(Long::parseLong);
    }

    private Optional<Integer> integerValueOf(String value) {
        if (value != null && !value.isEmpty()) {
            return Optional.of(Integer.parseInt(value));
        }
        return Optional.empty();
    }

    @Override
    @Deprecated
    public boolean getUseUniqueBrowser() {
        return this.shouldUseAUniqueBrowser();
    }

    @Override
    @Deprecated
    public boolean shouldUseAUniqueBrowser() {
        return ThucydidesSystemProperty.THUCYDIDES_USE_UNIQUE_BROWSER.booleanFrom(this.getEnvironmentVariables());
    }

    @Override
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    @Override
    public void setProjectDirectory(Path projectDirectory) {
        this.projectDirectory = projectDirectory;
    }

    @Override
    public Path getProjectDirectory() {
        return this.projectDirectory;
    }

    @Override
    public File getOutputDirectory() {
        if (this.outputDirectory == null) {
            this.outputDirectory = this.findOutputDirectory();
        }
        return this.outputDirectory;
    }

    @Nullable
    private File findOutputDirectory() {
        String workingDirectory;
        String serenityOutputDirectory = this.environmentVariables.optionalProperty("serenity.outputDirectory").orElse(null);
        String projectReportingOutputDirectory = this.environmentVariables.optionalProperty("project.reporting.OutputDirectory").orElse(null);
        String projectBuildDirectory = this.environmentVariables.optionalProperty(PROJECT_BUILD_DIRECTORY).orElse(null);
        String string = workingDirectory = this.projectDirectory == null ? this.environmentVariables.getProperty("user.dir") : this.projectDirectory.toAbsolutePath().toString();
        if (serenityOutputDirectory != null && new File(serenityOutputDirectory).isAbsolute()) {
            return new File(serenityOutputDirectory);
        }
        if (StringUtils.isNotEmpty((CharSequence)serenityOutputDirectory)) {
            String baseDir = Optional.ofNullable(projectBuildDirectory).map(dir -> dir + "/").orElse(Optional.ofNullable(projectReportingOutputDirectory).map(dir -> dir + "/").orElse(""));
            return new File(baseDir + serenityOutputDirectory);
        }
        if (StringUtils.isNotEmpty((CharSequence)projectReportingOutputDirectory)) {
            return new File(projectReportingOutputDirectory + "/serenity");
        }
        if (StringUtils.isNotEmpty((CharSequence)projectBuildDirectory)) {
            return new File(projectBuildDirectory + "/target/site/serenity");
        }
        if (StringUtils.isNotEmpty((CharSequence)workingDirectory)) {
            return new File(workingDirectory + "/target/site/serenity");
        }
        return new File("target/site/serenity");
    }

    public File getSourceDirectory() {
        if (this.sourceDirectory == null) {
            this.sourceDirectory = new File(ThucydidesSystemProperty.SERENITY_OUTPUT_DIRECTORY.optionalFrom(this.environmentVariables).orElse("target/site/serenity"));
        }
        return this.sourceDirectory;
    }

    @Override
    public File getHistoryDirectory() {
        if (this.historyDirectory == null) {
            this.historyDirectory = this.loadHistoryDirectoryFromSystemProperties();
        }
        return this.historyDirectory;
    }

    @Override
    public double getEstimatedAverageStepCount() {
        return this.integerPropertyNamed(ThucydidesSystemProperty.SERENITY_ESTIMATED_AVERAGE_STEP_COUNT, 1).intValue();
    }

    @Override
    public boolean onlySaveFailingScreenshots() {
        return Boolean.parseBoolean(this.propertyNamed(ThucydidesSystemProperty.THUCYDIDES_ONLY_SAVE_FAILING_SCREENSHOTS, "false"));
    }

    @Override
    public boolean takeVerboseScreenshots() {
        return Boolean.parseBoolean(this.propertyNamed(ThucydidesSystemProperty.THUCYDIDES_VERBOSE_SCREENSHOTS, "false"));
    }

    @Override
    public Optional<TakeScreenshots> getScreenshotLevel() {
        String takeScreenshotsLevel = this.propertyNamed(ThucydidesSystemProperty.SERENITY_TAKE_SCREENSHOTS);
        if (StringUtils.isNotEmpty((CharSequence)takeScreenshotsLevel)) {
            return Optional.of(TakeScreenshots.valueOf(takeScreenshotsLevel.toUpperCase()));
        }
        return Optional.empty();
    }

    @Override
    public void setIfUndefined(String property, String value) {
        if (this.getEnvironmentVariables().getProperty(property) == null) {
            this.getEnvironmentVariables().setProperty(property, value);
        }
    }

    @Override
    public void setDefaultBaseUrl(String defaultBaseUrl) {
        this.defaultBaseUrl = defaultBaseUrl;
    }

    @Override
    public int getRestartFrequency() {
        return ThucydidesSystemProperty.SERENITY_RESTART_BROWSER_FREQUENCY.integerFrom(this.environmentVariables);
    }

    @Override
    public int getCurrentTestCount() {
        return 0;
    }

    @Override
    public String getBaseUrl() {
        return this.propertyNamed(ThucydidesSystemProperty.WEBDRIVER_BASE_URL, this.defaultBaseUrl);
    }

    private String propertyNamed(ThucydidesSystemProperty property, String defaultValue) {
        return EnvironmentSpecificConfiguration.from(this.environmentVariables).getOptionalProperty(property.getPropertyName(), property.getLegacyPropertyName()).orElse(defaultValue);
    }

    private Optional<Integer> integerPropertyNamed(ThucydidesSystemProperty property) {
        return EnvironmentSpecificConfiguration.from(this.environmentVariables).getOptionalInteger(property.getPropertyName(), property.getLegacyPropertyName());
    }

    private Integer integerPropertyNamed(ThucydidesSystemProperty property, int defaultValue) {
        return this.integerPropertyNamed(property).orElse(defaultValue);
    }

    private String propertyNamed(ThucydidesSystemProperty propertyName) {
        return this.propertyNamed(propertyName, null);
    }
}

