/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.reports;

import com.google.common.base.Splitter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.thucydides.model.domain.TestResult;
import net.thucydides.model.domain.TestTag;
import net.thucydides.model.domain.TestType;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.reports.AsciiColors;
import net.thucydides.model.reports.OutcomeFormat;
import net.thucydides.model.reports.TestOutcomeLoader;
import net.thucydides.model.reports.TestOutcomes;
import net.thucydides.model.requirements.reports.CompoundDuration;
import net.thucydides.model.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultChecker {
    private static final String WITH_NO_TAGS = "";
    private final File outputDirectory;
    private final List<TestTag> tags;
    private final AsciiColors asciiColors;
    private static final Logger logger = LoggerFactory.getLogger(ResultChecker.class);
    private static final int COLUMN_WIDTH = 30;

    public ResultChecker(File outputDirectory) {
        this(outputDirectory, WITH_NO_TAGS);
    }

    public ResultChecker(File outputDirectory, String tags) {
        this(outputDirectory, tags, SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    public ResultChecker(File outputDirectory, String tags, EnvironmentVariables environmentVariables) {
        this.outputDirectory = outputDirectory;
        this.tags = this.tagsFrom(tags);
        this.asciiColors = new AsciiColors(environmentVariables);
    }

    private List<TestTag> tagsFrom(String tags) {
        List tagValues = Splitter.on((String)",").trimResults().splitToList((CharSequence)tags);
        return tagValues.stream().map(TestTag::withValue).collect(Collectors.toList());
    }

    public TestResult checkTestResults(TestOutcomes outcomes) {
        if (outcomes != null && !outcomes.isEmpty()) {
            this.logOutcomesFrom(outcomes);
            return outcomes.getResult();
        }
        return TestResult.UNDEFINED;
    }

    public TestResult checkTestResults() {
        Optional<TestOutcomes> outcomes = this.loadOutcomes();
        if (outcomes.isPresent()) {
            return this.checkTestResults(outcomes.get());
        }
        return TestResult.UNDEFINED;
    }

    private void logOutcomesFrom(TestOutcomes testOutcomes) {
        logger.info(this.white("------------------------------------------------", 0));
        logger.info(this.white("| SERENITY TESTS: ", 30) + "  | " + this.colored(testOutcomes.getResult(), testOutcomes.getResult().toString()));
        logger.info(this.white("------------------------------------------------", 0));
        logger.info(this.resultLine(this.white("Test scenarios executed", 30), this.white(Long.toString(testOutcomes.getScenarioCount()), 0)));
        logger.info(this.resultLine(this.white("Total Test cases executed", 30), this.white(Long.toString(testOutcomes.getTestCaseCount()), 0)));
        if (testOutcomes.ofType(TestType.MANUAL).getTestCaseCount() > 0L) {
            logger.info(this.resultLine(this.white("Automated Test cases executed", 30), this.white(Long.toString(testOutcomes.ofType(TestType.AUTOMATED).getTestCaseCount()), 0)));
            logger.info(this.resultLine(this.white("Manual Test cases executed", 30), this.white(Long.toString(testOutcomes.ofType(TestType.MANUAL).getTestCaseCount()), 0)));
        }
        logger.info(this.resultLine(this.green("Tests passed", 30), this.green(Integer.toString(testOutcomes.count(TestType.ANY).withResult(TestResult.SUCCESS)), 0)));
        logger.info(this.resultLine(this.red("Tests failed", 30), this.red(Integer.toString(testOutcomes.count(TestType.ANY).withResult(TestResult.FAILURE)), 0)));
        logger.info(this.resultLine(this.yellow("Tests with errors", 30), this.yellow(Integer.toString(testOutcomes.count(TestType.ANY).withResult(TestResult.ERROR)), 0)));
        logger.info(this.resultLine(this.purple("Tests compromised", 30), this.purple(Integer.toString(testOutcomes.count(TestType.ANY).withResult(TestResult.COMPROMISED)), 0)));
        logger.info(this.resultLine(this.purple("Tests aborted", 30), this.purple(Integer.toString(testOutcomes.count(TestType.ANY).withResult(TestResult.ABORTED)), 0)));
        logger.info(this.resultLine(this.cyan("Tests pending", 30), this.cyan(Integer.toString(testOutcomes.count(TestType.ANY).withResult(TestResult.PENDING)), 0)));
        logger.info(this.resultLine(this.grey("Tests ignored/skipped", 30), this.grey(Integer.toString(testOutcomes.count(TestType.ANY).withResult(TestResult.IGNORED) + testOutcomes.count(TestType.ANY).withResult(TestResult.SKIPPED)), 0)));
        logger.info("------------------------------- | --------------");
        logger.info(this.resultLine("Total Duration", CompoundDuration.of(testOutcomes.getDuration())));
        logger.info(this.resultLine("Fastest test took", CompoundDuration.of(testOutcomes.getFastestTestDuration())));
        logger.info(this.resultLine("Slowest test took", CompoundDuration.of(testOutcomes.getSlowestTestDuration())));
        logger.info("------------------------------------------------");
        logger.info(WITH_NO_TAGS);
        Path index = this.outputDirectory.toPath().resolve("index.html");
        logger.info(this.white("SERENITY REPORTS", 0));
        logger.info("  - Full Report: " + String.valueOf(index.toUri()));
    }

    private String resultLine(String label, String value) {
        return "| " + label + "| " + value;
    }

    private String colored(TestResult result, String text) {
        switch (result) {
            case SUCCESS: {
                return this.green(text, 0);
            }
            case FAILURE: {
                return this.red(text, 0);
            }
            case ERROR: {
                return this.yellow(text, 0);
            }
            case PENDING: {
                return this.cyan(text, 0);
            }
        }
        return text;
    }

    private String red(String text, int width) {
        return this.asciiColors.bold().red(StringUtils.rightPad((String)text, (int)width));
    }

    private String green(String text, int width) {
        return this.asciiColors.bold().green(StringUtils.rightPad((String)text, (int)width));
    }

    private String cyan(String text, int width) {
        return this.asciiColors.bold().cyan(StringUtils.rightPad((String)text, (int)width));
    }

    private String grey(String text, int width) {
        return this.asciiColors.bold().grey(StringUtils.rightPad((String)text, (int)width));
    }

    private String yellow(String text, int width) {
        return this.asciiColors.bold().yellow(StringUtils.rightPad((String)text, (int)width));
    }

    private String purple(String text, int width) {
        return this.asciiColors.bold().magenta(StringUtils.rightPad((String)text, (int)width));
    }

    private String white(String text, int width) {
        return this.asciiColors.bold().white(StringUtils.rightPad((String)text, (int)width));
    }

    private Optional<TestOutcomes> loadOutcomes() {
        TestOutcomes outcomes = null;
        try {
            outcomes = TestOutcomeLoader.loadTestOutcomes().inFormat(OutcomeFormat.JSON).from(this.outputDirectory).filteredByEnvironmentTags();
            if (this.thereAreTagsIn(this.tags)) {
                outcomes = outcomes.withTags(this.tags);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Optional.ofNullable(outcomes);
    }

    private boolean thereAreTagsIn(List<TestTag> tags) {
        return !tags.isEmpty() && !StringUtils.isBlank((CharSequence)tags.get(0).getName());
    }
}

