/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.thucydides.model.requirements.PathStartsWith;

public class RequirementsPath {
    private static final Pattern PATH_SEPARATORS = Pattern.compile("[\\\\/.]");
    private static final Pattern FILE_SYSTEM_PATH_SEPARATORS = Pattern.compile("[\\\\/]");

    public static List<String> stripRootFromPath(String root, List<String> storyPathElements) {
        List<String> rootElements = RequirementsPath.pathElements(root);
        if (RequirementsPath.thePathIn(storyPathElements).startsWith(rootElements)) {
            return storyPathElements.subList(rootElements.size(), storyPathElements.size());
        }
        return storyPathElements;
    }

    private static PathStartsWith thePathIn(List<String> storyPathElements) {
        return new PathStartsWith(storyPathElements);
    }

    public static List<String> pathElements(String path) {
        if (path == null) {
            return new ArrayList<String>();
        }
        return Splitter.on((Pattern)PATH_SEPARATORS).omitEmptyStrings().trimResults().splitToList((CharSequence)path);
    }

    public static List<String> fileSystemPathElements(String path) {
        if (path == null) {
            return new ArrayList<String>();
        }
        return Splitter.on((Pattern)FILE_SYSTEM_PATH_SEPARATORS).omitEmptyStrings().trimResults().splitToList((CharSequence)path);
    }
}

