/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.reports.html;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.thucydides.model.domain.TestResult;
import net.thucydides.model.domain.TestType;
import net.thucydides.model.reports.TestOutcomes;

public class ResultCounts {
    private TestOutcomes testOutcomes;
    private final Map<TestResult, Long> automatedTests = new HashMap<TestResult, Long>();
    private final Map<TestResult, Long> manualTests = new HashMap<TestResult, Long>();
    private final Map<TestResult, Long> totalTests = new HashMap<TestResult, Long>();
    private final long totalAutomatedTests;
    private final long totalManualTests;
    private final long totalTestCount;

    public ResultCounts(TestOutcomes testOutcomes) {
        this.testOutcomes = testOutcomes;
        for (TestResult result : TestResult.values()) {
            this.automatedTests.put(result, testOutcomes.countWithResult(TestType.AUTOMATED, result));
            this.manualTests.put(result, testOutcomes.countWithResult(TestType.MANUAL, result));
            this.totalTests.put(result, this.automatedTests.get((Object)result) + this.manualTests.get((Object)result));
        }
        this.totalAutomatedTests = testOutcomes.countWithType(TestType.AUTOMATED);
        this.totalManualTests = testOutcomes.countWithType(TestType.MANUAL);
        this.totalTestCount = testOutcomes.getTotal();
    }

    public boolean hasManualTests() {
        return this.manualTests.values().stream().anyMatch(value -> value > 0L);
    }

    public Long getAutomatedTestCount(String result) {
        return this.automatedTests.getOrDefault((Object)TestResult.valueOf(result.toUpperCase()), 0L);
    }

    public Long getManualTestCount(String result) {
        return this.manualTests.getOrDefault((Object)TestResult.valueOf(result.toUpperCase()), 0L);
    }

    public Long getOverallTestCount(String result) {
        return this.totalTests.getOrDefault((Object)TestResult.valueOf(result.toUpperCase()), 0L);
    }

    public Integer getOverallTestsCount(String ... results) {
        int allTestsCount = 0;
        for (String result : results) {
            allTestsCount = (int)((long)allTestsCount + this.getOverallTestCount(result));
        }
        return allTestsCount;
    }

    public Long getTotalAutomatedTestCount() {
        return this.totalAutomatedTests;
    }

    public Long getTotalManualTestCount() {
        return this.totalManualTests;
    }

    public Long getTotalOverallTestCount() {
        return this.totalTestCount;
    }

    public String getAutomatedTestPercentageLabel(String result) {
        return this.percentageLabelFor(this.getAutomatedTestPercentage(result).intValue());
    }

    public String getManualTestPercentageLabel(String result) {
        return this.percentageLabelFor(this.getManualTestPercentage(result).intValue());
    }

    public String getOverallTestPercentageLabel(String result) {
        return this.percentageLabelFor(this.getOverallTestPercentage(result).intValue());
    }

    public Integer getAutomatedTestPercentage(String result) {
        return (int)Math.round((double)this.getAutomatedTestCount(result).longValue() * 100.0 / (double)this.totalTestCount);
    }

    public Integer getManualTestPercentage(String result) {
        return (int)Math.round((double)this.getManualTestCount(result).longValue() * 100.0 / (double)this.totalTestCount);
    }

    public Integer getOverallTestPercentage(String result) {
        return (int)Math.round((double)this.getOverallTestCount(result).longValue() * 100.0 / (double)this.totalTestCount);
    }

    public Double getPreciseTestPercentage(String result) {
        return (double)this.getOverallTestCount(result).longValue() * 100.0 / (double)this.totalTestCount;
    }

    public static ResultCounts forOutcomesIn(TestOutcomes testOutcomes) {
        return new ResultCounts(testOutcomes);
    }

    public String byTypeFor(String ... testResultTypes) {
        ArrayList<String> resultCounts = new ArrayList<String>();
        for (String resultType : testResultTypes) {
            resultCounts.add(this.labeledValue(resultType, TestType.ANY));
        }
        return Arrays.toString(resultCounts.toArray());
    }

    public String allResultValuesFor(String ... testResultTypes) {
        return "[" + Arrays.stream(testResultTypes).map(this::getOverallTestCount).map(value -> Long.toString(value)).collect(Collectors.joining(",")) + "]";
    }

    public String automatedResultValuesFor(String ... testResultTypes) {
        return "[" + Arrays.stream(testResultTypes).map(this::getAutomatedTestCount).map(value -> Long.toString(value)).collect(Collectors.joining(",")) + "]";
    }

    public String manualResultValuesFor(String ... testResultTypes) {
        return "[" + Arrays.stream(testResultTypes).map(this::getManualTestCount).map(value -> Long.toString(value)).collect(Collectors.joining(",")) + "]";
    }

    private String labeledValue(String resultType, TestType testType) {
        long resultCount = testType == TestType.AUTOMATED ? this.getAutomatedTestCount(resultType) : (testType == TestType.MANUAL ? this.getManualTestCount(resultType).longValue() : this.getOverallTestCount(resultType).longValue());
        Object label = TestResult.valueOf(resultType.toUpperCase()).getLabel();
        if (testType != TestType.ANY) {
            label = (String)label + " (" + testType.toString().toLowerCase() + ")";
        }
        return "{meta: '" + (String)label + "', value: " + resultCount + "}";
    }

    public String percentageLabelsByTypeFor(String ... testResultTypes) {
        ArrayList<CallSite> resultLabels = new ArrayList<CallSite>();
        long totalTestCount = this.testOutcomes.getTestCaseCount();
        for (String resultType : testResultTypes) {
            double percentageAutomated = (double)this.automatedTests.get((Object)TestResult.valueOf(resultType.toUpperCase())).longValue() * 100.0 / (double)totalTestCount;
            double percentageManual = (double)this.manualTests.get((Object)TestResult.valueOf(resultType.toUpperCase())).longValue() * 100.0 / (double)totalTestCount;
            resultLabels.add((CallSite)((Object)("'" + this.percentageLabelFor(percentageAutomated) + "'")));
            resultLabels.add((CallSite)((Object)("'" + this.percentageLabelFor(percentageManual) + "'")));
        }
        return Arrays.toString(resultLabels.toArray());
    }

    private String percentageLabelFor(double value) {
        return value > 0.0 ? Math.round(value) + "%" : " ";
    }
}

