/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.environment;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import net.thucydides.model.environment.TestLocalEnvironmentVariables;
import net.thucydides.model.util.EnvironmentVariables;
import net.thucydides.model.util.PropertiesLocalPreferences;
import org.apache.commons.lang3.StringUtils;

public class SystemEnvironmentVariables
implements EnvironmentVariables {
    private final Map<String, String> properties = new ConcurrentHashMap<String, String>();
    private final Map<String, String> systemValues = new ConcurrentHashMap<String, String>();
    private volatile Config config;
    private volatile boolean configLoaded = false;
    private static EnvironmentVariables CACHED_ENVIRONMENT_VARIABLES;
    private static final Lock lock;
    private final Lock propertySetLock = new ReentrantLock();

    private static EnvironmentVariables getCachedEnvironmentVariables() {
        if (CACHED_ENVIRONMENT_VARIABLES == null) {
            lock.lock();
            try {
                if (CACHED_ENVIRONMENT_VARIABLES == null) {
                    CACHED_ENVIRONMENT_VARIABLES = SystemEnvironmentVariables.createEnvironmentVariables().loadLocalConfig();
                }
            }
            finally {
                lock.unlock();
            }
        }
        return CACHED_ENVIRONMENT_VARIABLES;
    }

    private SystemEnvironmentVariables(Map<String, String> properties, Map<String, String> systemValues, Config config) {
        this.properties.putAll(properties);
        this.systemValues.putAll(systemValues);
        this.config = config;
        this.loadLocalConfig();
    }

    private void clearConfig() {
        this.config = null;
        this.configLoaded = false;
    }

    @Override
    public EnvironmentVariables copy() {
        return new SystemEnvironmentVariables(this.properties, this.systemValues, this.config);
    }

    public SystemEnvironmentVariables() {
        this(System.getProperties(), System.getenv());
    }

    public static EnvironmentUpdater currentEnvironment() {
        return new EnvironmentUpdater(SystemEnvironmentVariables.getCachedEnvironmentVariables());
    }

    public static EnvironmentVariables currentEnvironmentVariables() {
        if (TestLocalEnvironmentVariables.isEmpty()) {
            return SystemEnvironmentVariables.getCachedEnvironmentVariables();
        }
        return TestLocalEnvironmentVariables.getUpdatedEnvironmentVariables();
    }

    @Override
    public void setConfig(Config typesafeConfig) {
        this.config = typesafeConfig.resolve();
    }

    public SystemEnvironmentVariables(Map<String, String> propertyValues, Map<String, String> systemValues) {
        this.systemValues.putAll(systemValues);
        this.properties.putAll(propertyValues);
        this.loadLocalConfig();
    }

    public SystemEnvironmentVariables(Properties systemProperties, Map<String, String> systemValues) {
        this.systemValues.putAll(systemValues);
        HashMap<String, String> propertyValues = new HashMap<String, String>();
        for (String property : systemProperties.stringPropertyNames()) {
            String value = systemProperties.getProperty(property);
            propertyValues.put(property, value);
        }
        this.properties.putAll(propertyValues);
        this.loadLocalConfig();
    }

    @Override
    public String getValue(String name) {
        return this.getValue(name, null);
    }

    @Override
    public String getValue(Enum<?> property) {
        return this.getValue(property.toString());
    }

    @Override
    public String getValue(String name, String defaultValue) {
        String value = this.systemValues.get(name);
        return value == null ? defaultValue : value;
    }

    private void setValue(String name, String value) {
        this.systemValues.put(name, value);
    }

    @Override
    public String getValue(Enum<?> property, String defaultValue) {
        return this.getValue(property.toString(), defaultValue);
    }

    @Override
    public List<String> getKeys() {
        return this.properties.keySet().stream().map(Object::toString).collect(Collectors.toList());
    }

    @Override
    public Properties getProperties() {
        Properties props = new Properties();
        for (String key : this.properties.keySet()) {
            props.setProperty(key, this.properties.get(key));
        }
        return props;
    }

    @Override
    public Properties getPropertiesWithPrefix(String prefix) {
        Properties filteredProperties = new Properties();
        for (String key : this.properties.keySet()) {
            if (!key.startsWith(prefix)) continue;
            filteredProperties.put(key, this.properties.get(key));
        }
        return filteredProperties;
    }

    @Override
    public boolean aValueIsDefinedFor(Enum<?> property) {
        return this.aValueIsDefinedFor(property.toString());
    }

    @Override
    public boolean aValueIsDefinedFor(String property) {
        return this.properties.containsKey(property);
    }

    @Override
    public boolean hasPath(String path) {
        return this.config != null && this.config.hasPath(path);
    }

    @Override
    public String injectSystemPropertiesInto(String value) {
        if (value == null) {
            return value;
        }
        if (!value.contains("${")) {
            return value;
        }
        for (String key : this.systemValues.keySet()) {
            value = value.replace("${" + key.toUpperCase() + "}", this.systemValues.get(key));
        }
        return value;
    }

    @Override
    public Integer getPropertyAsInteger(String property, Integer defaultValue) {
        String value = this.properties.get(property);
        return value != null ? Integer.valueOf(value) : defaultValue;
    }

    @Override
    public Integer getPropertyAsInteger(Enum<?> property, Integer defaultValue) {
        return this.getPropertyAsInteger(property.toString(), defaultValue);
    }

    @Override
    public Boolean getPropertyAsBoolean(String name, boolean defaultValue) {
        if (this.getProperty(name) == null) {
            return defaultValue;
        }
        if (StringUtils.isBlank((CharSequence)this.getProperty(name))) {
            return true;
        }
        return Boolean.parseBoolean(this.getProperty(name, "false"));
    }

    @Override
    public Boolean getPropertyAsBoolean(Enum<?> property, boolean defaultValue) {
        return this.getPropertyAsBoolean(property.toString(), defaultValue);
    }

    @Override
    public String getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public Optional<String> optionalProperty(String name) {
        return Optional.ofNullable(this.getProperty(name));
    }

    @Override
    public String getProperty(Enum<?> property) {
        return this.getProperty(property.toString());
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        String value = this.properties.get(name);
        return value != null ? value : defaultValue;
    }

    @Override
    public String getProperty(Enum<?> property, String defaultValue) {
        return this.getProperty(property.toString(), defaultValue);
    }

    @Override
    public void setProperty(String name, String value) {
        this.propertySetLock.lock();
        this.properties.put(name, value);
        this.propertySetLock.unlock();
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.propertySetLock.lock();
        this.properties.putAll(properties);
        this.propertySetLock.unlock();
    }

    @Override
    public void clearProperty(String name) {
        this.propertySetLock.lock();
        this.properties.remove(name);
        this.propertySetLock.unlock();
    }

    @Override
    public Map<String, String> asMap() {
        HashMap<String, String> environmentValues = new HashMap<String, String>(this.properties);
        environmentValues.putAll(this.systemValues);
        return environmentValues;
    }

    @Override
    public Map<String, String> simpleSystemPropertiesAsMap() {
        HashMap<String, String> environmentValues = new HashMap<String, String>();
        this.properties.keySet().stream().filter(key -> !key.contains(".")).forEach(key -> environmentValues.put((String)key, this.properties.get(key)));
        return environmentValues;
    }

    @Override
    public void reset() {
        TestLocalEnvironmentVariables.clear();
    }

    public static SystemEnvironmentVariables createEnvironmentVariables() {
        return SystemEnvironmentVariables.createEnvironmentVariables(new SystemEnvironmentVariables());
    }

    public static SystemEnvironmentVariables createEnvironmentVariables(Path configurationFile) {
        return SystemEnvironmentVariables.createEnvironmentVariables(configurationFile, new SystemEnvironmentVariables().withEmptyConfig());
    }

    private SystemEnvironmentVariables withEmptyConfig() {
        this.config = null;
        this.configLoaded = false;
        return this;
    }

    public static SystemEnvironmentVariables createEnvironmentVariables(Path configurationFile, SystemEnvironmentVariables environmentVariables) {
        PropertiesLocalPreferences localPreferences = new PropertiesLocalPreferences(environmentVariables.properties, configurationFile);
        try {
            localPreferences.loadPreferences();
            environmentVariables.setConfig(localPreferences.getConfig());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return environmentVariables;
    }

    private static SystemEnvironmentVariables createEnvironmentVariables(SystemEnvironmentVariables environmentVariables) {
        PropertiesLocalPreferences localPreferences = new PropertiesLocalPreferences(environmentVariables.properties);
        try {
            localPreferences.loadPreferences();
            environmentVariables.setConfig(localPreferences.getConfig());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return environmentVariables;
    }

    private EnvironmentVariables loadLocalConfig() {
        if (!this.configLoaded) {
            PropertiesLocalPreferences localPreferences = new PropertiesLocalPreferences(this.properties);
            try {
                localPreferences.loadPreferences();
                this.setConfig(localPreferences.getConfig());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.configLoaded = true;
        }
        return this;
    }

    @Override
    public Config getConfig(String prefix) {
        if (this.config != null && this.config.hasPath(prefix)) {
            return this.config.getConfig(prefix);
        }
        return ConfigFactory.empty();
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    static {
        lock = new ReentrantLock();
    }

    public static class EnvironmentUpdater {
        private final EnvironmentVariables environmentVariables;

        public EnvironmentUpdater(EnvironmentVariables environmentVariables) {
            this.environmentVariables = environmentVariables;
        }

        public void setProperty(String name, String value) {
            this.environmentVariables.setProperty(name, value);
        }

        public void reset() {
            this.environmentVariables.reset();
        }
    }
}

