/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.reports;

import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.reports.AnsiEscapes;
import net.thucydides.model.util.EnvironmentVariables;

public class AsciiColors {
    private final EnvironmentVariables environmentVariables;
    private boolean isBold;

    public AsciiColors(EnvironmentVariables environmentVariables) {
        this(environmentVariables, false);
    }

    public AsciiColors(EnvironmentVariables environmentVariables, boolean isBold) {
        this.environmentVariables = environmentVariables;
        this.isBold = isBold;
    }

    private boolean showColoredOutput() {
        return ThucydidesSystemProperty.SERENITY_CONSOLE_COLORS.booleanFrom(this.environmentVariables, false);
    }

    public AsciiColors bold() {
        return new AsciiColors(this.environmentVariables, true);
    }

    public String red(String text) {
        return this.showColoredOutput() ? this.boldPrefix() + String.valueOf(AnsiEscapes.RED) + text + String.valueOf(AnsiEscapes.RESET) : text;
    }

    private String boldPrefix() {
        return this.isBold ? AnsiEscapes.INTENSITY_BOLD.toString() : "";
    }

    public String green(String text) {
        return this.showColoredOutput() ? this.boldPrefix() + String.valueOf(AnsiEscapes.GREEN) + text + String.valueOf(AnsiEscapes.RESET) : text;
    }

    public String grey(String text) {
        return this.showColoredOutput() ? this.boldPrefix() + String.valueOf(AnsiEscapes.GREY) + text + String.valueOf(AnsiEscapes.RESET) : text;
    }

    public String yellow(String text) {
        return this.showColoredOutput() ? this.boldPrefix() + String.valueOf(AnsiEscapes.YELLOW) + text + String.valueOf(AnsiEscapes.RESET) : text;
    }

    public String cyan(String text) {
        return this.showColoredOutput() ? this.boldPrefix() + String.valueOf(AnsiEscapes.CYAN) + text + String.valueOf(AnsiEscapes.RESET) : text;
    }

    public String magenta(String text) {
        return this.showColoredOutput() ? this.boldPrefix() + String.valueOf(AnsiEscapes.MAGENTA) + text + String.valueOf(AnsiEscapes.RESET) : text;
    }

    public String white(String text) {
        return this.showColoredOutput() ? this.boldPrefix() + String.valueOf(AnsiEscapes.WHITE) + text + String.valueOf(AnsiEscapes.RESET) : text;
    }
}

