/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.Map;
import net.serenitybdd.core.PendingStepException;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.SkipNested;
import net.serenitybdd.core.eventbus.Broadcaster;
import net.serenitybdd.screenplay.Ability;
import net.serenitybdd.screenplay.Consequence;
import net.serenitybdd.screenplay.ConsequenceListener;
import net.serenitybdd.screenplay.ErrorTally;
import net.serenitybdd.screenplay.EventBusInterface;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.PerformedTaskTally;
import net.serenitybdd.screenplay.PerformsTasks;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.RefersToActor;
import net.serenitybdd.screenplay.events.ActorBeginsConsequenceCheckEvent;
import net.serenitybdd.screenplay.events.ActorBeginsPerformanceEvent;
import net.serenitybdd.screenplay.events.ActorEndsConsequenceCheckEvent;
import net.serenitybdd.screenplay.events.ActorEndsPerformanceEvent;
import net.serenitybdd.screenplay.events.ActorPerforms;
import net.serenitybdd.screenplay.exceptions.IgnoreStepException;
import net.serenitybdd.screenplay.formatting.FormattedTitle;
import net.thucydides.core.annotations.Pending;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepEventBus;

public class Actor
implements PerformsTasks,
SkipNested {
    private final String name;
    private final PerformedTaskTally taskTally = new PerformedTaskTally();
    private EventBusInterface eventBusInterface = new EventBusInterface();
    private ConsequenceListener consequenceListener = new ConsequenceListener(this.eventBusInterface);
    private Map<String, Object> notepad = Maps.newHashMap();
    private Map<Class, Ability> abilities = Maps.newHashMap();

    public Actor(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static Actor named(String name) {
        return new Actor(name);
    }

    public String getName() {
        return this.name;
    }

    public <T extends Ability> Actor can(T doSomething) {
        if (doSomething instanceof RefersToActor) {
            ((RefersToActor)((Object)doSomething)).asActor(this);
        }
        this.abilities.put(doSomething.getClass(), doSomething);
        return this;
    }

    public <T extends Ability> T abilityTo(Class<? extends T> doSomething) {
        return (T)this.abilities.get(doSomething);
    }

    public <T extends Ability> T usingAbilityTo(Class<? extends T> doSomething) {
        return this.abilityTo(doSomething);
    }

    public final void has(Performable ... todos) {
        this.attemptsTo(todos);
    }

    public final void wasAbleTo(Performable ... todos) {
        this.attemptsTo(todos);
    }

    public final void attemptsTo(Performable ... tasks) {
        this.beginPerformance();
        for (Performable task : tasks) {
            this.perform(task);
        }
        this.endPerformance();
    }

    @Override
    public <ANSWER> ANSWER asksFor(Question<ANSWER> question) {
        return question.answeredBy(this);
    }

    private <T extends Performable> void perform(T todo) {
        if (this.isPending(todo)) {
            StepEventBus.getEventBus().stepPending();
        }
        try {
            this.notifyPerformanceOf(todo);
            this.taskTally.newTask();
            todo.performAs((Actor)this);
            if (this.anOutOfStepErrorOccurred()) {
                this.eventBusInterface.mergePreviousStep();
            }
        }
        catch (Throwable exception) {
            if (!this.pendingOrIgnore(exception)) {
                this.eventBusInterface.reportStepFailureFor((Performable)todo, exception);
            }
            if (Serenity.shouldThrowErrorsImmediately() || this.isAnAssumptionFailure(exception)) {
                throw exception;
            }
        }
        finally {
            this.eventBusInterface.updateOverallResult();
        }
    }

    private <T extends Performable> void notifyPerformanceOf(T todo) {
        Broadcaster.getEventBus().post((Object)new ActorPerforms(todo));
    }

    private <T extends Performable> boolean isPending(T todo) {
        Method performAs = (Method)this.getPerformAsForClass(todo.getClass().getSuperclass()).or(this.getPerformAsForClass(todo.getClass()).orNull());
        return performAs != null && performAs.getAnnotation(Pending.class) != null;
    }

    private Optional<Method> getPerformAsForClass(Class taskClass) {
        try {
            return Optional.of((Object)taskClass.getMethod("performAs", Actor.class));
        }
        catch (NoSuchMethodException e) {
            return Optional.absent();
        }
    }

    private boolean pendingOrIgnore(Throwable exception) {
        return exception instanceof IgnoreStepException || exception instanceof PendingStepException;
    }

    private boolean isAnAssumptionFailure(Throwable e) {
        return e.getClass().getSimpleName().contains("Assumption");
    }

    public final void can(Consequence ... consequences) {
        this.should(consequences);
    }

    public final void should(String groupStepName, Consequence ... consequences) {
        try {
            String groupTitle = this.injectActorInto(groupStepName);
            StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)groupTitle));
            this.should(consequences);
        }
        catch (Throwable error) {
            throw error;
        }
        finally {
            StepEventBus.getEventBus().stepFinished();
        }
    }

    private String injectActorInto(String groupStepName) {
        return groupStepName.replaceAll("\\{0\\}", this.toString());
    }

    public final void should(Consequence ... consequences) {
        ErrorTally errorTally = new ErrorTally(this.eventBusInterface);
        this.startConsequenceCheck();
        for (Consequence consequence : consequences) {
            this.check(consequence, errorTally);
        }
        this.endConsequenceCheck();
        errorTally.reportAnyErrors();
    }

    private boolean anOutOfStepErrorOccurred() {
        if (this.eventBusInterface.aStepHasFailedInTheCurrentExample()) {
            return this.eventBusInterface.getRunningStepCount() > this.taskTally.getPerformedTaskCount();
        }
        return false;
    }

    private <T> void check(Consequence<T> consequence, ErrorTally errorTally) {
        try {
            this.eventBusInterface.startQuestion(FormattedTitle.ofConsequence(consequence));
            if (this.eventBusInterface.shouldIgnoreConsequences()) {
                this.eventBusInterface.reportStepIgnored();
            } else {
                consequence.evaluateFor(this);
                this.eventBusInterface.reportStepFinished();
            }
        }
        catch (IgnoreStepException e) {
            this.eventBusInterface.reportStepIgnored();
        }
        catch (Throwable e) {
            errorTally.recordError(consequence, e);
        }
    }

    public <ANSWER> void remember(String key, Question<ANSWER> question) {
        ANSWER answer = this.asksFor(question);
        this.notepad.put(key, answer);
    }

    public void remember(String key, Object value) {
        this.notepad.put(key, value);
    }

    public <T> T recall(String key) {
        return (T)this.notepad.get(key);
    }

    public <T> T sawAsThe(String key) {
        return this.recall(key);
    }

    public <T> T gaveAsThe(String key) {
        return this.recall(key);
    }

    private void beginPerformance() {
        Broadcaster.getEventBus().post((Object)new ActorBeginsPerformanceEvent(this.name));
    }

    private void endPerformance() {
        Broadcaster.getEventBus().post((Object)new ActorEndsPerformanceEvent(this.name));
    }

    private void startConsequenceCheck() {
        this.consequenceListener.beginConsequenceCheck();
        Broadcaster.getEventBus().post((Object)new ActorBeginsConsequenceCheckEvent(this.name));
    }

    private void endConsequenceCheck() {
        this.consequenceListener.endConsequenceCheck();
        Broadcaster.getEventBus().post((Object)new ActorEndsConsequenceCheckEvent(this.name));
    }
}

