/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.questions.QuestionWithDefinedSubject;

public interface Question<ANSWER> {
    public ANSWER answeredBy(Actor var1);

    default public String getSubject() {
        return "";
    }

    public static QuestionBuilder about(String subject) {
        return new QuestionBuilder(subject);
    }

    public static class QuestionBuilder {
        private final String subject;

        QuestionBuilder(String subject) {
            this.subject = subject;
        }

        public <T> Question<T> answeredBy(Question<T> questionToAsk) {
            return new QuestionWithDefinedSubject<T>(questionToAsk, this.subject);
        }
    }
}

