/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import net.serenitybdd.core.exceptions.SerenityManagedException;
import net.serenitybdd.screenplay.Consequence;

public class FailedConsequence {
    private final Consequence consequence;
    private final RuntimeException runtimeExceptionCause;
    private final Error errorCause;

    public FailedConsequence(Consequence consequence, Throwable cause) {
        this.consequence = consequence;
        if (cause instanceof Error) {
            this.errorCause = (Error)cause;
            this.runtimeExceptionCause = null;
        } else if (cause instanceof RuntimeException) {
            this.errorCause = null;
            this.runtimeExceptionCause = (RuntimeException)cause;
        } else {
            this.errorCause = null;
            this.runtimeExceptionCause = (RuntimeException)SerenityManagedException.detachedCopyOf((Throwable)cause);
        }
    }

    public Consequence getConsequence() {
        return this.consequence;
    }

    public Throwable getCause() {
        return this.runtimeExceptionCause != null ? this.runtimeExceptionCause : this.errorCause;
    }

    public void throwException() {
        if (this.runtimeExceptionCause != null) {
            throw this.runtimeExceptionCause;
        }
        throw this.errorCause;
    }
}

