/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import net.serenitybdd.core.parallel.Agent;
import net.serenitybdd.model.exceptions.SerenityManagedException;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Performable;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.domain.TestStep;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.util.EnvironmentVariables;

public class InParallel {
    Actor[] cast;
    EnvironmentVariables environmentVariables;

    private InParallel(Actor[] actors, EnvironmentVariables environmentVariables) {
        this.cast = actors;
        this.environmentVariables = environmentVariables;
    }

    public static InParallel theActors(Actor ... actors) {
        return new InParallel(actors, SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    public static InParallel theActors(Collection<Actor> actors) {
        return new InParallel(actors.toArray(new Actor[0]), SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    public void perform(List<Runnable> tasks) {
        this.perform(tasks.toArray(new Runnable[0]));
    }

    public void perform(Runnable ... tasks) {
        this.perform("{0}", tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(String stepName, Runnable ... tasks) {
        try {
            StepEventBus.getParallelEventBus().registerAgents((Agent[])this.cast);
            ExecutorService executorService = Executors.newFixedThreadPool(this.environmentVariables.getPropertyAsInteger("screenplay.max.parallel.tasks", Integer.valueOf(16)));
            List<Future> futures = Arrays.stream(tasks).map(task -> executorService.submit((Runnable)task)).collect(Collectors.toList());
            futures.forEach(future -> {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    if (e.getCause() instanceof AssertionError) {
                        throw (AssertionError)((Object)e.getCause());
                    }
                    if (e.getCause() instanceof Error) {
                        throw (Error)e.getCause();
                    }
                    throw new SerenityManagedException("An error occurred in one of the parallel tasks", e.getCause());
                }
            });
        }
        finally {
            StepEventBus.getParallelEventBus().mergeActivitiesToDefaultStepListener(stepName, (Agent[])this.cast);
            StepEventBus.getParallelEventBus().dropAgents((Agent[])this.cast);
            this.firstFailingStep().ifPresent(step -> {
                StepEventBus.getParallelEventBus().testFailed(step.getException().asException());
                StepEventBus.getParallelEventBus().suspendTest();
            });
        }
    }

    private Optional<TestStep> firstFailingStep() {
        return ((TestOutcome)StepEventBus.getParallelEventBus().getBaseStepListener().latestTestOutcome().get()).getFlattenedTestSteps().stream().filter(step -> step.getException() != null).findFirst();
    }

    public void eachAttemptTo(Performable ... tasks) {
        List<Runnable> runnableTasks = Arrays.stream(this.cast).map(actor -> () -> actor.attemptsTo(tasks)).collect(Collectors.toList());
        this.perform(runnableTasks.toArray(new Runnable[0]));
    }

    public void eachAttemptTo(Collection<Performable> tasks) {
        this.eachAttemptTo(tasks.toArray(new Performable[0]));
    }
}

