/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenshots.shutterbug;

import com.assertthat.selenium_shutterbug.core.PageSnapshot;
import com.assertthat.selenium_shutterbug.core.Shutterbug;
import com.assertthat.selenium_shutterbug.utils.web.ScrollStrategy;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.serenitybdd.core.photography.PhotoLens;
import net.serenitybdd.core.photography.ScreenShooter;
import net.serenitybdd.core.photography.WebDriverPhotoLens;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import net.thucydides.core.util.EnvironmentVariables;
import org.openqa.selenium.WebDriver;

public class ShutterbugScreenShooter
implements ScreenShooter {
    private final WebDriver driver;
    private final EnvironmentVariables environmentVariables;

    public ShutterbugScreenShooter(PhotoLens lens) {
        this.driver = ((WebDriverPhotoLens)lens).getDriver();
        this.environmentVariables = SystemEnvironmentVariables.currentEnvironmentVariables();
    }

    public byte[] takeScreenshot() throws IOException {
        ScrollStrategy scrollStrategy = ScrollStrategy.valueOf((String)this.environmentVariables.getValue("shutterbug.scrollstrategy", "WHOLE_PAGE"));
        int betweenScrollTimeout = Integer.parseInt(this.environmentVariables.getValue("shutterbug.betweenScrollTimeout", "100"));
        boolean useDevicePixelRatio = Boolean.parseBoolean(this.environmentVariables.getValue("shutterbug.useDevicePixelRatio", "true"));
        PageSnapshot snapshot = Shutterbug.shootPage((WebDriver)this.driver, (ScrollStrategy)scrollStrategy, (int)betweenScrollTimeout, (boolean)useDevicePixelRatio);
        return this.asByteArray(snapshot.getImage());
    }

    private byte[] asByteArray(BufferedImage image) throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)image, "png", outputStream);
            outputStream.flush();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }
}

