/*
 * Decompiled with CFR 0.152.
 */
package jade.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;

public class TimeChooser
implements ActionListener {
    private Date date;
    private int mode;
    private int retVal = 0;
    private JDialog dlg;
    private JTextField year;
    private JTextField month;
    private JTextField day;
    private JTextField hour;
    private JTextField min;
    private JTextField sec;
    JToggleButton absButton;
    JToggleButton relButton;
    public static final int ABSOLUTE = 0;
    public static final int RELATIVE = 1;
    public static final int OK = 1;
    public static final int CANCEL = 0;

    public TimeChooser() {
        this.date = null;
    }

    public TimeChooser(Date d) {
        this.date = d;
    }

    public int showEditTimeDlg(JFrame parent) {
        this.dlg = new JDialog((Frame)parent, "Edit time");
        GregorianCalendar cal = new GregorianCalendar();
        if (this.date != null) {
            cal.setTime(this.date);
        }
        JPanel timePanel = new JPanel();
        timePanel.setLayout(new GridLayout(2, 3));
        ((GridLayout)timePanel.getLayout()).setHgap(5);
        this.year = new JTextField(4);
        this.year.setEditable(false);
        this.addTimeUnitLine(timePanel, cal.get(1), this.year, "Year:", Integer.MAX_VALUE);
        this.month = new JTextField(4);
        this.month.setEditable(false);
        this.addTimeUnitLine(timePanel, cal.get(2) + 1, this.month, "Month:", 12);
        this.day = new JTextField(4);
        this.day.setEditable(false);
        this.addTimeUnitLine(timePanel, cal.get(5), this.day, "Day:", 31);
        this.hour = new JTextField(4);
        this.hour.setEditable(false);
        this.addTimeUnitLine(timePanel, cal.get(11), this.hour, "Hour:", 23);
        this.min = new JTextField(4);
        this.min.setEditable(false);
        this.addTimeUnitLine(timePanel, cal.get(12), this.min, "Min:", 59);
        this.sec = new JTextField(4);
        this.sec.setEditable(false);
        this.addTimeUnitLine(timePanel, cal.get(13), this.sec, "Sec:", 59);
        timePanel.setBorder(new TitledBorder("Time"));
        this.dlg.getContentPane().add((Component)timePanel, "Center");
        JPanel buttonPanel = new JPanel();
        JButton setButton = new JButton("Set");
        JButton resetButton = new JButton("Reset");
        JButton cancelButton = new JButton("Cancel");
        setButton.setPreferredSize(cancelButton.getPreferredSize());
        resetButton.setPreferredSize(cancelButton.getPreferredSize());
        setButton.addActionListener(this);
        resetButton.addActionListener(this);
        cancelButton.addActionListener(this);
        buttonPanel.add(setButton);
        buttonPanel.add(resetButton);
        buttonPanel.add(cancelButton);
        this.dlg.getContentPane().add((Component)buttonPanel, "South");
        this.dlg.setModal(true);
        this.dlg.pack();
        this.dlg.setResizable(false);
        if (parent != null) {
            this.dlg.setLocation(parent.getX() + (parent.getWidth() - this.dlg.getWidth()) / 2, parent.getY() + (parent.getHeight() - this.dlg.getHeight()) / 2);
        } else {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int centerX = (int)screenSize.getWidth() / 2;
            int centerY = (int)screenSize.getHeight() / 2;
            this.dlg.setLocation(centerX - this.dlg.getWidth() / 2, centerY - this.dlg.getHeight() / 2);
        }
        this.dlg.show();
        return this.retVal;
    }

    public void showViewTimeDlg(JFrame parent) {
        String s;
        this.dlg = new JDialog((Frame)parent, "View Time");
        this.dlg.getContentPane().setLayout(new BoxLayout(this.dlg.getContentPane(), 1));
        JPanel p = new JPanel();
        if (this.date == null) {
            s = "No time indication to display";
        } else {
            DateFormat df = DateFormat.getDateTimeInstance(2, 3);
            s = df.format(this.date);
        }
        JLabel l = new JLabel(s);
        p.add(l);
        this.dlg.getContentPane().add(p);
        this.dlg.getContentPane().add(Box.createVerticalStrut(5));
        p = new JPanel();
        JButton b = new JButton("Close");
        b.addActionListener(this);
        p.add(b);
        this.dlg.getContentPane().add(p);
        this.dlg.setModal(true);
        this.dlg.pack();
        this.dlg.setResizable(false);
        if (parent != null) {
            this.dlg.setLocation(parent.getX() + (parent.getWidth() - this.dlg.getWidth()) / 2, parent.getY() + (parent.getHeight() - this.dlg.getHeight()) / 2);
        } else {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int centerX = (int)screenSize.getWidth() / 2;
            int centerY = (int)screenSize.getHeight() / 2;
            this.dlg.setLocation(centerX - this.dlg.getWidth() / 2, centerY - this.dlg.getHeight() / 2);
        }
        this.dlg.show();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("Set")) {
            Integer I = new Integer(this.year.getText());
            int YY = I;
            I = new Integer(this.month.getText());
            int MM = I;
            I = new Integer(this.day.getText());
            int DD = I;
            I = new Integer(this.hour.getText());
            int hh = I;
            I = new Integer(this.min.getText());
            int mm = I;
            I = new Integer(this.sec.getText());
            int ss = I;
            GregorianCalendar cal = new GregorianCalendar(YY, MM - 1, DD, hh, mm, ss);
            this.date = cal.getTime();
            this.retVal = 1;
            this.dlg.dispose();
        } else if (command.equals("Reset")) {
            this.date = null;
            this.retVal = 1;
            this.dlg.dispose();
        } else if (command.equals("Cancel")) {
            this.retVal = 0;
            this.dlg.dispose();
        } else if (command.equals("Close")) {
            this.dlg.dispose();
        } else if (command.equals("Absolute")) {
            this.absButton.setSelected(true);
            this.relButton.setSelected(false);
            this.mode = 0;
        } else if (command.equals("Relative")) {
            this.relButton.setSelected(true);
            this.absButton.setSelected(false);
            this.mode = 1;
        }
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date d) {
        this.date = d;
    }

    private void addTimeUnitLine(JPanel tp, int timeUnit, final JTextField timeUnitEdit, final String timeUnitLabel, final int limit) {
        JPanel up = new JPanel();
        ((FlowLayout)up.getLayout()).setHgap(0);
        JLabel l = new JLabel(timeUnitLabel);
        timeUnitEdit.setText(String.valueOf(timeUnit));
        JButton B1 = new JButton("+");
        B1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Integer i = new Integer(timeUnitEdit.getText());
                int ii = i + 1;
                if (ii <= limit) {
                    timeUnitEdit.setText(String.valueOf(ii));
                }
            }
        });
        JButton B2 = new JButton("-");
        B2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int inf_limit;
                Integer i = new Integer(timeUnitEdit.getText());
                int ii = i - 1;
                int n = inf_limit = timeUnitLabel.equalsIgnoreCase("Hour:") || timeUnitLabel.equalsIgnoreCase("Min:") || timeUnitLabel.equalsIgnoreCase("Sec:") ? 0 : 1;
                if (ii >= inf_limit) {
                    timeUnitEdit.setText(String.valueOf(ii));
                }
            }
        });
        B1.setMargin(new Insets(2, 4, 2, 4));
        B2.setMargin(new Insets(2, 4, 2, 4));
        Dimension d = new Dimension();
        d.height = B1.getPreferredSize().height;
        d.width = new JLabel((String)"XXXXX").getPreferredSize().width;
        l.setPreferredSize(d);
        l.setAlignmentX(1.0f);
        timeUnitEdit.setPreferredSize(new Dimension(50, d.height));
        up.add(l);
        up.add(B1);
        up.add(timeUnitEdit);
        up.add(B2);
        tp.add(up);
    }
}

