/*
 * Decompiled with CFR 0.152.
 */
package jade.gui;

import jade.gui.TreeHelp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TreeHelp
extends JDialog {
    private JEditorPane htmlPane;
    private URL helpURL;
    private boolean playWithLineStyle = false;
    private String lineStyle = "Angled";

    public TreeHelp(Frame owner, String title, String url) {
        super(owner, title);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TreeHelp.this.disposeAsync();
            }
        });
        this.setHTMLText(url);
    }

    public TreeHelp(Dialog owner, String title, String url) {
        super(owner, title);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TreeHelp.this.disposeAsync();
            }
        });
        this.setHTMLText(url);
    }

    private void setHTMLText(String url) {
        JPanel main = new JPanel();
        main.setLayout(new BorderLayout());
        this.htmlPane = new JEditorPane();
        this.htmlPane.setEditable(false);
        this.htmlPane.setPreferredSize(new Dimension(500, 300));
        JScrollPane htmlView = new JScrollPane(this.htmlPane);
        try {
            this.htmlPane.setPage(this.getClass().getResource(url));
        }
        catch (IOException e) {
            System.err.println("Attempted to read a bad URL");
        }
        main.add((Component)htmlView, "Center");
        this.setSize(500, 500);
        try {
            int x = this.getOwner().getX() + (this.getOwner().getWidth() - this.getWidth()) / 2;
            int y = this.getOwner().getY() + (this.getOwner().getHeight() - this.getHeight()) / 2;
            this.setLocation(x > 0 ? x : 0, y > 0 ? y : 0);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.getContentPane().add((Component)main, "Center");
    }

    public void disposeAsync() {
        class DisposeIt
        implements Runnable {
            private Window toDispose;
            private final /* synthetic */ TreeHelp this$0;

            public DisposeIt(TreeHelp this$0, Window w) {
                this.this$0 = this$0;
                this.toDispose = w;
            }

            public void run() {
                this.toDispose.dispose();
            }
        }
        EventQueue.invokeLater(new DisposeIt(this, this));
    }
}

