/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.dfgui;

import jade.core.AID;
import jade.domain.DFGUIAdapter;
import jade.domain.DFGUIInterface;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.gui.AboutJadeAction;
import jade.gui.JadeLogoButton;
import jade.tools.dfgui.AgentNameTableModel;
import jade.tools.dfgui.DFGUI;
import jade.tools.dfgui.DFGUIAboutAction;
import jade.tools.dfgui.DFGUICloseGuiAction;
import jade.tools.dfgui.DFGUIDeregisterAction;
import jade.tools.dfgui.DFGUIExitDFAction;
import jade.tools.dfgui.DFGUIFederateAction;
import jade.tools.dfgui.DFGUIModifyAction;
import jade.tools.dfgui.DFGUIRefreshAppletAction;
import jade.tools.dfgui.DFGUIRegisterAction;
import jade.tools.dfgui.DFGUISearchAction;
import jade.tools.dfgui.DFGUIViewAction;
import jade.tools.dfgui.DFGuiProperties;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;

public class DFGUI
extends JFrame
implements DFGUIInterface {
    public static int AGENT_VIEW = 0;
    public static int LASTSEARCH_VIEW = 1;
    public static int PARENT_VIEW = 2;
    public static int CHILDREN_VIEW = 3;
    DFGUIAdapter myAgent;
    AgentNameTableModel registeredModel;
    AgentNameTableModel foundModel;
    AgentNameTableModel parentModel;
    AgentNameTableModel childrenModel;
    JTable registeredTable;
    JTable foundTable;
    JTable parentTable;
    JTable childrenTable;
    JSplitPane tablePane;
    JTabbedPane tabbedPane;
    JButton modifyB;
    JButton deregB;
    JButton regNewB;
    JButton fedDFB;
    JButton viewB;
    JButton searchB;
    JButton searchWithB;
    JTextField statusField;
    JScrollPane textScroll;
    DFGUIModifyAction dfModifyAction;
    DFGUIViewAction dfViewAction;
    DFGUISearchAction dfSearchAction;
    DFGUIRegisterAction dfRegAction;
    DFGUIDeregisterAction dfDeregAction;
    DFGUIFederateAction dfFedAction;
    JButton refreshB;
    JMenuItem refreshItem;
    HashMap lastSearchResults = new HashMap();
    AID lastDF = null;

    public DFGUI() {
        Image image = this.getToolkit().getImage(this.getClass().getResource("images/df.gif"));
        this.setIconImage(image);
        this.setSize(550, 450);
        Icon viewImg = DFGuiProperties.getIcon("view");
        Icon modifyImg = DFGuiProperties.getIcon("modify");
        Icon deregImg = DFGuiProperties.getIcon("deregister");
        Icon regNewImg = DFGuiProperties.getIcon("registeragent");
        Icon fedDFImg = DFGuiProperties.getIcon("federatedf");
        Icon searchImg = DFGuiProperties.getIcon("search");
        JMenuBar jmb = new JMenuBar();
        JMenu generalMenu = new JMenu("General");
        JMenuItem item = generalMenu.add(new DFGUIExitDFAction(this));
        item = generalMenu.add(new DFGUICloseGuiAction(this));
        this.refreshItem = generalMenu.add(new DFGUIRefreshAppletAction(this));
        this.refreshItem.setVisible(false);
        jmb.add(generalMenu);
        JMenu catalogueMenu = new JMenu("Catalogue");
        this.dfModifyAction = new DFGUIModifyAction(this);
        this.dfViewAction = new DFGUIViewAction(this);
        this.dfDeregAction = new DFGUIDeregisterAction(this);
        this.dfRegAction = new DFGUIRegisterAction(this);
        this.dfSearchAction = new DFGUISearchAction(this);
        item = catalogueMenu.add(this.dfViewAction);
        item.setIcon(viewImg);
        item = catalogueMenu.add(this.dfModifyAction);
        item.setIcon(modifyImg);
        item = catalogueMenu.add(this.dfDeregAction);
        item.setIcon(deregImg);
        item = catalogueMenu.add(this.dfRegAction);
        item.setIcon(regNewImg);
        item = catalogueMenu.add(this.dfSearchAction);
        item.setIcon(searchImg);
        jmb.add(catalogueMenu);
        JMenu superDFMenu = new JMenu("Super DF");
        this.dfFedAction = new DFGUIFederateAction(this);
        item = superDFMenu.add(this.dfFedAction);
        item.setIcon(fedDFImg);
        jmb.add(superDFMenu);
        JMenu helpMenu = new JMenu("Help");
        item = helpMenu.add(new DFGUIAboutAction(this));
        item = helpMenu.add(new AboutJadeAction(this));
        jmb.add(helpMenu);
        this.setJMenuBar(jmb);
        JToolBar bar = new JToolBar();
        Icon exitImg = DFGuiProperties.getIcon("exitdf");
        JButton exitB = bar.add(new DFGUIExitDFAction(this));
        exitB.setText("");
        exitB.setIcon(exitImg);
        exitB.setToolTipText("Exit and kill the DF agent");
        Icon closeImg = DFGuiProperties.getIcon("closegui");
        JButton closeB = bar.add(new DFGUICloseGuiAction(this));
        closeB.setText("");
        closeB.setIcon(closeImg);
        closeB.setToolTipText("Close the DF GUI");
        Icon refreshImg = DFGuiProperties.getIcon("refreshapplet");
        this.refreshB = bar.add(new DFGUIRefreshAppletAction(this));
        this.refreshB.setText("");
        this.refreshB.setIcon(refreshImg);
        this.refreshB.setToolTipText("Refresh the GUI");
        this.refreshB.setVisible(false);
        bar.addSeparator();
        this.viewB = bar.add(new DFGUIViewAction(this));
        this.viewB.setText("");
        this.viewB.setIcon(viewImg);
        this.viewB.setToolTipText("View the services provided by the selected agent");
        this.modifyB = bar.add(new DFGUIModifyAction(this));
        this.modifyB.setText("");
        this.modifyB.setIcon(modifyImg);
        this.modifyB.setToolTipText("Modify the services provided by the selected agent");
        this.deregB = bar.add(new DFGUIDeregisterAction(this));
        this.deregB.setText("");
        this.deregB.setIcon(deregImg);
        this.deregB.setToolTipText("Deregister the selected agent");
        this.regNewB = bar.add(new DFGUIRegisterAction(this));
        this.regNewB.setText("");
        this.regNewB.setIcon(regNewImg);
        this.regNewB.setToolTipText("Register a new agent with this DF");
        this.searchB = bar.add(new DFGUISearchAction(this));
        this.searchB.setText("");
        this.searchB.setIcon(searchImg);
        this.searchB.setToolTipText("Search for agents matching a given description");
        bar.addSeparator();
        this.fedDFB = bar.add(new DFGUIFederateAction(this));
        this.fedDFB.setText("");
        this.fedDFB.setIcon(fedDFImg);
        this.fedDFB.setToolTipText("Federate this DF with another DF");
        bar.addSeparator();
        Icon aboutImg = DFGuiProperties.getIcon("about");
        JButton aboutB = bar.add(new DFGUIAboutAction(this));
        aboutB.setText("");
        aboutB.setIcon(aboutImg);
        aboutB.setToolTipText("About DF");
        bar.addSeparator();
        bar.add(Box.createHorizontalGlue());
        JadeLogoButton logo = new JadeLogoButton();
        bar.add(logo);
        this.getContentPane().add((Component)bar, "North");
        this.tabbedPane = new JTabbedPane();
        JPanel registerPanel = new JPanel();
        registerPanel.setLayout(new BorderLayout());
        this.registeredModel = new AgentNameTableModel();
        this.registeredTable = new JTable(this.registeredModel);
        this.registeredTable.setRowHeight(20);
        this.registeredTable.setSelectionMode(0);
        TableColumn c = this.registeredTable.getColumn(this.registeredTable.getColumnName(0));
        c.setHeaderValue("Agent name");
        c = this.registeredTable.getColumn(this.registeredTable.getColumnName(1));
        c.setHeaderValue("Addresses");
        c = this.registeredTable.getColumn(this.registeredTable.getColumnName(2));
        c.setHeaderValue("Resolvers");
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DFGUIViewAction ac = new DFGUIViewAction(DFGUI.this);
                    ac.actionPerformed(new ActionEvent(this, 0, "View"));
                }
            }
        };
        this.registeredTable.addMouseListener(mouseListener);
        KeyAdapter keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int code = e.getKeyCode();
                if (code == 3 || code == 127) {
                    DFGUIDeregisterAction ac = new DFGUIDeregisterAction(DFGUI.this);
                    ac.actionPerformed(new ActionEvent(this, 0, "Deregister"));
                }
            }
        };
        this.registeredTable.addKeyListener(keyListener);
        registerPanel.setLayout(new BorderLayout());
        JScrollPane pane = new JScrollPane();
        pane.getViewport().setView(this.registeredTable);
        registerPanel.add((Component)pane, "Center");
        registerPanel.setBorder(BorderFactory.createEtchedBorder());
        this.tabbedPane.addTab("Registrations with this DF", registerPanel);
        this.tabbedPane.setSelectedIndex(0);
        JPanel lastSearchPanel = new JPanel();
        lastSearchPanel.setLayout(new BorderLayout());
        this.foundModel = new AgentNameTableModel();
        this.foundTable = new JTable(this.foundModel);
        this.foundTable.setRowHeight(20);
        this.foundTable.setSelectionMode(0);
        this.foundTable.setToolTipText("Double click on agent name to view the services provided by the selected agent");
        c = this.foundTable.getColumn(this.foundTable.getColumnName(0));
        c.setHeaderValue("Agent name");
        c = this.foundTable.getColumn(this.foundTable.getColumnName(1));
        c.setHeaderValue("Addresses");
        c = this.foundTable.getColumn(this.foundTable.getColumnName(2));
        c.setHeaderValue("Resolvers");
        MouseAdapter mouseListener2 = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DFGUIViewAction ac = new DFGUIViewAction(DFGUI.this);
                    ac.actionPerformed(new ActionEvent(this, 0, "View"));
                }
            }
        };
        this.foundTable.addMouseListener(mouseListener2);
        lastSearchPanel.setLayout(new BorderLayout());
        pane = new JScrollPane();
        pane.getViewport().setView(this.foundTable);
        lastSearchPanel.add((Component)pane, "Center");
        lastSearchPanel.setBorder(BorderFactory.createEtchedBorder());
        this.tabbedPane.addTab("Search Result", lastSearchPanel);
        JSplitPane tablePane = new JSplitPane(0);
        tablePane.setContinuousLayout(true);
        JPanel parentPanel = new JPanel();
        parentPanel.setLayout(new BorderLayout());
        this.parentModel = new AgentNameTableModel();
        this.parentTable = new JTable(this.parentModel);
        this.parentTable.setRowHeight(20);
        this.parentTable.setSelectionMode(0);
        c = this.parentTable.getColumn(this.parentTable.getColumnName(0));
        c.setHeaderValue("Agent name");
        c = this.parentTable.getColumn(this.parentTable.getColumnName(1));
        c.setHeaderValue("Addresses");
        c = this.parentTable.getColumn(this.parentTable.getColumnName(2));
        c.setHeaderValue("Resolvers");
        MouseAdapter mouseListenerParent = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 1) {
                    DFGUI.this.childrenTable.clearSelection();
                }
                if (e.getClickCount() == 2) {
                    DFGUIViewAction ac = new DFGUIViewAction(DFGUI.this);
                    ac.actionPerformed(new ActionEvent(this, 0, "View"));
                }
            }
        };
        this.parentTable.addMouseListener(mouseListenerParent);
        parentPanel.setLayout(new BorderLayout());
        JScrollPane pane1 = new JScrollPane();
        pane1.getViewport().setView(this.parentTable);
        parentPanel.add((Component)pane1, "Center");
        parentPanel.setBorder(BorderFactory.createTitledBorder("Parents"));
        tablePane.setTopComponent(parentPanel);
        JPanel childrenPanel = new JPanel();
        childrenPanel.setLayout(new BorderLayout());
        this.childrenModel = new AgentNameTableModel();
        this.childrenTable = new JTable(this.childrenModel);
        this.childrenTable.setRowHeight(20);
        this.childrenTable.setSelectionMode(0);
        c = this.childrenTable.getColumn(this.childrenTable.getColumnName(0));
        c.setHeaderValue("Agent name");
        c = this.childrenTable.getColumn(this.childrenTable.getColumnName(1));
        c.setHeaderValue("Addresses");
        c = this.childrenTable.getColumn(this.childrenTable.getColumnName(2));
        c.setHeaderValue("Resolvers");
        MouseAdapter mouseListenerChildren = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 1) {
                    DFGUI.this.parentTable.clearSelection();
                }
                if (e.getClickCount() == 2) {
                    DFGUIViewAction ac = new DFGUIViewAction(DFGUI.this);
                    ac.actionPerformed(new ActionEvent(this, 0, "View"));
                }
            }
        };
        this.childrenTable.addMouseListener(mouseListenerChildren);
        pane1 = new JScrollPane();
        pane1.getViewport().setView(this.childrenTable);
        childrenPanel.add((Component)pane1, "Center");
        childrenPanel.setBorder(BorderFactory.createTitledBorder("Children"));
        tablePane.setBottomComponent(childrenPanel);
        tablePane.setDividerLocation(150);
        this.tabbedPane.addTab("DF Federation", tablePane);
        this.tabbedPane.addChangeListener(new tabListener());
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BorderLayout());
        statusPanel.setBorder(BorderFactory.createTitledBorder("Status"));
        this.statusField = new JTextField();
        this.statusField.setEditable(false);
        statusPanel.add((Component)this.statusField, "Center");
        this.getContentPane().add((Component)statusPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DFGUICloseGuiAction ac = new DFGUICloseGuiAction(DFGUI.this);
                ac.actionPerformed(new ActionEvent(this, 0, "Close GUI"));
            }
        });
    }

    public DFGUI(DFGUIAdapter a) {
        this();
        this.setAdapter(a);
    }

    public void setAdapter(DFGUIAdapter a) {
        try {
            this.setTitle(a.getDescriptionOfThisDF().getName().getName() + "- DF Gui");
            this.myAgent = a;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            this.setTitle("Unknown DF - DF Gui");
        }
    }

    public void showStatusMsg(String msg) {
        this.statusField.setText(msg);
    }

    private void setButton(int tab) {
        switch (tab) {
            case 0: {
                this.setDeregister(true);
                this.setRegister(true);
                this.setModify(true);
                this.setDFfed(true);
                break;
            }
            case 1: {
                this.setDeregister(true);
                this.setRegister(true);
                this.setModify(true);
                this.setDFfed(true);
                break;
            }
            case 2: {
                this.setDeregister(true);
                this.setRegister(true);
                this.setModify(false);
                this.setDFfed(true);
            }
        }
    }

    private void setRegister(boolean value) {
        this.regNewB.setEnabled(value);
        this.dfRegAction.setEnabled(value);
    }

    private void setModify(boolean value) {
        this.modifyB.setEnabled(value);
        this.dfModifyAction.setEnabled(value);
    }

    private void setDeregister(boolean value) {
        this.deregB.setEnabled(value);
        this.dfDeregAction.setEnabled(value);
    }

    private void setDFfed(boolean value) {
        this.fedDFB.setEnabled(value);
        this.dfFedAction.setEnabled(value);
    }

    public void setTab(String tab, AID df) {
        if (tab.equalsIgnoreCase("Search")) {
            this.tabbedPane.setSelectedIndex(1);
            this.tabbedPane.setTitleAt(1, "Last Search on " + df.getName());
        } else if (tab.equalsIgnoreCase("Federate")) {
            this.tabbedPane.setSelectedIndex(2);
        } else {
            this.tabbedPane.setSelectedIndex(0);
        }
    }

    public AID getSelectedAgentInTable() {
        Object out = null;
        int tab = this.tabbedPane.getSelectedIndex();
        int row = -1;
        if (tab == 0) {
            row = this.registeredTable.getSelectionModel().getMinSelectionIndex();
            out = row != -1 ? this.registeredModel.getElementAt(row) : null;
        } else if (tab == 1) {
            row = this.foundTable.getSelectionModel().getMinSelectionIndex();
            out = row != -1 ? this.foundModel.getElementAt(row) : null;
        } else if (tab == 2) {
            row = this.parentTable.getSelectionModel().getMinSelectionIndex();
            out = row != -1 ? this.parentModel.getElementAt(row) : ((row = this.childrenTable.getSelectionModel().getMinSelectionIndex()) != -1 ? this.childrenModel.getElementAt(row) : null);
        }
        return out;
    }

    public int kindOfOperation() {
        int out = -1;
        int tab = this.tabbedPane.getSelectedIndex();
        if (tab == 0) {
            out = AGENT_VIEW;
        } else if (tab == 1) {
            out = LASTSEARCH_VIEW;
        } else if (tab == 2) {
            int rowSelected = this.parentTable.getSelectionModel().getMinSelectionIndex();
            if (rowSelected != -1) {
                out = PARENT_VIEW;
            } else {
                rowSelected = this.childrenTable.getSelectionModel().getMinSelectionIndex();
                if (rowSelected != -1) {
                    out = CHILDREN_VIEW;
                }
            }
        }
        return out;
    }

    public void refresh(Iterator AIDOfAllAgentRegistered, Iterator parents, Iterator children) {
        this.registeredModel.clear();
        while (AIDOfAllAgentRegistered.hasNext()) {
            this.registeredModel.add((AID)AIDOfAllAgentRegistered.next());
        }
        this.registeredModel.fireTableDataChanged();
        this.parentModel.clear();
        while (parents.hasNext()) {
            this.parentModel.add((AID)parents.next());
        }
        this.parentModel.fireTableDataChanged();
        this.childrenModel.clear();
        while (children.hasNext()) {
            this.childrenModel.add((AID)children.next());
        }
        this.childrenModel.fireTableDataChanged();
        this.registeredTable.getSelectionModel().clearSelection();
        this.parentTable.getSelectionModel().clearSelection();
        this.childrenTable.getSelectionModel().clearSelection();
    }

    public void refreshLastSearchResults(List l, AID df) {
        this.lastDF = df;
        this.foundModel.clear();
        this.lastSearchResults.clear();
        Iterator it = l.iterator();
        while (it.hasNext()) {
            DFAgentDescription dfd = (DFAgentDescription)it.next();
            this.foundModel.add(dfd.getName());
            this.lastSearchResults.put(dfd.getName(), dfd);
        }
        this.foundModel.fireTableDataChanged();
        this.foundTable.clearSelection();
    }

    public void removeSearchResult(AID name) {
        this.foundModel.remove(name);
        this.foundModel.fireTableDataChanged();
        this.lastSearchResults.remove(name);
        this.foundTable.clearSelection();
    }

    public AID getLastDF() {
        return this.lastDF;
    }

    public void addParent(AID parentName) {
        this.parentModel.add(parentName);
        this.parentModel.fireTableDataChanged();
    }

    public void addChildren(AID childrenName) {
        this.childrenModel.add(childrenName);
        this.childrenModel.fireTableDataChanged();
    }

    public void addAgentDesc(AID name) {
        this.registeredModel.add(name);
        this.registeredModel.fireTableDataChanged();
    }

    public void removeAgentDesc(AID name, AID df) {
        this.registeredModel.remove(name);
        this.registeredModel.fireTableDataChanged();
        this.registeredTable.clearSelection();
        try {
            if (df.equals((Object)this.lastDF)) {
                this.removeSearchResult(name);
            }
        }
        catch (Exception e) {}
    }

    public void removeChildren(AID childrenName) {
        this.childrenModel.remove(childrenName);
        this.childrenModel.fireTableDataChanged();
        this.childrenTable.clearSelection();
    }

    public void removeParent(AID parentName) {
        this.parentModel.remove(parentName);
        this.parentModel.fireTableDataChanged();
        this.parentTable.clearSelection();
    }

    public void setVisible(boolean b) {
        if (b) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int centerX = (int)screenSize.getWidth() / 2;
            int centerY = (int)screenSize.getHeight() / 2;
            this.setLocation(centerX - this.getWidth() / 2, centerY - this.getHeight() / 2);
        }
        super.setVisible(b);
    }

    public void disposeAsync() {
        class DisposeIt
        implements Runnable {
            private Window toDispose;
            private final /* synthetic */ DFGUI this$0;

            public DisposeIt(DFGUI this$0, Window w) {
                this.this$0 = this$0;
                this.toDispose = w;
            }

            public void run() {
                this.toDispose.dispose();
            }
        }
        EventQueue.invokeLater(new DisposeIt(this, this));
    }

    public DFAgentDescription getDFAgentSearchDsc(AID name) {
        return (DFAgentDescription)this.lastSearchResults.get(name);
    }

    public void enableRefreshButton() {
        this.refreshB.setVisible(true);
        this.refreshItem.setVisible(true);
    }

    class tabListener
    implements ChangeListener {
        tabListener() {
        }

        public void stateChanged(ChangeEvent event) {
            Object object = event.getSource();
            if (object == DFGUI.this.tabbedPane) {
                this.tabStateChanged(event);
            }
        }

        public void tabStateChanged(ChangeEvent event) {
            int index = DFGUI.this.tabbedPane.getSelectedIndex();
            DFGUI.this.setButton(index);
        }
    }
}

