/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ConnectionEvent;
import com.ibm.as400.access.ConnectionListener;
import com.ibm.as400.access.CredentialVault;
import com.ibm.as400.access.CurrentUser;
import com.ibm.as400.access.DateTimeConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExecutionEnvironment;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.GSSTokenVault;
import com.ibm.as400.access.IdentityTokenVault;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.JVMInfo;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.ManagedProfileTokenVault;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.PasswordVault;
import com.ibm.as400.access.ProfileTokenVault;
import com.ibm.as400.access.ProxyClientConnection;
import com.ibm.as400.access.ProxyImpl;
import com.ibm.as400.access.SSLOptions;
import com.ibm.as400.access.ServerVersion;
import com.ibm.as400.access.SignonEvent;
import com.ibm.as400.access.SignonHandler;
import com.ibm.as400.access.SignonInfo;
import com.ibm.as400.access.SocketProperties;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.TokenManager;
import com.ibm.as400.access.TokenManager2;
import com.ibm.as400.access.ToolboxSignonHandler;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.ProfileTokenCredential;
import com.ibm.as400.security.auth.ProfileTokenProvider;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class AS400
implements Serializable {
    private static final String CLASSNAME = "com.ibm.as400.access.AS400";
    static boolean jdk14 = false;
    static final long serialVersionUID = 4L;
    private static final boolean PASSWORD_TRACE = false;
    public static final int FILE = 0;
    public static final int PRINT = 1;
    public static final int COMMAND = 2;
    public static final int DATAQUEUE = 3;
    public static final int DATABASE = 4;
    public static final int RECORDACCESS = 5;
    public static final int CENTRAL = 6;
    public static final int SIGNON = 7;
    public static final int USE_PORT_MAPPER = -1;
    public static final int AUTHENTICATION_SCHEME_PASSWORD = 0;
    public static final int AUTHENTICATION_SCHEME_GSS_TOKEN = 1;
    public static final int AUTHENTICATION_SCHEME_PROFILE_TOKEN = 2;
    public static final int AUTHENTICATION_SCHEME_IDENTITY_TOKEN = 3;
    public static final int AUTHENTICATION_SCHEME_DDM_EUSERIDPWD = 4;
    public static final int GSS_OPTION_MANDATORY = 0;
    public static final int GSS_OPTION_FALLBACK = 1;
    public static final int GSS_OPTION_NONE = 2;
    static boolean onAS400;
    static ServerVersion nativeVRM;
    static Class defaultSignonHandlerClass_;
    static SignonHandler defaultSignonHandler_;
    private static boolean defaultGuiAvailable_;
    private static boolean defaultMustAddLanguageLibrary_;
    private static boolean defaultMustUseSockets_;
    private static boolean defaultMustUseNetSockets_;
    private static boolean defaultMustUseSuppliedProfile_;
    private static boolean defaultThreadUsed_;
    boolean skipSignonServer = false;
    public String currentLib_ = "*CURUSR";
    public String librariesForThread_ = "*CURUSR";
    private static Vector systemList;
    private static Hashtable defaultUsers;
    private static int expirationWarning;
    private boolean useSystemExpirationWarning_ = false;
    private static int alreadyCheckedForMultipleVersions_;
    private static Object gssManager_;
    private String systemName_ = "";
    private boolean systemNameLocal_ = false;
    private String userId_ = "";
    private transient CredentialVault credVault_;
    private transient Object gssCredential_ = null;
    private String gssName_ = "";
    int gssOption_ = 1;
    private transient String proxyServer_ = "";
    private transient Object proxyClientConnection_ = null;
    private boolean guiAvailable_ = defaultGuiAvailable_;
    private boolean usePasswordCache_ = true;
    private boolean useDefaultUser_ = true;
    private boolean showCheckboxes_ = true;
    private boolean signingOn_ = false;
    SSLOptions useSSLConnection_ = null;
    private boolean mustAddLanguageLibrary_ = defaultMustAddLanguageLibrary_;
    private boolean mustUseSockets_ = defaultMustUseSockets_;
    private boolean mustUseNetSockets_ = defaultMustUseNetSockets_;
    private boolean mustUseSuppliedProfile_ = defaultMustUseSuppliedProfile_;
    private boolean threadUsed_ = defaultThreadUsed_;
    private Locale locale_ = Locale.getDefault();
    private String nlv_ = ExecutionEnvironment.getNlv(Locale.getDefault());
    private transient TimeZone timezone_;
    private SocketProperties socketProperties_ = new SocketProperties();
    transient int ccsid_ = 0;
    private transient Vector connectionListeners_ = null;
    private transient ConnectionListener dispatcher_ = null;
    transient PropertyChangeSupport propertyChangeListeners_ = null;
    transient VetoableChangeSupport vetoableChangeListeners_ = null;
    transient boolean propertiesFrozen_ = false;
    private transient AS400Impl impl_ = null;
    private transient SignonInfo signonInfo_ = null;
    private String ddmRDB_ = null;
    private transient SignonHandler signonHandler_ = null;
    private transient boolean handlerCanceled_ = false;
    private boolean forcePrompt_ = false;
    private int validateSignonTimeOut_ = 0;
    private static final String[] USRLIBL_SINGLE_VALUE;
    public String aspName = "";
    private static int nativeVersion;
    private static final int FINISHED = 0;
    private static final int VALIDATE = 1;
    private static final int PROMPT = 2;
    private static final int MAX_ITERATIONS = 20;
    private static boolean currentUserAvailable;
    private static boolean currentUserTried;
    private int bidiStringType = 0;
    public boolean bidiAS400Text = false;
    public boolean bidiAS400Varchar = false;

    public AS400() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400 object.");
        }
        this.construct();
        this.systemNameLocal_ = AS400.resolveSystemNameLocal("");
        this.proxyServer_ = AS400.resolveProxyServer(this.proxyServer_);
        this.credVault_ = new PasswordVault();
    }

    public AS400(String systemName) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400 object, system name: '" + systemName + "'");
        }
        if (systemName == null) {
            throw new NullPointerException("systemName");
        }
        this.construct();
        this.systemName_ = systemName;
        this.systemNameLocal_ = AS400.resolveSystemNameLocal(systemName);
        this.proxyServer_ = AS400.resolveProxyServer(this.proxyServer_);
        this.credVault_ = new PasswordVault();
    }

    public AS400(String systemName, String userId) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400 object, system name: '" + systemName + "' user ID: '" + userId + "'");
        }
        if (systemName == null) {
            throw new NullPointerException("systemName");
        }
        if (userId == null) {
            throw new NullPointerException("userId");
        }
        if (userId.length() > 10) {
            throw new ExtendedIllegalArgumentException("userId (" + userId + ")", 1);
        }
        this.construct();
        this.systemName_ = systemName;
        this.systemNameLocal_ = AS400.resolveSystemNameLocal(systemName);
        if (AS400.isTurkish()) {
            userId = userId.toUpperCase(Locale.ENGLISH);
            if (Trace.traceOn_) {
                Trace.log(1, "This system locale is Turkish, userId.toUpperCase(Locale.ENGLISH)");
            }
        }
        this.userId_ = userId.toUpperCase();
        this.proxyServer_ = AS400.resolveProxyServer(this.proxyServer_);
        this.credVault_ = new PasswordVault();
    }

    public AS400(String systemName, ProfileTokenCredential profileToken) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400 object with profile token, system name: '" + systemName + "'");
        }
        if (profileToken == null) {
            throw new NullPointerException("profileToken");
        }
        this.constructWithProfileToken(systemName, new ProfileTokenVault(profileToken));
    }

    public AS400(String systemName, ProfileTokenProvider tokenProvider) {
        this(systemName, tokenProvider, null);
    }

    public AS400(String systemName, ProfileTokenProvider tokenProvider, int refreshThreshold) {
        this(systemName, tokenProvider, new Integer(refreshThreshold));
    }

    private AS400(String systemName, ProfileTokenProvider tokenProvider, Integer refreshThreshold) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400 object with a profile token provider, system name: '" + systemName + "'");
        }
        if (tokenProvider == null) {
            throw new NullPointerException("tokenProvider");
        }
        if (refreshThreshold != null) {
            this.constructWithProfileToken(systemName, new ManagedProfileTokenVault(tokenProvider, refreshThreshold));
        } else {
            this.constructWithProfileToken(systemName, new ManagedProfileTokenVault(tokenProvider));
        }
    }

    private void constructWithProfileToken(String systemName, ProfileTokenVault credVault) {
        if (systemName == null) {
            throw new NullPointerException("systemName");
        }
        this.construct();
        this.systemName_ = systemName;
        this.systemNameLocal_ = AS400.resolveSystemNameLocal(systemName);
        this.credVault_ = credVault;
        this.proxyServer_ = AS400.resolveProxyServer(this.proxyServer_);
    }

    public AS400(String systemName, String userId, String password) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400 object, system name: '" + systemName + "' user ID: '" + userId + "'");
        }
        if (systemName == null) {
            throw new NullPointerException("systemName");
        }
        if (userId == null) {
            throw new NullPointerException("userId");
        }
        if (userId.length() > 10) {
            throw new ExtendedIllegalArgumentException("userId (" + userId + ")", 1);
        }
        if (password == null) {
            throw new NullPointerException("password");
        }
        if (password.length() > 128) {
            throw new ExtendedIllegalArgumentException("password.length {" + password.length() + ")", 1);
        }
        this.construct();
        this.systemName_ = systemName;
        this.systemNameLocal_ = AS400.resolveSystemNameLocal(systemName);
        if (AS400.isTurkish()) {
            userId = userId.toUpperCase(Locale.ENGLISH);
            if (Trace.traceOn_) {
                Trace.log(1, "This system locale is Turkish, userId.toUpperCase(Locale.ENGLISH)");
            }
        }
        this.userId_ = userId.toUpperCase();
        this.credVault_ = new PasswordVault(password);
        this.proxyServer_ = AS400.resolveProxyServer(this.proxyServer_);
    }

    public void setIASPGroup(String IASPGroup) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, PropertyVetoException {
        this.currentLib_ = "*CURUSR";
        this.librariesForThread_ = "*CURUSR";
        String SetASPGrp = "SETASPGRP ASPGRP(" + IASPGroup + ") CURLIB(*CURUSR) USRLIBL(*CURUSR)";
        Trace.log(1, "AS400 Call command of setaspgrp " + SetASPGrp);
        CommandCall commandCall = new CommandCall(this);
        if (!commandCall.run(SetASPGrp)) {
            Trace.log(2, this, "Command SETASPGRP Failed with iasp " + IASPGroup);
        } else {
            this.aspName = IASPGroup;
        }
    }

    public void setIASPGroup(String IASPGroup, String currentLib) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, PropertyVetoException {
        if (currentLib == null || currentLib.length() == 0) {
            currentLib = "*CURUSR";
        } else if (currentLib.length() > 10) {
            Trace.log(2, "Length of parameter 'currentLib' is not valid: '" + currentLib + "'");
            throw new ExtendedIllegalArgumentException("setIASPGroup currentLib (" + currentLib + ")", 1);
        }
        this.currentLib_ = currentLib;
        this.librariesForThread_ = "*CURUSR";
        String SetASPGrp = "SETASPGRP ASPGRP(" + IASPGroup + ") CURLIB(" + currentLib + ") USRLIBL(*CURUSR)";
        Trace.log(1, "Call command of setaspgrp " + SetASPGrp);
        CommandCall commandCall = new CommandCall(this);
        if (!commandCall.run(SetASPGrp)) {
            Trace.log(2, this, "Command SETASPGRP Failed with iasp " + IASPGroup);
        } else {
            this.aspName = IASPGroup;
        }
    }

    public void setIASPGroup(String IASPGroup, String currentLib, String librariesForThread) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, PropertyVetoException {
        if (currentLib == null || currentLib.length() == 0) {
            currentLib = "*CURUSR";
        } else if (currentLib.length() > 10) {
            Trace.log(2, "Length of parameter 'currentLib' is not valid: '" + currentLib + "'");
            throw new ExtendedIllegalArgumentException("setIASPGroup currentLib (" + currentLib + ")", 1);
        }
        if (librariesForThread == null || librariesForThread.length() == 0) {
            librariesForThread = "*CURUSR";
        } else if (librariesForThread.length() > 10) {
            Trace.log(2, "Length of parameter 'librariesForThread' is not valid: '" + librariesForThread + "'");
            throw new ExtendedIllegalArgumentException("setIASPGroup librariesForThread (" + librariesForThread + ")", 1);
        }
        this.currentLib_ = currentLib;
        this.librariesForThread_ = librariesForThread;
        String SetASPGrp = "SETASPGRP ASPGRP(" + IASPGroup + ") CURLIB(" + currentLib + ") USRLIBL(" + librariesForThread + ")";
        Trace.log(1, "Call command of setaspgrp " + SetASPGrp);
        CommandCall commandCall = new CommandCall(this);
        if (!commandCall.run(SetASPGrp)) {
            Trace.log(2, this, "Command SETASPGRP Failed with iasp " + IASPGroup);
        } else {
            this.aspName = IASPGroup;
        }
    }

    public void setIASPGroup(String IASPGroup, String currentLib, String[] librariesForThread) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, PropertyVetoException {
        int i;
        if (currentLib == null || currentLib.length() == 0) {
            currentLib = "*CURUSR";
        } else if (currentLib.length() > 10) {
            Trace.log(2, "Length of parameter 'currentLib' is not valid: '" + currentLib + "'");
            throw new ExtendedIllegalArgumentException("setIASPGroup currentLib (" + currentLib + ")", 1);
        }
        if (librariesForThread == null || librariesForThread.length == 0) {
            librariesForThread = new String[]{"*CURUSR"};
        } else if (librariesForThread.length > 1) {
            if (librariesForThread.length > 250) {
                Trace.log(2, this, "Up to 250 libraries can be set for SETASPGRP USRLIBL");
                throw new ExtendedIllegalArgumentException("setIASPGroup Libraries for current thread librariesForThread(" + librariesForThread.length + ")", 1);
            }
            for (i = 0; i < librariesForThread.length; ++i) {
                String value = librariesForThread[i];
                if (value == null || value.length() < 1 || value.length() > 10) {
                    Trace.log(2, "Length of parameter in 'librariesForThread' is not valid: '" + value + "'");
                    throw new ExtendedIllegalArgumentException("setIASPGroup parameter in librariesForThread (" + value + ")", 1);
                }
                if (!(value = value.toUpperCase()).equals(USRLIBL_SINGLE_VALUE[0]) && !value.equals(USRLIBL_SINGLE_VALUE[1]) && !value.equals(USRLIBL_SINGLE_VALUE[2]) && !value.equals(USRLIBL_SINGLE_VALUE[3])) continue;
                Trace.log(2, this, value + " must be only value for parameter USRLIBL.");
                throw new ExtendedIllegalArgumentException("SETASPGRP USRLIBL parameter value (" + value + ")", 2);
            }
        }
        this.currentLib_ = currentLib;
        this.librariesForThread_ = "";
        for (i = 0; i < librariesForThread.length; ++i) {
            this.librariesForThread_ = this.librariesForThread_ + librariesForThread[i].toUpperCase() + " ";
        }
        this.librariesForThread_ = this.librariesForThread_.substring(0, this.librariesForThread_.length() - 1);
        String SetASPGrp = "SETASPGRP ASPGRP(" + IASPGroup + ") CURLIB(" + currentLib + ") USRLIBL(" + this.librariesForThread_ + ")";
        Trace.log(1, "Call command of setaspgrp " + SetASPGrp);
        CommandCall commandCall = new CommandCall(this);
        if (!commandCall.run(SetASPGrp)) {
            Trace.log(2, this, "Command SETASPGRP Failed with iasp " + IASPGroup);
        } else {
            this.aspName = IASPGroup;
        }
    }

    private AS400(String systemName, String userId, CredentialVault pwVault) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing internal AS400 object, system name: '" + systemName + "' user ID: '" + userId + "'");
        }
        if (systemName == null) {
            throw new NullPointerException("systemName");
        }
        if (userId == null) {
            throw new NullPointerException("userId");
        }
        if (userId.length() > 10) {
            throw new ExtendedIllegalArgumentException("userId (" + userId + ")", 1);
        }
        this.construct();
        this.systemName_ = systemName;
        this.systemNameLocal_ = AS400.resolveSystemNameLocal(systemName);
        if (AS400.isTurkish()) {
            userId = userId.toUpperCase(Locale.ENGLISH);
            if (Trace.traceOn_) {
                Trace.log(1, "This system locale is Turkish, userId.toUpperCase(Locale.ENGLISH)");
            }
        }
        this.userId_ = userId.toUpperCase();
        this.credVault_ = (CredentialVault)pwVault.clone();
        this.proxyServer_ = AS400.resolveProxyServer(this.proxyServer_);
    }

    public AS400(String systemName, String userId, String password, String proxyServer) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400 object, system name: '" + systemName + "' user ID: '" + userId + "' proxy server: '" + proxyServer + "'");
        }
        if (systemName == null) {
            throw new NullPointerException("systemName");
        }
        if (userId == null) {
            throw new NullPointerException("userId");
        }
        if (userId.length() > 10) {
            throw new ExtendedIllegalArgumentException("userId (" + userId + ")", 1);
        }
        if (password == null) {
            throw new NullPointerException("password");
        }
        if (password.length() > 128) {
            throw new ExtendedIllegalArgumentException("password.length {" + password.length() + ")", 1);
        }
        if (proxyServer == null) {
            throw new NullPointerException("proxyServer");
        }
        this.construct();
        this.systemName_ = systemName;
        this.systemNameLocal_ = AS400.resolveSystemNameLocal(systemName);
        if (AS400.isTurkish()) {
            userId = userId.toUpperCase(Locale.ENGLISH);
            if (Trace.traceOn_) {
                Trace.log(1, "This system locale is Turkish, userId.toUpperCase(Locale.ENGLISH)");
            }
        }
        this.userId_ = userId.toUpperCase();
        this.credVault_ = new PasswordVault(password);
        this.proxyServer_ = AS400.resolveProxyServer(proxyServer);
    }

    public AS400(AS400 system) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400 object, system: " + system);
        }
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.construct();
        this.systemName_ = system.systemName_;
        this.systemNameLocal_ = system.systemNameLocal_;
        this.userId_ = system.userId_;
        this.credVault_ = (CredentialVault)system.credVault_.clone();
        this.gssCredential_ = system.gssCredential_;
        this.gssName_ = system.gssName_;
        this.gssOption_ = system.gssOption_;
        this.proxyServer_ = system.proxyServer_;
        this.guiAvailable_ = system.guiAvailable_;
        this.usePasswordCache_ = system.usePasswordCache_;
        this.useDefaultUser_ = system.useDefaultUser_;
        this.showCheckboxes_ = system.showCheckboxes_;
        this.mustAddLanguageLibrary_ = system.mustAddLanguageLibrary_;
        this.mustUseSockets_ = system.mustUseSockets_;
        this.mustUseNetSockets_ = system.mustUseNetSockets_;
        this.mustUseSuppliedProfile_ = system.mustUseSuppliedProfile_;
        this.threadUsed_ = system.threadUsed_;
        this.locale_ = system.locale_;
        this.nlv_ = system.nlv_;
        this.socketProperties_ = system.socketProperties_;
        this.ccsid_ = system.ccsid_;
        this.ddmRDB_ = system.ddmRDB_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding connection listener.");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            if (this.connectionListeners_ == null) {
                this.connectionListeners_ = new Vector();
                this.dispatcher_ = new ConnectionListener(){

                    public void connected(ConnectionEvent event) {
                        AS400.this.fireConnectEvent(event, true);
                    }

                    public void disconnected(ConnectionEvent event) {
                        AS400.this.fireConnectEvent(event, false);
                    }
                };
            }
            if (this.impl_ != null && this.connectionListeners_.isEmpty()) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Enabling connection listener dispatcher.");
                }
                this.impl_.addConnectionListener(this.dispatcher_);
            }
            this.connectionListeners_.addElement(listener);
        }
    }

    public static void addPasswordCacheEntry(String systemName, String userId, String password) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding password cache entry, system name: '" + systemName + "' user ID: '" + userId + "'");
        }
        AS400.addPasswordCacheEntry(new AS400(systemName, userId, password));
    }

    public static void addPasswordCacheEntry(String systemName, String userId, String password, String proxyServer) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding password cache entry, system name: '" + systemName + "' user ID: '" + userId + "' proxy server: '" + proxyServer + "'");
        }
        AS400.addPasswordCacheEntry(new AS400(systemName, userId, password, proxyServer));
    }

    static void addPasswordCacheEntry(AS400 system) throws AS400SecurityException, IOException {
        system.validateSignon();
        AS400.setCacheEntry(system.systemName_, system.userId_, system.credVault_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(listener);
        }
    }

    public boolean arePropertiesFrozen() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if properties are frozen:", this.propertiesFrozen_);
        }
        return this.propertiesFrozen_;
    }

    public boolean authenticate(String userId, String password) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Authenticating signon information:", userId);
        }
        return this.validateSignon(userId, password);
    }

    private static int getNativeVersion() {
        try {
            if (nativeVersion == -1) {
                nativeVersion = Class.forName("com.ibm.as400.access.NativeVersion").newInstance().hashCode();
            }
        }
        catch (ClassNotFoundException e) {
            if (Trace.traceOn_) {
                Trace.log(1, "Not using native optimizations; class 'NativeVersion' is not found.");
            }
            nativeVersion = 0;
        }
        catch (Exception e) {
            if (Trace.traceOn_) {
                Trace.log(1, "Not using native optimizations; unexpected exception while loading native version:", (Throwable)e);
            }
            nativeVersion = 0;
        }
        return nativeVersion;
    }

    public boolean canUseNativeOptimizations() {
        if (onAS400 && !this.mustUseSockets_ && this.systemNameLocal_ && this.proxyServer_.length() == 0 && this.credVault_.getType() == 0 && AS400.getNativeVersion() == 2) {
            if (Trace.traceOn_) {
                Trace.log(1, "Using native optimizations.");
            }
            return true;
        }
        if (Trace.traceOn_) {
            int credType;
            Trace.log(1, "Not using native optimizations. Reason follows:");
            if (!onAS400) {
                Trace.log(1, "  onAS400:", onAS400);
            }
            if (this.mustUseSockets_) {
                Trace.log(1, "  mustUseSockets:", this.mustUseSockets_);
            }
            if (!this.systemNameLocal_) {
                Trace.log(1, "  systemNameLocal:", this.systemNameLocal_);
            }
            if (this.proxyServer_.length() != 0) {
                Trace.log(1, "  proxyServer:", this.proxyServer_);
            }
            if ((credType = this.credVault_.getType()) != 0) {
                Trace.log(1, "  authenticationScheme:", credType + " (" + AS400.credTypeToString(credType) + ")");
            }
            if (AS400.getNativeVersion() != 2) {
                Trace.log(1, "  nativeVersion:", AS400.getNativeVersion());
            }
        }
        return false;
    }

    private static final String credTypeToString(int credType) {
        String result;
        switch (credType) {
            case 0: {
                result = "password";
                break;
            }
            case 1: {
                result = "GSS token";
                break;
            }
            case 2: {
                result = "profile token";
                break;
            }
            case 3: {
                result = "identity token";
                break;
            }
            default: {
                result = "unrecognized";
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePassword(String oldPassword, String newPassword) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Changing password.");
        }
        if (oldPassword == null) {
            throw new NullPointerException("oldPassword");
        }
        if (oldPassword.length() > 128) {
            throw new ExtendedIllegalArgumentException("oldPassword.length {" + oldPassword.length() + ")", 1);
        }
        if (newPassword == null) {
            throw new NullPointerException("newPassword");
        }
        if (newPassword.length() > 128) {
            throw new ExtendedIllegalArgumentException("newPassword.length {" + newPassword.length() + ")", 1);
        }
        if (this.systemName_.length() == 0 && !this.systemNameLocal_) {
            Trace.log(2, "Cannot change password before system name is set.");
            throw new ExtendedIllegalStateException("systemName", 4);
        }
        this.userId_ = AS400.resolveUserId(this.userId_);
        if (this.userId_.length() == 0) {
            Trace.log(2, "Cannot change password before user ID is set.");
            throw new ExtendedIllegalStateException("userId", 4);
        }
        this.chooseImpl();
        AS400 aS400 = this;
        synchronized (aS400) {
            byte[] proxySeed = new byte[9];
            CredentialVault.rng.nextBytes(proxySeed);
            byte[] remoteSeed = this.impl_.exchangeSeed(proxySeed);
            this.signonInfo_ = this.impl_.changePassword(this.systemName_, this.systemNameLocal_, this.userId_, CredentialVault.encode(proxySeed, remoteSeed, BinaryConverter.charArrayToByteArray(oldPassword.toCharArray())), CredentialVault.encode(proxySeed, remoteSeed, BinaryConverter.charArrayToByteArray(newPassword.toCharArray())));
            if (Trace.traceOn_) {
                Trace.log(1, "Password changed successfully.");
            }
            this.credVault_.empty();
            this.credVault_ = new PasswordVault(newPassword);
        }
    }

    private synchronized void chooseImpl() {
        if (this.impl_ == null) {
            this.impl_ = (AS400Impl)this.loadImpl2("com.ibm.as400.access.AS400ImplRemote", "com.ibm.as400.access.AS400ImplProxy");
            if (this.connectionListeners_ != null && !this.connectionListeners_.isEmpty()) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Enabling connection listener dispatcher.");
                }
                this.impl_.addConnectionListener(this.dispatcher_);
            }
        }
        if (!this.propertiesFrozen_) {
            this.impl_.setState(this.useSSLConnection_, this.canUseNativeOptimizations(), this.threadUsed_, this.ccsid_, this.nlv_, this.socketProperties_, this.ddmRDB_, this.mustUseNetSockets_, this.mustUseSuppliedProfile_, this.mustAddLanguageLibrary_);
            this.propertiesFrozen_ = true;
        }
        this.impl_.setBidiStringType(this.getBidiStringType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPasswordCache() {
        if (Trace.traceOn_) {
            Trace.log(1, "Clearing password cache.");
        }
        Vector vector = systemList;
        synchronized (vector) {
            systemList.removeAllElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPasswordCache(String systemName) {
        int dotIndex;
        String longName = null;
        boolean isLocalHost = false;
        if (Trace.traceOn_) {
            Trace.log(1, "Clearing password cache, system name:", systemName);
        }
        if (systemName == null) {
            throw new NullPointerException("systemName");
        }
        boolean localHost = (systemName = AS400.resolveSystem(systemName)).equals("localhost");
        if (localHost) {
            isLocalHost = true;
            try {
                systemName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((dotIndex = systemName.indexOf(".")) > 0) {
            longName = systemName;
            systemName = systemName.substring(0, dotIndex);
        }
        Vector vector = systemList;
        synchronized (vector) {
            for (int i = systemList.size() - 1; i >= 0; --i) {
                String elementName = (String)((Object[])systemList.elementAt(i))[0];
                if (systemName.equalsIgnoreCase(elementName)) {
                    systemList.removeElementAt(i);
                    continue;
                }
                if (isLocalHost && "localhost".equalsIgnoreCase(elementName)) {
                    systemList.removeElementAt(i);
                    continue;
                }
                if (longName == null || !longName.equalsIgnoreCase(elementName)) continue;
                systemList.removeElementAt(i);
            }
        }
    }

    public void connectService(int service) throws AS400SecurityException, IOException {
        this.connectService(service, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectService(int service, int overridePort) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Connecting service:", service);
        }
        if (service < 0 || service > 7) {
            throw new ExtendedIllegalArgumentException("service (" + service + ")", 2);
        }
        this.chooseImpl();
        if (this.credVault_ instanceof ProfileTokenVault) {
            if (Trace.traceOn_) {
                Trace.log(3, "Before service connected, block the thread of refreshing profile token credential");
            }
            ((ProfileTokenVault)this.credVault_).preventRefresh();
        }
        try {
            this.signon(service == 7);
            this.impl_.connect(service, overridePort, this.skipSignonServer);
            if (Trace.traceOn_) {
                Trace.log(1, "Service connected:", AS400.getServerName(service));
            }
        }
        finally {
            if (this.credVault_ instanceof ProfileTokenVault) {
                if (Trace.traceOn_) {
                    Trace.log(3, "After service connected, notify the thread of refreshing profile token credential");
                }
                ((ProfileTokenVault)this.credVault_).allowRefresh();
            }
        }
    }

    public Socket connectToPort(int port) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Connecting port:", port);
        }
        this.chooseImpl();
        this.signon(false);
        Socket s = this.impl_.connectToPort(port);
        if (Trace.traceOn_) {
            Trace.log(1, "Port connected:", s.getPort());
        }
        return s;
    }

    public Socket connectToPort(int port, boolean forceNonLocalhost) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Connecting port:", port);
        }
        this.chooseImpl();
        this.signon(false);
        Socket s = this.impl_.connectToPort(port, forceNonLocalhost);
        if (Trace.traceOn_) {
            Trace.log(1, "Port connected:", s.getPort());
        }
        return s;
    }

    private void construct() {
        if (onAS400) {
            if (Trace.traceOn_) {
                Trace.log(1, "Running on IBM i.");
            }
            this.guiAvailable_ = false;
        }
    }

    public void disconnectAllServices() {
        if (Trace.traceOn_) {
            Trace.log(1, "Disconnecting all services...");
        }
        if (this.impl_ != null) {
            this.impl_.disconnect(0);
            this.impl_.disconnect(1);
            this.impl_.disconnect(2);
            this.impl_.disconnect(3);
            this.impl_.disconnect(4);
            this.impl_.disconnect(5);
            this.impl_.disconnect(6);
            this.impl_.disconnect(7);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "All services disconnected.");
        }
    }

    public void disconnectService(int service) {
        if (Trace.traceOn_) {
            Trace.log(1, "Disconnecting service:", service);
        }
        if (service < 0 || service > 7) {
            throw new ExtendedIllegalArgumentException("service (" + service + ")", 2);
        }
        if (this.impl_ == null) {
            return;
        }
        this.impl_.disconnect(service);
    }

    private void fireConnectEvent(ConnectionEvent event, boolean connect) {
        event.setSource(this);
        Vector targets = (Vector)this.connectionListeners_.clone();
        for (int i = 0; i < targets.size(); ++i) {
            ConnectionListener target = (ConnectionListener)targets.elementAt(i);
            if (connect) {
                target.connected(event);
                continue;
            }
            target.disconnected(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfileTokenCredential generateProfileToken(String userIdentity, int tokenType, int timeoutInterval) throws AS400SecurityException, IOException {
        this.connectService(7);
        if (userIdentity == null) {
            throw new NullPointerException("userIdentity");
        }
        ProfileTokenCredential profileToken = new ProfileTokenCredential();
        try {
            profileToken.setSystem(this);
            profileToken.setTokenType(tokenType);
            profileToken.setTimeoutInterval(timeoutInterval);
        }
        catch (PropertyVetoException e) {
            Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)e);
            throw new InternalErrorException(10, (Throwable)e);
        }
        this.chooseImpl();
        AS400 aS400 = this;
        synchronized (aS400) {
            this.impl_.generateProfileToken(profileToken, userIdentity);
        }
        return profileToken;
    }

    public static int generateVRM(int version, int release, int modification) {
        if (version < 0 || version > 65535) {
            throw new ExtendedIllegalArgumentException("version (" + version + ")", 4);
        }
        if (release < 0 || release > 255) {
            throw new ExtendedIllegalArgumentException("release (" + release + ")", 4);
        }
        if (modification < 0 || modification > 255) {
            throw new ExtendedIllegalArgumentException("modification (" + modification + ")", 4);
        }
        return (version << 16) + (release << 8) + modification;
    }

    public int getAuthenticationScheme() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting authentication scheme, scheme:", this.credVault_.getType());
        }
        return this.credVault_.getType();
    }

    public int getCcsid() {
        if (this.ccsid_ == 0) {
            if (Trace.traceOn_) {
                Trace.log(1, "Getting CCSID.");
            }
            try {
                if (Trace.traceOn_) {
                    Trace.log(1, "Retrieving CCSID from system...");
                }
                this.chooseImpl();
                this.signon(false);
                this.ccsid_ = this.signonInfo_.serverCCSID;
            }
            catch (Exception e) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Taking best guess CCSID:", (Throwable)e);
                }
                this.ccsid_ = ExecutionEnvironment.getBestGuessAS400Ccsid();
            }
            if (Trace.traceOn_) {
                Trace.log(1, "CCSID:", this.ccsid_);
            }
        }
        return this.ccsid_;
    }

    private int getDaysToExpiration() {
        if (this.signonInfo_ != null) {
            GregorianCalendar expirationDate = this.signonInfo_.expirationDate;
            GregorianCalendar now = this.signonInfo_.currentSignonDate;
            if (expirationDate != null && now != null) {
                long lNow;
                long lExpiration;
                if (jdk14) {
                    lExpiration = expirationDate.getTimeInMillis();
                    lNow = now.getTimeInMillis();
                } else {
                    lExpiration = expirationDate.getTime().getTime();
                    lNow = now.getTime().getTime();
                }
                int days = (int)((lExpiration - lNow) / 86400000L + 1L);
                return days;
            }
        }
        return 365;
    }

    public static SignonHandler getDefaultSignonHandler() {
        if (defaultSignonHandler_ != null) {
            return defaultSignonHandler_;
        }
        try {
            return (SignonHandler)defaultSignonHandlerClass_.newInstance();
        }
        catch (Exception e) {
            Trace.log(2, "Unable to cast specified default sign-on handler to a SignonHandler: " + defaultSignonHandlerClass_.getName(), (Throwable)e);
            return new ToolboxSignonHandler();
        }
    }

    public String getDDMRDB() {
        return this.ddmRDB_;
    }

    public static String getDefaultUser(String systemName) {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting the default user, system name:", systemName);
        }
        if (systemName == null) {
            throw new NullPointerException("systemName");
        }
        String defaultUser = (String)defaultUsers.get(AS400.resolveSystem(systemName));
        if (Trace.traceOn_) {
            Trace.log(1, "Default user:", defaultUser);
        }
        return defaultUser;
    }

    public synchronized String getGSSName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting GSS name:", this.gssName_);
        }
        return this.gssName_;
    }

    public int getGSSOption() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting GSS option:", this.gssOption_);
        }
        return this.gssOption_;
    }

    public AS400Impl getImpl() {
        this.chooseImpl();
        return this.impl_;
    }

    int getJobCcsid() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting job CCSID.");
        }
        this.chooseImpl();
        this.signon(false);
        if (Trace.traceOn_) {
            Trace.log(1, "Job CCSID:", this.signonInfo_.serverCCSID);
        }
        return this.signonInfo_.serverCCSID;
    }

    public String getJobCCSIDEncoding() throws AS400SecurityException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting job CCSID encoding.");
        }
        if (this.signonInfo_ == null) {
            this.chooseImpl();
            this.signon(false);
        }
        int ccsid = this.signonInfo_.serverCCSID;
        String encoding = this.impl_.ccsidToEncoding(ccsid);
        if (Trace.traceOn_) {
            Trace.log(1, "Job CCSID encoding:", encoding);
        }
        return encoding;
    }

    public Job[] getJobs(int service) {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting jobs, service:", service);
        }
        if (service < 0 || service > 7) {
            Trace.log(2, "Value of parameter 'service' is not valid:", service);
            throw new ExtendedIllegalArgumentException("service (" + service + ")", 2);
        }
        if (this.impl_ == null) {
            return new Job[0];
        }
        String[] jobStrings = this.impl_.getJobs(service);
        Job[] jobs = new Job[jobStrings.length];
        for (int i = 0; i < jobStrings.length; ++i) {
            if (Trace.traceOn_) {
                Trace.log(1, "Constructing Job for job:", jobStrings[i]);
            }
            if (jobStrings[i] == null || jobStrings[i].length() == 0) {
                return new Job[0];
            }
            StringTokenizer tokenizer = new StringTokenizer(jobStrings[i], "/");
            String jobNumber = tokenizer.nextToken();
            String jobUser = tokenizer.nextToken();
            String jobName = tokenizer.nextToken();
            jobs[i] = new Job(this, jobName, jobUser, jobNumber);
        }
        return jobs;
    }

    public Locale getLocale() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting locale: " + this.locale_);
        }
        return this.locale_;
    }

    public int getModification() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting modification level.");
        }
        if (this.signonInfo_ == null) {
            this.chooseImpl();
            this.signon(false);
        }
        int modification = this.signonInfo_.version.getModificationLevel();
        if (Trace.traceOn_) {
            Trace.log(1, "Modification level:", modification);
        }
        return modification;
    }

    public String getNLV() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting NLV:", this.nlv_);
        }
        return this.nlv_;
    }

    public GregorianCalendar getPasswordExpirationDate() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting password expiration date.");
        }
        if (this.signonInfo_ == null) {
            this.chooseImpl();
            this.signon(false);
        }
        GregorianCalendar expire = this.signonInfo_.expirationDate;
        if (Trace.traceOn_) {
            Trace.log(1, "Password expiration date: " + expire);
        }
        return expire == null ? null : (GregorianCalendar)expire.clone();
    }

    public void setUseSystemPasswordExpirationWarningDays(boolean useSystem) {
        if (useSystem) {
            if (Trace.traceOn_) {
                Trace.log(1, "Use system password expiration(QPWDEXPWRN) warning.");
            }
            this.useSystemExpirationWarning_ = true;
        } else {
            if (Trace.traceOn_) {
                Trace.log(1, "Don't use system password expiration(QPWDEXPWRN) warning.");
            }
            this.useSystemExpirationWarning_ = false;
        }
    }

    public int getSystemPasswordExpirationWarningDays() throws AS400SecurityException, IOException {
        if (this.useSystemExpirationWarning_) {
            if (this.signonInfo_ == null) {
                this.chooseImpl();
                this.signon(false);
            }
            if (this.signonInfo_.PWDexpirationWarning > 0) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Use system password expiration(QPWDEXPWRN) warning: " + this.signonInfo_.PWDexpirationWarning);
                }
                return this.signonInfo_.PWDexpirationWarning;
            }
        }
        return AS400.getPasswordExpirationWarningDays();
    }

    public boolean isInPasswordExpirationWarningDays() throws AS400SecurityException, IOException {
        boolean warn;
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if within the password expiration warning days for the system. ");
        }
        this.chooseImpl();
        this.signon(false);
        boolean bl = warn = this.getDaysToExpiration() <= this.getSystemPasswordExpirationWarningDays();
        if (Trace.traceOn_) {
            Trace.log(1, "In password expiration warning days: " + warn);
        }
        return warn;
    }

    public int getPasswordExpirationDays() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting password expiration warning days.");
        }
        this.chooseImpl();
        this.signon(false);
        int days = this.getDaysToExpiration();
        if (Trace.traceOn_) {
            Trace.log(1, "Password expiration days: " + days);
        }
        return days;
    }

    public static int getPasswordExpirationWarningDays() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting the password expiration warning days:", expirationWarning);
        }
        return expirationWarning;
    }

    public GregorianCalendar getPreviousSignonDate() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting previous signon date.");
        }
        if (this.signonInfo_ == null) {
            this.chooseImpl();
            this.signon(false);
        }
        GregorianCalendar last = this.signonInfo_.lastSignonDate;
        if (Trace.traceOn_) {
            Trace.log(1, "Previous signon date: " + last);
        }
        return last == null ? null : (GregorianCalendar)last.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfileTokenCredential getProfileToken() throws AS400SecurityException, IOException, InterruptedException {
        this.connectService(7);
        if (this.signonInfo_.profileToken != null) {
            return (ProfileTokenCredential)this.signonInfo_.profileToken;
        }
        if (this.credVault_.isEmpty() && this.credVault_.getType() != 1) {
            throw new AS400SecurityException(22);
        }
        ProfileTokenCredential profileToken = new ProfileTokenCredential();
        try {
            profileToken.setSystem(this);
            profileToken.setTokenType(1);
            profileToken.setTimeoutInterval(3600);
        }
        catch (PropertyVetoException e) {
            Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)e);
            throw new InternalErrorException(10, (Throwable)e);
        }
        byte[] proxySeed = new byte[9];
        CredentialVault.rng.nextBytes(proxySeed);
        AS400 aS400 = this;
        synchronized (aS400) {
            CredentialVault tempVault = (CredentialVault)this.credVault_.clone();
            tempVault.storeEncodedUsingExternalSeeds(proxySeed, this.impl_.exchangeSeed(proxySeed));
            this.impl_.generateProfileToken(profileToken, this.userId_, tempVault, this.gssName_);
        }
        this.signonInfo_.profileToken = profileToken;
        return profileToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfileTokenCredential getProfileToken(int tokenType, int timeoutInterval) throws AS400SecurityException, IOException, InterruptedException {
        this.connectService(7);
        if (this.credVault_.isEmpty() && this.credVault_.getType() != 1) {
            throw new AS400SecurityException(22);
        }
        if (tokenType == 3) {
            Trace.log(2, "Request not supported for renewable token type.");
            throw new AS400SecurityException(37);
        }
        ProfileTokenCredential profileToken = new ProfileTokenCredential();
        try {
            profileToken.setSystem(this);
            profileToken.setTokenType(tokenType);
            profileToken.setTimeoutInterval(timeoutInterval);
        }
        catch (PropertyVetoException e) {
            Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)e);
            throw new InternalErrorException(10, (Throwable)e);
        }
        byte[] proxySeed = new byte[9];
        CredentialVault.rng.nextBytes(proxySeed);
        AS400 aS400 = this;
        synchronized (aS400) {
            CredentialVault tempVault = (CredentialVault)this.credVault_.clone();
            tempVault.storeEncodedUsingExternalSeeds(proxySeed, this.impl_.exchangeSeed(proxySeed));
            this.impl_.generateProfileToken(profileToken, this.userId_, tempVault, this.gssName_);
        }
        return profileToken;
    }

    public ProfileTokenCredential getProfileToken(String userId, String password) throws AS400SecurityException, IOException, InterruptedException {
        return this.getProfileToken(userId, password, 1, 3600);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfileTokenCredential getProfileToken(String userId, String password, int tokenType, int timeoutInterval) throws AS400SecurityException, IOException, InterruptedException {
        this.connectService(7);
        if (userId == null) {
            throw new NullPointerException("userId");
        }
        if (userId.length() > 10) {
            throw new ExtendedIllegalArgumentException("userId", 1);
        }
        if (password == null) {
            throw new NullPointerException("password");
        }
        if (password.length() > 128) {
            throw new ExtendedIllegalArgumentException("password.length (" + password.length() + ")", 1);
        }
        if (AS400.isTurkish()) {
            userId = userId.toUpperCase(Locale.ENGLISH);
            if (Trace.traceOn_) {
                Trace.log(1, "This system locale is Turkish, userId.toUpperCase(Locale.ENGLISH)");
            }
        }
        userId = AS400.resolveUserId(userId.toUpperCase());
        ProfileTokenCredential profileToken = new ProfileTokenCredential();
        try {
            profileToken.setSystem(this);
            profileToken.setTokenType(tokenType);
            profileToken.setTimeoutInterval(timeoutInterval);
        }
        catch (PropertyVetoException e) {
            Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)e);
            throw new InternalErrorException(10, (Throwable)e);
        }
        byte[] proxySeed = new byte[9];
        CredentialVault.rng.nextBytes(proxySeed);
        AS400 aS400 = this;
        synchronized (aS400) {
            PasswordVault tempVault = new PasswordVault(password);
            tempVault.storeEncodedUsingExternalSeeds(proxySeed, this.impl_.exchangeSeed(proxySeed));
            this.impl_.generateProfileToken(profileToken, userId, tempVault, this.gssName_);
        }
        return profileToken;
    }

    public String getProxyServer() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting proxy server:", this.proxyServer_);
        }
        return this.proxyServer_;
    }

    public int getRelease() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting release level.");
        }
        if (this.signonInfo_ == null) {
            this.chooseImpl();
            this.signon(false);
        }
        int release = this.signonInfo_.version.getRelease();
        if (Trace.traceOn_) {
            Trace.log(1, "Release level:", release);
        }
        return release;
    }

    public static String getServerName(int service) {
        switch (service) {
            case 0: {
                return "as-file";
            }
            case 1: {
                return "as-netprt";
            }
            case 2: {
                return "as-rmtcmd";
            }
            case 3: {
                return "as-dtaq";
            }
            case 4: {
                return "as-database";
            }
            case 5: {
                return "as-ddm";
            }
            case 6: {
                return "as-central";
            }
            case 7: {
                return "as-signon";
            }
        }
        throw new ExtendedIllegalArgumentException("service (" + service + ")", 2);
    }

    public int getServicePort(int service) {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting service port, service:", service);
        }
        if (service < 0 || service > 7) {
            throw new ExtendedIllegalArgumentException("service (" + service + ")", 2);
        }
        if (this.systemName_.length() == 0 && !this.systemNameLocal_) {
            Trace.log(2, "Cannot get service port before system name is set.");
            throw new ExtendedIllegalStateException("systemName", 4);
        }
        this.chooseImpl();
        int port = this.impl_.getServicePort(this.systemNameLocal_ ? "localhost" : this.systemName_, service);
        if (Trace.traceOn_) {
            Trace.log(1, "Service port:", port);
        }
        return port;
    }

    public GregorianCalendar getSignonDate() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting signon date.");
        }
        this.chooseImpl();
        this.signon(false);
        GregorianCalendar current = this.signonInfo_.currentSignonDate;
        if (Trace.traceOn_) {
            Trace.log(1, "Signon date: " + current);
        }
        return current == null ? null : (GregorianCalendar)current.clone();
    }

    public SignonHandler getSignonHandler() {
        if (this.signonHandler_ != null) {
            return this.signonHandler_;
        }
        return AS400.getDefaultSignonHandler();
    }

    public SocketProperties getSocketProperties() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting socket properties.");
        }
        SocketProperties socketProperties = new SocketProperties();
        socketProperties.copyValues(this.socketProperties_);
        return socketProperties;
    }

    public String getSystemName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system name: " + this.systemName_ + ", is local:", this.systemNameLocal_);
        }
        return this.systemNameLocal_ ? "localhost" : this.systemName_;
    }

    public TimeZone getSystemTimeZone() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getTimeZone();
    }

    public TimeZone getTimeZone() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting time zone for System");
        }
        if (this.timezone_ == null) {
            this.timezone_ = DateTimeConverter.timeZoneForSystem(this);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Time zone:", this.timezone_.getDisplayName());
        }
        return this.timezone_;
    }

    public static TimeZone getDefaultTimeZone(AS400 system) {
        TimeZone timeZone;
        block5: {
            timeZone = null;
            if (system != null) {
                try {
                    timeZone = system.getTimeZone();
                }
                catch (Exception e) {
                    if (!Trace.traceOn_) break block5;
                    Trace.log(1, "Exception obtaining timezone ", (Throwable)e);
                }
            }
        }
        if (timeZone == null) {
            if (Trace.traceOn_) {
                Trace.log(1, "Defaulting to local timezone");
            }
            timeZone = TimeZone.getDefault();
        }
        return timeZone;
    }

    public String getUserId() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting user ID:", this.userId_);
        }
        this.userId_ = AS400.resolveUserId(this.userId_, this.credVault_.getType(), this.mustUseSuppliedProfile_);
        return this.userId_;
    }

    public String getUserId(boolean forceRefresh) {
        if (!forceRefresh) {
            return this.getUserId();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Getting current user ID:", this.userId_);
        }
        String currentUserID = this.userId_;
        if (this.systemNameLocal_ && onAS400) {
            try {
                currentUserID = CurrentUser.getUserID(nativeVRM.getVersionReleaseModification());
                if (currentUserID == null || currentUserID.length() == 0) {
                    currentUserID = this.userId_;
                }
            }
            catch (Throwable t) {
                if (Trace.traceOn_) {
                    Trace.log(1, t);
                }
                currentUserID = this.userId_;
            }
        }
        return currentUserID;
    }

    public int getVersion() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting version level.");
        }
        if (this.signonInfo_ == null) {
            this.chooseImpl();
            this.signon(false);
        }
        int version = this.signonInfo_.version.getVersion();
        if (Trace.traceOn_) {
            Trace.log(1, "Version level:", version);
        }
        return version;
    }

    public int getVRM() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting VRM.");
        }
        if (this.signonInfo_ == null) {
            this.chooseImpl();
            this.signon(false);
        }
        int vrm = this.signonInfo_.version.getVersionReleaseModification();
        if (Trace.traceOn_) {
            byte[] vrmBytes = new byte[4];
            BinaryConverter.intToByteArray(vrm, vrmBytes, 0);
            Trace.log(1, "VRM:", vrmBytes);
        }
        return vrm;
    }

    public void initializeConverter(int ccsid) throws UnsupportedEncodingException {
        if (Trace.traceOn_) {
            Trace.log(1, "Initializing converter for CCSID:", ccsid);
        }
        this.chooseImpl();
        try {
            this.signon(false);
            this.impl_.newConverter(ccsid);
        }
        catch (Exception e) {
            Trace.log(4, "Error initializing converter:", (Throwable)e);
            throw new UnsupportedEncodingException();
        }
    }

    public boolean isConnected() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking for any service connection...");
        }
        if (this.isConnected(0) || this.isConnected(1) || this.isConnected(2) || this.isConnected(3) || this.isConnected(4) || this.isConnected(5) || this.isConnected(6) || this.isConnected(7)) {
            if (Trace.traceOn_) {
                Trace.log(1, "A service is connected.");
            }
            return true;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "No service is connected.");
        }
        return false;
    }

    public boolean isConnected(int service) {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking for service connection:", service);
        }
        if (service < 0 || service > 7) {
            throw new ExtendedIllegalArgumentException("service (" + service + ")", 2);
        }
        if (this.impl_ == null) {
            return false;
        }
        boolean connected = this.impl_.isConnected(service);
        if (Trace.traceOn_) {
            Trace.log(1, "Service connection:", connected);
        }
        return connected;
    }

    public boolean isConnectionAlive() {
        if (Trace.traceOn_) {
            Trace.log(1, "Testing connection...");
        }
        boolean alive = this.impl_ == null ? false : this.impl_.isConnectionAlive();
        if (Trace.traceOn_) {
            Trace.log(1, "Connection status:", alive);
        }
        return alive;
    }

    public boolean isConnectionAlive(int service) {
        if (Trace.traceOn_) {
            Trace.log(1, "Testing connection...");
        }
        boolean alive = this.impl_ == null ? false : this.impl_.isConnectionAlive(service);
        if (Trace.traceOn_) {
            Trace.log(1, "Connection status:", alive);
        }
        return alive;
    }

    public boolean isGuiAvailable() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if GUI is available:", this.guiAvailable_);
        }
        return this.guiAvailable_;
    }

    public boolean isLocal() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if local:", this.systemNameLocal_);
        }
        return this.systemNameLocal_;
    }

    public boolean isMustUseSockets() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if must use sockets:", this.mustUseSockets_);
        }
        return this.mustUseSockets_;
    }

    public boolean isShowCheckboxes() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if checkboxes are shown:", this.showCheckboxes_);
        }
        return this.showCheckboxes_;
    }

    private static boolean isSystemNameLocal(String systemName) {
        if (systemName.equalsIgnoreCase("localhost")) {
            if (Trace.traceOn_) {
                Trace.log(1, "System name is 'localhost'.");
            }
            return true;
        }
        try {
            InetAddress localInet = InetAddress.getLocalHost();
            InetAddress[] remoteInet = InetAddress.getAllByName(systemName);
            for (int i = 0; i < remoteInet.length; ++i) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Comparing local address " + localInet + " to " + remoteInet[i]);
                }
                if (!localInet.equals(remoteInet[i])) continue;
                return true;
            }
        }
        catch (UnknownHostException e) {
            Trace.log(2, "Error retrieving host address information:", (Throwable)e);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "System name is not local.");
        }
        return false;
    }

    public boolean isThreadUsed() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if thread is used:", this.threadUsed_);
        }
        return this.threadUsed_;
    }

    public boolean isUseDefaultUser() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if default user is used:", this.useDefaultUser_);
        }
        return this.useDefaultUser_;
    }

    public boolean isUsePasswordCache() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if password cache is used:", this.usePasswordCache_);
        }
        return this.usePasswordCache_;
    }

    public boolean isUsePassphrase() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if use password phrase");
        }
        this.chooseImpl();
        this.signon(false);
        boolean ret = false;
        if (this.impl_ instanceof AS400ImplRemote) {
            ret = ((AS400ImplRemote)this.impl_).getPasswordType();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Use password phrase: " + ret);
        }
        return ret;
    }

    static Object loadImpl(String impl) {
        if (impl.indexOf(46) == -1) {
            impl = "com.ibm.as400.access." + impl;
        }
        if (Trace.traceOn_ && alreadyCheckedForMultipleVersions_++ < 10) {
            Trace.log(1, "Checking for multiple Toolbox versions.");
            try {
                String thisFileName = "com/ibm/as400/access/AS400.class";
                String loadFileName = impl.replace('.', '/') + ".class";
                ClassLoader thisLoader = Class.forName(CLASSNAME).getClassLoader();
                ClassLoader loadLoader = Class.forName(impl).getClassLoader();
                if (thisLoader != null && loadLoader != null) {
                    URL thisUrl = thisLoader.getResource(thisFileName);
                    URL loadUrl = loadLoader.getResource(loadFileName);
                    if (thisUrl != null && loadUrl != null) {
                        String loadDirPath;
                        String thisPath = thisUrl.getPath();
                        String loadPath = loadUrl.getPath();
                        Trace.log(1, "Path of AS400 class:", thisPath);
                        Trace.log(1, "Path of loaded impl class:", loadPath);
                        String thisDirPath = thisPath.length() <= thisFileName.length() ? "" : thisPath.substring(0, thisPath.length() - thisFileName.length() - 1);
                        String string = loadDirPath = loadPath.length() <= loadFileName.length() ? "" : loadPath.substring(0, loadPath.length() - loadFileName.length() - 1);
                        if (!thisDirPath.equals(loadDirPath)) {
                            Trace.log(4, "Toolbox classes found in two different locations: " + thisDirPath + " and " + loadDirPath);
                        }
                    }
                }
            }
            catch (ClassNotFoundException e) {
                Trace.log(1, "Class not found:", e.getMessage());
            }
            catch (Throwable e) {
                Trace.log(1, e);
            }
        }
        try {
            return Class.forName(impl).newInstance();
        }
        catch (ClassNotFoundException e1) {
            if (Trace.traceOn_) {
                Trace.log(1, "Class not found:", e1.getMessage());
            }
        }
        catch (IllegalAccessException e2) {
            Trace.log(2, "Unexpected IllegalAccessException:", (Throwable)e2);
        }
        catch (InstantiationException e3) {
            Trace.log(2, "Unexpected InstantiationException:", (Throwable)e3);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Load of implementation failed:", impl);
        }
        return null;
    }

    Object loadImpl(String impl1, String impl2) {
        Object impl;
        if (this.canUseNativeOptimizations()) {
            impl = AS400.loadImpl(impl1);
            if (impl != null) {
                return impl;
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Load of native implementation '" + impl1 + "' failed, attempting to load remote implementation.");
            }
        }
        if ((impl = AS400.loadImpl(impl2)) != null) {
            return impl;
        }
        Trace.log(1, "Load of remote implementation '" + impl2 + "' failed.");
        throw new ExtendedIllegalStateException(impl2, 11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object loadImpl2(String impl1, String impl2) {
        Object impl;
        if (this.proxyServer_.length() > 0) {
            AS400 aS400 = this;
            synchronized (aS400) {
                if (this.proxyClientConnection_ == null) {
                    this.proxyClientConnection_ = new ProxyClientConnection(this.proxyServer_, this.useSSLConnection_);
                }
            }
            ProxyImpl proxyImpl = (ProxyImpl)AS400.loadImpl(impl2);
            if (proxyImpl != null) {
                proxyImpl.construct((ProxyClientConnection)this.proxyClientConnection_);
                return proxyImpl;
            }
        }
        if ((impl = AS400.loadImpl(impl1)) != null) {
            return impl;
        }
        Trace.log(1, "Load of remote implementation '" + impl1 + "' failed.");
        throw new ExtendedIllegalStateException(impl1, 11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object loadImpl3(String impl1, String impl2, String impl3) {
        Object impl;
        if (this.proxyServer_.length() > 0) {
            AS400 aS400 = this;
            synchronized (aS400) {
                if (this.proxyClientConnection_ == null) {
                    this.proxyClientConnection_ = new ProxyClientConnection(this.proxyServer_, this.useSSLConnection_);
                }
            }
            ProxyImpl proxyImpl = (ProxyImpl)AS400.loadImpl(impl3);
            if (proxyImpl != null) {
                proxyImpl.construct((ProxyClientConnection)this.proxyClientConnection_);
                return proxyImpl;
            }
        }
        if (this.canUseNativeOptimizations()) {
            impl = AS400.loadImpl(impl1);
            if (impl != null) {
                return impl;
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Load of native implementation '" + impl1 + "' failed, attempting to load remote implementation.");
            }
        }
        if ((impl = AS400.loadImpl(impl2)) != null) {
            return impl;
        }
        Trace.log(1, "Load of remote implementation '" + impl2 + "' failed.");
        throw new ExtendedIllegalStateException(impl2, 11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promptSignon() throws AS400SecurityException, IOException {
        if (this.signingOn_) {
            Trace.log(2, "AS400.promptSignon() called while already signing on.  SignonHandler may have called a prohibited method.");
            throw new ExtendedIllegalStateException(16);
        }
        try {
            this.signingOn_ = true;
            boolean reconnecting = this.signonInfo_ != null;
            int pwState = 1;
            SignonHandler soHandler = this.getSignonHandler();
            if (this.credVault_.getType() == 0 && (this.systemName_.length() == 0 || this.userId_.length() == 0 || this.credVault_.isEmpty() || !(soHandler instanceof ToolboxSignonHandler) || this.forcePrompt_)) {
                pwState = 2;
            }
            int counter = 0;
            boolean proceed = true;
            do {
                SignonEvent soEvent;
                ++counter;
                try {
                    SignonEvent soEvent2;
                    switch (pwState) {
                        case 1: {
                            if (Trace.traceOn_) {
                                Trace.log(1, "Validate security...");
                            }
                            this.sendSignonRequest();
                            break;
                        }
                        case 2: {
                            if (!this.isGuiAvailable() && this.forcePrompt_) {
                                Trace.log(2, "No GUI available for signon dialog.");
                                this.handlerCanceled_ = true;
                                throw new AS400SecurityException(63);
                            }
                            if (Trace.traceOn_) {
                                Trace.log(1, "Calling SignonHandler...");
                            }
                            if (!(proceed = soHandler.connectionInitiated(soEvent2 = new SignonEvent(this, reconnecting), this.credVault_.isEmpty()))) {
                                Trace.log(1, "User canceled.");
                                this.handlerCanceled_ = true;
                                throw new AS400SecurityException(25);
                            }
                            this.sendSignonRequest();
                            if (!this.isUsePasswordCache() || this.credVault_.getType() != 0) break;
                            if (Trace.traceOn_) {
                                Trace.log(1, "Setting password cache entry from SignonHandler...");
                            }
                            AS400.setCacheEntry(this.systemName_, this.userId_, this.credVault_);
                            break;
                        }
                        default: {
                            Trace.log(2, "Invalid password prompt state:", pwState);
                            throw new InternalErrorException(8, pwState);
                        }
                    }
                    if (!this.skipSignonServer && this.isInPasswordExpirationWarningDays() && !(proceed = soHandler.passwordAboutToExpire(soEvent2 = new SignonEvent(this, reconnecting), this.getDaysToExpiration()))) {
                        this.handlerCanceled_ = true;
                        throw new AS400SecurityException(25);
                    }
                    pwState = 0;
                }
                catch (AS400SecurityException e) {
                    if (this.handlerCanceled_) {
                        throw e;
                    }
                    Trace.log(2, "Security exception in sign-on:", (Throwable)e);
                    soEvent = new SignonEvent(this, reconnecting, e);
                    switch (e.getReturnCode()) {
                        case 7: {
                            proceed = soHandler.passwordExpired(soEvent);
                            break;
                        }
                        case 22: {
                            proceed = soHandler.passwordMissing(soEvent);
                            break;
                        }
                        case 8: 
                        case 23: {
                            proceed = soHandler.passwordIncorrect(soEvent);
                            break;
                        }
                        case 10: 
                        case 19: 
                        case 20: {
                            proceed = soHandler.passwordLengthIncorrect(soEvent);
                            break;
                        }
                        case 9: {
                            proceed = soHandler.userIdAboutToBeDisabled(soEvent);
                            break;
                        }
                        case 32: {
                            proceed = soHandler.userIdUnknown(soEvent);
                            break;
                        }
                        case 31: {
                            proceed = soHandler.userIdDisabled(soEvent);
                            break;
                        }
                        default: {
                            soHandler.exceptionOccurred(soEvent);
                        }
                    }
                    if (!proceed) {
                        throw e;
                    }
                    pwState = 1;
                }
                catch (UnknownHostException e) {
                    soEvent = new SignonEvent(this, reconnecting);
                    proceed = soHandler.systemNameUnknown(soEvent, e);
                    if (!proceed) {
                        throw e;
                    }
                    pwState = 1;
                }
            } while (pwState != 0 && counter < 20);
            if (pwState != 0) {
                Trace.log(2, "Possible infinite loop while interacting with SignonHandler.");
                throw new AS400SecurityException(26);
            }
        }
        finally {
            this.signingOn_ = false;
            this.forcePrompt_ = false;
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "De-serializing AS400 object.");
        }
        in.defaultReadObject();
        this.construct();
        this.systemNameLocal_ = AS400.resolveSystemNameLocal(this.systemName_);
        this.proxyServer_ = AS400.resolveProxyServer("");
        this.ccsid_ = 0;
        this.propertiesFrozen_ = false;
        this.credVault_ = new PasswordVault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(ConnectionListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing connection listener.");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            if (this.connectionListeners_ != null) {
                this.connectionListeners_.removeElement(listener);
                if (this.impl_ != null && this.connectionListeners_.isEmpty()) {
                    this.impl_.removeConnectionListener(this.dispatcher_);
                }
            }
        }
    }

    public static void removeDefaultUser(String systemName) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing the default user, system name:", systemName);
        }
        if (systemName == null) {
            throw new NullPointerException("systemName");
        }
        defaultUsers.remove(AS400.resolveSystem(systemName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePasswordCacheEntry(String systemName, String userId) {
        int dotIndex;
        boolean isLocalHost = false;
        String longName = null;
        if (Trace.traceOn_) {
            Trace.log(1, "Removing password cache entry, system name: " + systemName + " user ID: " + userId);
        }
        if (systemName == null) {
            throw new NullPointerException("systemName");
        }
        if (userId == null) {
            throw new NullPointerException("userId");
        }
        if (userId.length() > 10) {
            throw new ExtendedIllegalArgumentException("userId (" + userId + ")", 1);
        }
        boolean localHost = (systemName = AS400.resolveSystem(systemName)).equals("localhost");
        if (localHost) {
            isLocalHost = true;
            try {
                systemName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((dotIndex = systemName.indexOf(".")) > 0) {
            longName = systemName;
            systemName = systemName.substring(0, dotIndex);
        }
        if (AS400.isTurkish()) {
            userId = userId.toUpperCase(Locale.ENGLISH);
            if (Trace.traceOn_) {
                Trace.log(1, "This system locale is Turkish, userId.toUpperCase(Locale.ENGLISH)");
            }
        }
        userId = AS400.resolveUserId(userId.toUpperCase());
        Vector vector = systemList;
        synchronized (vector) {
            for (int i = systemList.size() - 1; i >= 0; --i) {
                Object[] secobj = (Object[])systemList.elementAt(i);
                if (systemName.equalsIgnoreCase((String)secobj[0]) && userId.equals(secobj[1])) {
                    systemList.removeElementAt(i);
                    continue;
                }
                if (isLocalHost && "localhost".equalsIgnoreCase((String)secobj[0]) && userId.equals(secobj[1])) {
                    systemList.removeElementAt(i);
                    continue;
                }
                if (longName == null || !longName.equalsIgnoreCase((String)secobj[0]) || !userId.equals(secobj[1])) continue;
                systemList.removeElementAt(i);
            }
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(listener);
        }
    }

    public synchronized void resetAllServices() {
        if (Trace.traceOn_) {
            Trace.log(1, "Resetting all services.");
        }
        this.disconnectAllServices();
        this.signonInfo_ = null;
        this.propertiesFrozen_ = false;
        this.ccsid_ = 0;
    }

    private static String resolveProxyServer(String proxyServer) {
        if (proxyServer.length() == 0 && (proxyServer = SystemProperties.getProperty("com.ibm.as400.access.AS400.proxyServer")) == null) {
            return "";
        }
        return proxyServer;
    }

    static String resolveSystem(String systemName) {
        if (onAS400) {
            if (systemName.length() == 0) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Resolving initial system name to 'localhost'.");
                }
                return "localhost";
            }
            if (AS400.isSystemNameLocal(systemName)) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Resolving system name to 'localhost'.");
                }
                return "localhost";
            }
        }
        return systemName;
    }

    static boolean resolveSystemNameLocal(String systemName) {
        return onAS400 && (systemName.length() == 0 || AS400.isSystemNameLocal(systemName));
    }

    static String resolveUserId(String userId) {
        return AS400.resolveUserId(userId, 0, false);
    }

    static boolean currentUserAvailable() {
        if (!currentUserTried) {
            try {
                Class.forName("com.ibm.as400.access.CurrentUser");
            }
            catch (Throwable t) {
                if (Trace.traceOn_) {
                    Trace.log(1, "CurrentUser class is not available:", t);
                }
                currentUserAvailable = false;
            }
            currentUserTried = true;
        }
        return currentUserAvailable;
    }

    static String resolveUserId(String userId, int byteType, boolean mustUseSuppliedProfile) {
        if (onAS400 && !mustUseSuppliedProfile && AS400.currentUserAvailable()) {
            boolean tryToGetCurrentUserID = false;
            if (userId.length() == 0 && byteType == 0) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Resolving initial user ID.");
                }
                tryToGetCurrentUserID = true;
            }
            if (userId.equals("*CURRENT")) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Replacing *CURRENT as user ID.");
                }
                tryToGetCurrentUserID = true;
            }
            if (tryToGetCurrentUserID) {
                String currentUserID = CurrentUser.getUserID(nativeVRM.getVersionReleaseModification());
                if (Trace.traceOn_) {
                    Trace.log(1, "Current user ID:", currentUserID);
                }
                if (currentUserID != null) {
                    return currentUserID;
                }
                if (Trace.traceOn_) {
                    Trace.log(1, "Current user ID information not available, user ID: '" + userId + "'");
                }
            }
        }
        if (userId.length() > 0 && Character.isDigit(userId.charAt(0))) {
            if (Trace.traceOn_) {
                Trace.log(1, "Prepending 'Q' to numeric user ID.");
            }
            userId = "Q" + userId;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "User ID: '" + userId + "'");
        }
        return userId;
    }

    private void sendSignonRequest() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Signing-on without prompting...");
        }
        if (this.credVault_.isEmpty() && !AS400.userIdMatchesLocal(this.userId_, this.mustUseSuppliedProfile_)) {
            throw new AS400SecurityException(22);
        }
        if (this.credVault_.getType() == 1) {
            this.signonInfo_ = this.impl_.signon(this.systemName_, this.systemNameLocal_, this.userId_, this.credVault_, this.gssName_);
            if (this.gssCredential_ != null) {
                this.impl_.setGSSCredential(this.gssCredential_);
            }
            this.credVault_.empty();
        } else {
            byte[] proxySeed = new byte[9];
            CredentialVault.rng.nextBytes(proxySeed);
            CredentialVault tempVault = (CredentialVault)this.credVault_.clone();
            tempVault.storeEncodedUsingExternalSeeds(proxySeed, this.impl_.exchangeSeed(proxySeed));
            this.signonInfo_ = this.skipSignonServer ? this.impl_.skipSignon(this.systemName_, this.systemNameLocal_, this.userId_, tempVault, this.gssName_) : this.impl_.signon(this.systemName_, this.systemNameLocal_, this.userId_, tempVault, this.gssName_);
        }
        if (this.userId_.length() == 0) {
            this.userId_ = this.signonInfo_.userId;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Sign-on completed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdentityToken(byte[] identityToken) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting identity token.");
        }
        if (identityToken == null) {
            throw new NullPointerException("identityToken");
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            this.credVault_.empty();
            this.credVault_ = new IdentityTokenVault(identityToken);
            this.signonInfo_ = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setCacheEntry(String systemName, String userId, CredentialVault pwVault) {
        Vector vector = systemList;
        synchronized (vector) {
            for (int i = systemList.size() - 1; i >= 0; --i) {
                Object[] curPtr = (Object[])systemList.elementAt(i);
                if (!systemName.equalsIgnoreCase((String)curPtr[0]) || !userId.equals(curPtr[1])) continue;
                if (Trace.traceOn_) {
                    Trace.log(1, "Adding password cache entry, removing previous entry.");
                }
                systemList.removeElementAt(i);
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Adding password cache entry for " + systemName + ":" + userId + ".");
            }
            systemList.addElement(new Object[]{systemName, userId, pwVault.clone()});
        }
    }

    public void setCcsid(int ccsid) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting CCSID:", ccsid);
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set CCSID after connection has been made.");
            throw new ExtendedIllegalStateException("ccsid", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.ccsid_ = ccsid;
        } else {
            Integer oldValue = new Integer(this.ccsid_);
            Integer newValue = new Integer(ccsid);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("ccsid", oldValue, newValue);
            }
            this.ccsid_ = ccsid;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("ccsid", oldValue, newValue);
            }
        }
    }

    public void setDDMRDB(String ddmRDB) {
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set RDB name after connection has been made.");
            throw new ExtendedIllegalStateException("ddmRDB", 5);
        }
        if (ddmRDB != null && ddmRDB.length() > 18) {
            throw new ExtendedIllegalArgumentException("ddmRDB", 1);
        }
        if (this.isConnected(5)) {
            throw new ExtendedIllegalStateException("ddmRDB", 4);
        }
        this.ddmRDB_ = ddmRDB == null ? null : ddmRDB.toUpperCase();
    }

    public static void setDefaultSignonHandler(SignonHandler handler) {
        if (Trace.traceOn_) {
            if (handler == null) {
                Trace.log(1, "Setting the default sign-on handler to null.");
            } else if (defaultSignonHandler_ != null) {
                Trace.log(1, "Replacing default sign-on handler, formerly an instance of " + defaultSignonHandler_.getClass().getName());
            }
        }
        defaultSignonHandler_ = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setDefaultUser(String systemName, String userId) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting the default user, system name: '" + systemName + "' user ID: '" + userId + "'");
        }
        if (systemName == null) {
            throw new NullPointerException("systemName");
        }
        if (userId == null) {
            throw new NullPointerException("userId");
        }
        if (userId.length() > 10) {
            throw new ExtendedIllegalArgumentException("userId (" + userId + ")", 1);
        }
        systemName = AS400.resolveSystem(systemName);
        if (AS400.isTurkish()) {
            userId = userId.toUpperCase(Locale.ENGLISH);
            if (Trace.traceOn_) {
                Trace.log(1, "This system locale is Turkish, userId.toUpperCase(Locale.ENGLISH)");
            }
        }
        userId = AS400.resolveUserId(userId.toUpperCase());
        Hashtable hashtable = defaultUsers;
        synchronized (hashtable) {
            if (defaultUsers.get(systemName) == null) {
                defaultUsers.put(systemName, userId);
                return true;
            }
        }
        if (Trace.traceOn_) {
            Trace.log(4, "Default user already set, set default user failed.");
        }
        return false;
    }

    public static void setGSSManager(Object gssMgr) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting GSS manager: '" + gssMgr + "'");
        }
        gssManager_ = gssMgr;
    }

    static Object getGSSManager() {
        return gssManager_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGSSCredential(Object gssCredential) {
        if (gssCredential == null) {
            throw new NullPointerException("gssCredential");
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Setting GSS credential: '" + gssCredential + "'");
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            this.gssCredential_ = gssCredential;
            this.gssName_ = "";
            this.credVault_.empty();
            this.credVault_ = new GSSTokenVault();
            this.signonInfo_ = null;
            if (this.impl_ != null) {
                this.impl_.setGSSCredential(this.gssCredential_);
            }
        }
    }

    public void setGSSOption(int gssOption) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting GSS option:", gssOption);
        }
        if (gssOption < 0 || gssOption > 2) {
            throw new ExtendedIllegalArgumentException("gssOption (" + gssOption + ")", 2);
        }
        this.gssOption_ = gssOption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGSSName(String gssName) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting GSS name: '" + gssName + "'");
        }
        if (gssName == null) {
            throw new NullPointerException("gssName");
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            this.gssName_ = gssName;
            this.gssCredential_ = null;
            this.credVault_.empty();
            this.credVault_ = new GSSTokenVault();
            this.signonInfo_ = null;
        }
    }

    public void setGuiAvailable(boolean guiAvailable) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting GUI available:", guiAvailable);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.guiAvailable_ = guiAvailable;
        } else {
            Boolean oldValue = new Boolean(this.guiAvailable_);
            Boolean newValue = new Boolean(guiAvailable);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("guiAvailable", oldValue, newValue);
            }
            this.guiAvailable_ = guiAvailable;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("guiAvailable", oldValue, newValue);
            }
        }
    }

    public void setLocale(Locale locale) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting locale: " + locale);
        }
        if (locale == null) {
            throw new NullPointerException("locale");
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set locale after connection has been made.");
            throw new ExtendedIllegalStateException("locale", 5);
        }
        if (this.propertyChangeListeners_ == null) {
            this.locale_ = locale;
            this.nlv_ = ExecutionEnvironment.getNlv(this.locale_);
        } else {
            Locale oldValue = this.locale_;
            Locale newValue = locale;
            this.locale_ = locale;
            this.nlv_ = ExecutionEnvironment.getNlv(this.locale_);
            this.propertyChangeListeners_.firePropertyChange("locale", oldValue, newValue);
        }
    }

    public void setLocale(Locale locale, String nlv) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting locale: " + locale + ", nlv: " + this.nlv_);
        }
        if (locale == null) {
            throw new NullPointerException("locale");
        }
        if (nlv == null) {
            throw new NullPointerException("nlv");
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set locale after connection has been made.");
            throw new ExtendedIllegalStateException("locale", 5);
        }
        this.locale_ = locale;
        this.nlv_ = nlv;
    }

    public void setMustAddLanguageLibrary(boolean mustAddLanguageLibrary) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting must add language library:", this.mustAddLanguageLibrary_);
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set must add language library after connection has been made.");
            throw new ExtendedIllegalStateException("mustAddLanguageLibrary", 5);
        }
        this.mustAddLanguageLibrary_ = mustAddLanguageLibrary;
    }

    public boolean isMustAddLanguageLibrary() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if must add language library:", this.mustAddLanguageLibrary_);
        }
        return this.mustAddLanguageLibrary_;
    }

    public void setMustUseSockets(boolean mustUseSockets) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting 'must use sockets':", mustUseSockets);
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set 'must use sockets' after connection has been made.");
            throw new ExtendedIllegalStateException("mustUseSockets", 5);
        }
        this.mustUseSockets_ = mustUseSockets;
    }

    public boolean isMustUseNetSockets() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if must use net sockets:", this.mustUseNetSockets_);
        }
        return this.mustUseNetSockets_;
    }

    public void setMustUseNetSockets(boolean mustUseNetSockets) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting 'must use net sockets':", mustUseNetSockets);
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set 'must use net sockets' after connection has been made.");
            throw new ExtendedIllegalStateException("mustUseNetSockets", 5);
        }
        this.mustUseNetSockets_ = mustUseNetSockets;
    }

    public boolean isMustUseSuppliedProfile() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if must use supplied profile:", this.mustUseSuppliedProfile_);
        }
        return this.mustUseSuppliedProfile_;
    }

    public void setMustUseSuppliedProfile(boolean mustUseSuppliedProfile) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting 'must use supplied profile':", mustUseSuppliedProfile);
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set 'must use supplied profile' after connection has been made.");
            throw new ExtendedIllegalStateException("mustUseSuppliedProfile", 5);
        }
        this.mustUseSuppliedProfile_ = mustUseSuppliedProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassword(String password) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting password.");
        }
        if (password == null) {
            throw new NullPointerException("password");
        }
        if (password.length() > 128) {
            throw new ExtendedIllegalArgumentException("password.length {" + password.length() + ")", 1);
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            this.credVault_.empty();
            this.credVault_ = new PasswordVault(password);
            this.signonInfo_ = null;
        }
    }

    public static void setPasswordExpirationWarningDays(int days) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting the password expiration warning days:", days);
        }
        expirationWarning = days;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProfileToken(ProfileTokenCredential profileToken) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting profile token.");
        }
        if (profileToken == null) {
            throw new NullPointerException("profileToken");
        }
        AS400 aS400 = this;
        synchronized (aS400) {
            this.credVault_.empty();
            this.credVault_ = new ProfileTokenVault(profileToken);
            this.signonInfo_ = null;
        }
    }

    public void setProxyServer(String proxyServer) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting proxy server:", proxyServer);
        }
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set proxy server after connection has been made.");
            throw new ExtendedIllegalStateException("proxyServer", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.proxyServer_ = AS400.resolveProxyServer(proxyServer);
        } else {
            String oldValue = this.proxyServer_;
            String newValue = AS400.resolveProxyServer(proxyServer);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("proxyServer", oldValue, newValue);
            }
            this.proxyServer_ = newValue;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("proxyServer", oldValue, newValue);
            }
        }
    }

    public void setServicePort(int service, int port) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting service port, service " + service + ", port " + port);
        }
        if (service < 0 || service > 7) {
            throw new ExtendedIllegalArgumentException("service (" + service + ")", 2);
        }
        if (port < -1) {
            throw new ExtendedIllegalArgumentException("port (" + port + ")", 2);
        }
        if (this.systemName_.length() == 0 && !this.systemNameLocal_) {
            Trace.log(2, "Cannot set service port before system name is set.");
            throw new ExtendedIllegalStateException("systemName", 4);
        }
        this.chooseImpl();
        this.impl_.setServicePort(this.systemNameLocal_ ? "localhost" : this.systemName_, service, port);
    }

    public void setServicePortsToDefault() {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting service ports to default.");
        }
        if (this.systemName_.length() == 0 && !this.systemNameLocal_) {
            Trace.log(2, "Cannot set service port to default before system name is set.");
            throw new ExtendedIllegalStateException("systemName", 4);
        }
        this.chooseImpl();
        this.impl_.setServicePortsToDefault(this.systemNameLocal_ ? "localhost" : this.systemName_);
    }

    public void setShowCheckboxes(boolean showCheckboxes) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting show checkboxes:", showCheckboxes);
        }
        this.showCheckboxes_ = showCheckboxes;
    }

    public void setSignonHandler(SignonHandler handler) {
        if (Trace.traceOn_) {
            if (handler == null) {
                Trace.log(1, "Setting the sign-on handler to null.");
            }
            if (this.signonHandler_ != null) {
                Trace.log(1, "Sign-on handler was formerly an instance of " + this.signonHandler_.getClass().getName());
            }
        }
        this.signonHandler_ = handler;
    }

    public void setSocketProperties(SocketProperties socketProperties) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting socket properties: " + socketProperties);
        }
        if (socketProperties == null) {
            throw new NullPointerException("socketProperties");
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set socket properties after connection has been made.");
            throw new ExtendedIllegalStateException("socketProperties", 5);
        }
        this.socketProperties_.copyValues(socketProperties);
    }

    public void setSystemName(String systemName) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system name:", systemName);
        }
        if (systemName == null) {
            throw new NullPointerException("systemName");
        }
        if (systemName.equals(this.systemName_)) {
            return;
        }
        if (this.propertiesFrozen_ && (this.systemNameLocal_ || this.systemName_.length() != 0)) {
            Trace.log(2, "Cannot set system name after connection has been made.");
            throw new ExtendedIllegalStateException("systemName", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.systemName_ = systemName;
            this.systemNameLocal_ = AS400.resolveSystemNameLocal(systemName);
        } else {
            String oldValue = this.systemName_;
            String newValue = systemName;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("systemName", oldValue, newValue);
            }
            this.systemName_ = systemName;
            this.systemNameLocal_ = AS400.resolveSystemNameLocal(systemName);
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("systemName", oldValue, newValue);
            }
        }
    }

    public void setThreadUsed(boolean useThreads) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting thread used:", useThreads);
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set thread used after connection has been made.");
            throw new ExtendedIllegalStateException("threadUsed", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.threadUsed_ = useThreads;
        } else {
            Boolean oldValue = new Boolean(this.threadUsed_);
            Boolean newValue = new Boolean(useThreads);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("threadUsed", oldValue, newValue);
            }
            this.threadUsed_ = useThreads;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("threadUsed", oldValue, newValue);
            }
        }
    }

    public void setUseDefaultUser(boolean useDefaultUser) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting use default user:", useDefaultUser);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.useDefaultUser_ = useDefaultUser;
        } else {
            Boolean oldValue = new Boolean(this.useDefaultUser_);
            Boolean newValue = new Boolean(useDefaultUser);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("useDefaultUser", oldValue, newValue);
            }
            this.useDefaultUser_ = useDefaultUser;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("useDefaultUser", oldValue, newValue);
            }
        }
    }

    public void setUsePasswordCache(boolean usePasswordCache) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting use password cache:", usePasswordCache);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.usePasswordCache_ = usePasswordCache;
        } else {
            Boolean oldValue = new Boolean(this.usePasswordCache_);
            Boolean newValue = new Boolean(usePasswordCache);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("usePasswordCache", oldValue, newValue);
            }
            this.usePasswordCache_ = usePasswordCache;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("usePasswordCache", oldValue, newValue);
            }
        }
    }

    public void setUserId(String userId) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting user ID: '" + userId + "'");
        }
        if (userId == null) {
            throw new NullPointerException("userId");
        }
        if (userId.equals(this.userId_)) {
            return;
        }
        if (userId.length() > 10) {
            throw new ExtendedIllegalArgumentException("userId (" + userId + ")", 1);
        }
        if (this.signonInfo_ != null) {
            Trace.log(2, "Cannot set user ID after connection has been made.");
            throw new ExtendedIllegalStateException("userId", 5);
        }
        if (AS400.isTurkish()) {
            userId = userId.toUpperCase(Locale.ENGLISH);
            if (Trace.traceOn_) {
                Trace.log(1, "This system locale is Turkish, userId.toUpperCase(Locale.ENGLISH)");
            }
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.userId_ = userId.toUpperCase();
        } else {
            String oldValue = this.userId_;
            String newValue = userId.toUpperCase();
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("userId", oldValue, newValue);
            }
            this.userId_ = newValue;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("userId", oldValue, newValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void signon(boolean keepConnection) throws AS400SecurityException, IOException {
        if (this.signonInfo_ == null) {
            this.chooseImpl();
            this.userId_ = AS400.resolveUserId(this.userId_, this.credVault_.getType(), this.mustUseSuppliedProfile_);
            if (this.systemName_.length() != 0) {
                Object defaultUserId;
                if (this.userId_.length() == 0 && this.useDefaultUser_ && (defaultUserId = AS400.getDefaultUser(this.systemName_)) != null) {
                    this.userId_ = defaultUserId;
                }
                if (this.userId_.length() != 0 && this.credVault_.isEmpty() && this.usePasswordCache_) {
                    defaultUserId = systemList;
                    synchronized (defaultUserId) {
                        for (int i = systemList.size() - 1; i >= 0; --i) {
                            Object[] secobj = (Object[])systemList.elementAt(i);
                            if (!this.systemName_.equalsIgnoreCase((String)secobj[0]) || !this.userId_.equals(secobj[1])) continue;
                            this.credVault_ = (CredentialVault)((CredentialVault)secobj[2]).clone();
                        }
                    }
                }
            }
            try {
                if (this.systemName_.length() != 0 && this.proxyServer_.length() == 0 && this.credVault_.isEmpty() && (this.credVault_.getType() == 1 || this.gssOption_ != 2)) {
                    byte[] newBytes = this.gssCredential_ == null ? TokenManager.getGSSToken(this.systemName_, this.gssName_) : TokenManager2.getGSSToken(this.systemName_, this.gssCredential_);
                    this.credVault_ = new GSSTokenVault(newBytes);
                }
            }
            catch (Throwable e) {
                if (this.credVault_.getType() == 1 || this.gssOption_ == 0) {
                    Trace.log(2, "Error retrieving GSSToken:", e);
                    throw new AS400SecurityException(62, e);
                }
                Trace.log(1, "GSSToken is not available:", e.getMessage());
                Trace.log(1, "Tolerated exception retrieving GSSToken:", e);
            }
            this.promptSignon();
            if (!keepConnection) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Disconnecting temporary connection for validating signon info.");
                }
                this.impl_.disconnect(7);
            }
        }
    }

    public String toString() {
        return "AS400 (system name: '" + this.systemName_ + "' user ID: '" + this.userId_ + "'):" + super.toString();
    }

    private static boolean userIdMatchesLocal(String userId, boolean mustUseSuppliedProfile) {
        boolean result;
        if (Trace.traceOn_) {
            Trace.log(1, "Determining if specified userID (" + userId + ") matches current userID.");
        }
        if (onAS400 && !mustUseSuppliedProfile && AS400.currentUserAvailable()) {
            String currentUserID = CurrentUser.getUserID(nativeVRM.getVersionReleaseModification());
            if (currentUserID == null) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Current userID information not available.");
                }
                result = false;
            } else {
                result = userId.equals(currentUserID);
                if (Trace.traceOn_ && !result) {
                    Trace.log(1, "Specified userID (" + userId + ") does not match current userID (" + currentUserID + ").");
                }
            }
        } else {
            result = false;
            if (Trace.traceOn_) {
                if (!onAS400) {
                    Trace.log(1, "Not running on IBM i.");
                }
                if (mustUseSuppliedProfile) {
                    Trace.log(1, "Caller specified must use supplied profile.");
                }
                if (!AS400.currentUserAvailable()) {
                    Trace.log(1, "Class CurrentUser is not available.");
                }
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Determined that specified userID (" + userId + ") " + (result ? "matches" : "does not match") + " current userID.");
        }
        return result;
    }

    public boolean validateSignon() throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Validating Signon.");
        }
        if (this.systemName_.length() == 0 && !this.systemNameLocal_) {
            Trace.log(2, "Cannot validate signon before system name is set.");
            throw new ExtendedIllegalStateException("systemName", 4);
        }
        this.userId_ = AS400.resolveUserId(this.userId_);
        if (this.userId_.length() == 0) {
            Trace.log(2, "Cannot validate signon before user ID is set.");
            throw new ExtendedIllegalStateException("userId", 4);
        }
        return this.validateSignon(this.userId_, this.credVault_);
    }

    public boolean validateSignon(String password) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Validating Signon, with password.");
        }
        if (password == null) {
            throw new NullPointerException("password");
        }
        if (password.length() > 128) {
            throw new ExtendedIllegalArgumentException("password.length {" + password.length() + ")", 1);
        }
        if (this.systemName_.length() == 0 && !this.systemNameLocal_) {
            Trace.log(2, "Cannot validate signon before system name is set.");
            throw new ExtendedIllegalStateException("systemName", 4);
        }
        this.userId_ = AS400.resolveUserId(this.userId_);
        if (this.userId_.length() == 0) {
            Trace.log(2, "Cannot validate signon before user ID is set.");
            throw new ExtendedIllegalStateException("userId", 4);
        }
        PasswordVault tempVault = new PasswordVault(password);
        return this.validateSignon(this.userId_, tempVault);
    }

    public boolean validateSignon(String userId, String password) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Validating signon, user ID: '" + userId + "'");
        }
        if (userId == null) {
            throw new NullPointerException("userId");
        }
        if (userId.length() > 10) {
            throw new ExtendedIllegalArgumentException("userId (" + userId + ")", 1);
        }
        if (password == null) {
            throw new NullPointerException("password");
        }
        if (password.length() > 128) {
            throw new ExtendedIllegalArgumentException("password.length {" + password.length() + ")", 1);
        }
        if (this.systemName_.length() == 0 && !this.systemNameLocal_) {
            Trace.log(2, "Cannot validate signon before system name is set.");
            throw new ExtendedIllegalStateException("systemName", 4);
        }
        PasswordVault tempVault = new PasswordVault(password);
        if (AS400.isTurkish()) {
            userId = userId.toUpperCase(Locale.ENGLISH);
            if (Trace.traceOn_) {
                Trace.log(1, "This system locale is Turkish, userId.toUpperCase(Locale.ENGLISH)");
            }
        }
        return this.validateSignon(userId.toUpperCase(), tempVault);
    }

    private boolean validateSignon(String userId, CredentialVault pwVault) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Creating temporary connection for validating signon info.");
        }
        AS400 validationSystem = new AS400(this.systemName_, userId, pwVault);
        validationSystem.proxyServer_ = this.proxyServer_;
        validationSystem.guiAvailable_ = false;
        validationSystem.usePasswordCache_ = false;
        validationSystem.useDefaultUser_ = false;
        validationSystem.useSSLConnection_ = this.useSSLConnection_;
        validationSystem.mustUseSockets_ = true;
        validationSystem.mustUseNetSockets_ = this.mustUseNetSockets_;
        validationSystem.mustUseSuppliedProfile_ = this.mustUseSuppliedProfile_;
        validationSystem.socketProperties_ = this.socketProperties_;
        if (this.validateSignonTimeOut_ > 0) {
            validationSystem.socketProperties_.setSoTimeout(this.validateSignonTimeOut_);
        }
        validationSystem.signon(false);
        return true;
    }

    void forcePrompt() {
        this.forcePrompt_ = true;
    }

    public void setBidiStringType(int bidiStringType) {
        this.bidiStringType = bidiStringType;
    }

    public int getBidiStringType() {
        return this.bidiStringType;
    }

    void setSignonInfo(int serverCCSID, int serverVersion, String userId) {
        if (this.signonInfo_ == null) {
            this.signonInfo_ = new SignonInfo();
        }
        this.signonInfo_.serverCCSID = serverCCSID;
        this.signonInfo_.version = new ServerVersion(serverVersion);
        this.signonInfo_.userId = userId;
        this.ccsid_ = this.signonInfo_.serverCCSID;
    }

    public static boolean isTurkish() {
        Locale Turkishlocale;
        Locale defaultLocale = Locale.getDefault();
        return defaultLocale.equals(Turkishlocale = new Locale("tr", "TR", ""));
    }

    public int getvalidateSignonTimeOut() {
        return this.validateSignonTimeOut_;
    }

    public void setvalidateSignonTimeOut(int validateSignonTimeOut) {
        this.validateSignonTimeOut_ = validateSignonTimeOut;
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
        jdk14 = JVMInfo.isJDK14();
        onAS400 = false;
        nativeVRM = null;
        defaultSignonHandlerClass_ = ToolboxSignonHandler.class;
        defaultGuiAvailable_ = true;
        defaultMustAddLanguageLibrary_ = false;
        defaultMustUseSockets_ = false;
        defaultMustUseNetSockets_ = false;
        defaultMustUseSuppliedProfile_ = false;
        defaultThreadUsed_ = true;
        try {
            String s = System.getProperty("os.name");
            if (Trace.traceOn_) {
                Trace.log(1, "Detected os.name:", s);
            }
            if (s != null && s.equalsIgnoreCase("OS/400")) {
                char[] versionChars;
                String version = System.getProperty("os.version");
                if (Trace.traceOn_) {
                    Trace.log(1, "Detected os.version:", version);
                }
                if (version != null && (versionChars = version.toCharArray()).length == 6) {
                    int vrm = ((versionChars[1] & 0xF) << 16) + ((versionChars[3] & 0xF) << 8) + (versionChars[5] & 0xF);
                    nativeVRM = new ServerVersion(vrm);
                }
                onAS400 = true;
            }
        }
        catch (SecurityException e) {
            Trace.log(4, "Error retrieving os.name:", (Throwable)e);
        }
        String propVal = SystemProperties.getProperty("com.ibm.as400.access.AS400.signonHandler");
        if (propVal != null) {
            try {
                defaultSignonHandlerClass_ = Class.forName(propVal);
            }
            catch (Exception e) {
                Trace.log(4, "Error retrieving default sign-on handler (specified by property):", (Throwable)e);
                defaultSignonHandlerClass_ = ToolboxSignonHandler.class;
            }
        }
        if ((propVal = SystemProperties.getProperty("com.ibm.as400.access.AS400.guiAvailable")) != null) {
            try {
                defaultGuiAvailable_ = Boolean.valueOf(propVal);
            }
            catch (Exception e) {
                Trace.log(4, "Error retrieving guiAvailable property value:", (Throwable)e);
            }
        }
        if ((propVal = SystemProperties.getProperty("com.ibm.as400.access.AS400.mustAddLanguageLibrary")) != null) {
            try {
                defaultMustAddLanguageLibrary_ = Boolean.valueOf(propVal);
            }
            catch (Exception e) {
                Trace.log(4, "Error retrieving mustAddLanguageLibrary property value:", (Throwable)e);
            }
        }
        if ((propVal = SystemProperties.getProperty("com.ibm.as400.access.AS400.mustUseSockets")) != null) {
            try {
                defaultMustUseSockets_ = Boolean.valueOf(propVal);
            }
            catch (Exception e) {
                Trace.log(4, "Error retrieving mustUseSockets property value:", (Throwable)e);
            }
        }
        if ((propVal = SystemProperties.getProperty("com.ibm.as400.access.AS400.mustUseNetSockets")) != null) {
            try {
                defaultMustUseNetSockets_ = Boolean.valueOf(propVal);
            }
            catch (Exception e) {
                Trace.log(4, "Error retrieving mustUseNetSockets property value:", (Throwable)e);
            }
        }
        if ((propVal = SystemProperties.getProperty("com.ibm.as400.access.AS400.mustUseSuppliedProfile")) != null) {
            try {
                defaultMustUseSuppliedProfile_ = Boolean.valueOf(propVal);
            }
            catch (Exception e) {
                Trace.log(4, "Error retrieving mustUseSuppliedProfile property value:", (Throwable)e);
            }
        }
        if ((propVal = SystemProperties.getProperty("com.ibm.as400.access.AS400.threadUsed")) != null) {
            try {
                defaultThreadUsed_ = Boolean.valueOf(propVal);
            }
            catch (Exception e) {
                Trace.log(4, "Error retrieving threadUsed property value:", (Throwable)e);
            }
        }
        systemList = new Vector();
        defaultUsers = new Hashtable();
        expirationWarning = 7;
        alreadyCheckedForMultipleVersions_ = 0;
        gssManager_ = null;
        USRLIBL_SINGLE_VALUE = new String[]{"*CURSYSBAS", "*CURUSR", "*SYSVAL", "*NONE"};
        nativeVersion = -1;
        currentUserAvailable = true;
        currentUserTried = false;
    }
}

